/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import org.apache.commons.lang3.StringUtils;

public class DMSNumberFormat {
    private String source;
    private int position;
    private int maxposition;
    private int column;
    private final boolean requireLatLongIndicator;
    protected static final char EOF = '\u0000';
    private int d;
    private int m;
    private double s;
    private Integer sign = null;

    public DMSNumberFormat(boolean requireLatLongIndicator) {
        this.source = null;
        this.position = 0;
        this.maxposition = 0;
        this.requireLatLongIndicator = requireLatLongIndicator;
    }

    public DMSNumberFormat(String source, boolean requireLatLongIndicator) {
        this.source = source;
        this.position = 0;
        this.maxposition = 0;
        this.requireLatLongIndicator = requireLatLongIndicator;
    }

    public boolean isEOF() {
        return this.position >= this.source.length();
    }

    protected void skipblanks() {
        if (this.isEOF()) {
            return;
        }
        char ch = this.getch();
        while (ch != '\u0000' && Character.isWhitespace(ch)) {
            ch = this.getch();
        }
        this.ungetch();
    }

    protected char getch() {
        if (this.position >= this.source.length()) {
            return '\u0000';
        }
        ++this.column;
        char ch = this.source.charAt(this.position++);
        if (this.position > this.maxposition) {
            this.maxposition = this.position;
        }
        return ch;
    }

    protected void ungetch() {
        --this.position;
        if (this.position < 0) {
            this.position = 0;
        }
        --this.column;
        if (this.column < 0) {
            this.column = 0;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public double parse() {
        double s_d;
        StringBuilder buffer = new StringBuilder();
        this.skipblanks();
        char ch = this.getch();
        if (ch == '+') {
            this.sign = 1;
            ch = this.getch();
        } else if (ch == '-') {
            this.sign = -1;
            ch = this.getch();
        }
        buffer.setLength(0);
        if (!Character.isDigit(ch)) {
            throw new DMSNumberParseException(String.format("Expected a number at position %d.", this.getPosition()));
        }
        while (true) {
            if (ch == '\u0000') {
                throw new DMSNumberParseException("End of string was expected and end of source was found.");
            }
            if (!Character.isDigit(ch)) break;
            buffer.append(ch);
            ch = this.getch();
        }
        if (!StringUtils.contains((CharSequence)" \u00ba:", (int)ch)) {
            throw new DMSNumberParseException(String.format("Expected '%s' and found '%s'.", " ", String.valueOf(ch)));
        }
        this.d = Integer.parseInt(buffer.toString());
        this.skipblanks();
        ch = this.getch();
        buffer.setLength(0);
        if (!Character.isDigit(ch)) {
            throw new DMSNumberParseException(String.format("Expected a number at position %d.", this.getPosition()));
        }
        while (true) {
            if (ch == '\u0000') {
                throw new DMSNumberParseException("End of string was expected and end of source was found.");
            }
            if (!Character.isDigit(ch)) break;
            buffer.append(ch);
            ch = this.getch();
        }
        if (!StringUtils.contains((CharSequence)" ':", (int)ch)) {
            throw new DMSNumberParseException(String.format("Expected '%s' and found '%s'.", " ", String.valueOf(ch)));
        }
        this.m = Integer.parseInt(buffer.toString());
        this.skipblanks();
        ch = this.getch();
        buffer.setLength(0);
        if (!Character.isDigit(ch)) {
            throw new DMSNumberParseException(String.format("Expected a number at position %d.", this.getPosition()));
        }
        while (true) {
            if (ch == '\u0000') {
                throw new DMSNumberParseException("End of string was expected and end of source was found.");
            }
            if (!Character.isDigit(ch)) break;
            buffer.append(ch);
            ch = this.getch();
        }
        int s_i = Integer.parseInt(buffer.toString());
        if (ch == '.') {
            this.skipblanks();
            ch = this.getch();
            buffer.setLength(0);
            if (!Character.isDigit(ch)) {
                throw new DMSNumberParseException(String.format("Expected a number at position %d.", this.getPosition()));
            }
            while (ch != '\u0000' && Character.isDigit(ch)) {
                buffer.append(ch);
                ch = this.getch();
            }
            String ss = buffer.toString();
            s_d = (double)Integer.parseInt(ss) / Math.pow(10.0, ss.length());
        } else {
            s_d = 0.0;
        }
        if (ch != '\u0000' && !StringUtils.contains((CharSequence)" \"", (int)ch)) {
            throw new DMSNumberParseException(String.format("Expected '%s' and found '%s'.", " ", String.valueOf(ch)));
        }
        this.s = (double)s_i + s_d;
        double dd = (double)this.d + (double)this.m / 60.0 + this.s / 3600.0;
        if (this.sign == null) {
            this.skipblanks();
            ch = this.getch();
            switch (ch) {
                case 'N': 
                case 'n': {
                    if (dd > 90.0) {
                        throw new DMSNumberParseException(String.format("Incorrect value for latitude (%f)", dd));
                    }
                    this.sign = 1;
                    break;
                }
                case 'S': 
                case 's': {
                    if (dd > 90.0) {
                        throw new DMSNumberParseException(String.format("Incorrect value for latitude (%f)", dd));
                    }
                    this.sign = -1;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (dd > 180.0) {
                        throw new DMSNumberParseException(String.format("Incorrect value for longitude (%f)", dd));
                    }
                    this.sign = 1;
                    break;
                }
                case 'O': 
                case 'W': 
                case 'o': 
                case 'w': {
                    if (dd > 180.0) {
                        throw new DMSNumberParseException(String.format("Incorrect value for longitude (%f)", dd));
                    }
                    this.sign = -1;
                    break;
                }
                default: {
                    if (this.requireLatLongIndicator) {
                        throw new DMSNumberParseException(String.format("Expected '%s' and found '%s'.", "N/S/E/W", String.valueOf(ch)));
                    }
                    this.sign = 1;
                }
            }
        }
        return dd *= (double)this.sign.intValue();
    }

    public int getDegrees() {
        return this.d;
    }

    public int getMinutes() {
        return this.m;
    }

    public double getSeconds() {
        return this.s;
    }

    public int getSign() {
        return this.sign;
    }

    public static class DMSNumberParseException
    extends IllegalArgumentException {
        public DMSNumberParseException() {
        }

        private DMSNumberParseException(String msg) {
            super(msg);
        }
    }
}

