/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineReplacedBox;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class BlockReplacedBox
extends BlockBox
implements ReplacedBox {
    protected int boxw;
    protected int boxh;
    protected ReplacedContent obj;

    public BlockReplacedBox(Element el, Graphics2D g, VisualContext ctx) {
        super(el, g, ctx);
    }

    public BlockReplacedBox(InlineReplacedBox src) {
        super(src);
        this.boxw = src.boxw;
        this.boxh = src.boxh;
        this.setContentObj(src.obj);
    }

    @Override
    public ReplacedContent getContentObj() {
        return this.obj;
    }

    @Override
    public void setContentObj(ReplacedContent obj) {
        this.obj = obj;
        boolean bl = this.isempty = obj == null;
        if (!this.isempty) {
            obj.setOwner(this);
        }
    }

    @Override
    public int getMaximalWidth() {
        return this.boxw + this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
    }

    @Override
    public int getMinimalWidth() {
        return this.boxw + this.declMargin.left + this.padding.left + this.border.left + this.declMargin.right + this.padding.right + this.border.right;
    }

    @Override
    public Rectangle getMinimalAbsoluteBounds() {
        return new Rectangle(this.getAbsoluteContentX(), this.getAbsoluteContentY(), this.boxw, this.boxh);
    }

    @Override
    public boolean isWhitespace() {
        return false;
    }

    @Override
    public boolean isReplaced() {
        return true;
    }

    @Override
    public boolean doLayout(int availw, boolean force, boolean linestart) {
        if (!this.displayed) {
            this.content.setSize(0, 0);
            this.bounds.setSize(0, 0);
            return true;
        }
        this.setAvailableWidth(availw);
        int wlimit = this.getAvailableContentWidth();
        if (this.getWidth() <= wlimit) {
            return true;
        }
        return force;
    }

    @Override
    protected void loadSizes(boolean update) {
        super.loadSizes(update);
        Rectangle objsize = CSSDecoder.computeReplacedObjectSize(this.obj, this);
        this.content.width = this.boxw = objsize.width;
        this.content.height = this.boxh = objsize.height;
        this.bounds.setSize(this.totalWidth(), this.totalHeight());
        this.preferredWidth = this.getWidth();
        this.wset = true;
        this.hset = true;
    }

    @Override
    public boolean hasFixedHeight() {
        return true;
    }

    @Override
    public boolean hasFixedWidth() {
        return true;
    }

    @Override
    protected boolean separatedFromTop(ElementBox box) {
        return true;
    }

    @Override
    protected boolean separatedFromBottom(ElementBox box) {
        return true;
    }

    @Override
    public void drawContent(Graphics2D g) {
        if (this.obj != null) {
            Shape oldclip = g.getClip();
            g.setClip(this.applyClip(oldclip, this.getClippedContentBounds()));
            this.obj.draw(g, this.boxw, this.boxh);
            g.setClip(oldclip);
        }
    }

    @Override
    public void draw(Box.DrawStage turn) {
        if (this.isDisplayed() && this.isVisible() && !this.formsStackingContext()) {
            switch (turn) {
                case DRAW_NONINLINE: {
                    if (this.floating != FLOAT_NONE) break;
                    this.getViewport().getRenderer().renderElementBackground(this);
                    break;
                }
                case DRAW_FLOAT: {
                    if (this.floating == FLOAT_NONE) break;
                    this.getViewport().getRenderer().renderElementBackground(this);
                    this.getViewport().getRenderer().startElementContents(this);
                    this.getViewport().getRenderer().renderReplacedContent(this);
                    this.getViewport().getRenderer().finishElementContents(this);
                    break;
                }
                case DRAW_INLINE: {
                    if (this.floating != FLOAT_NONE) break;
                    this.getViewport().getRenderer().startElementContents(this);
                    this.getViewport().getRenderer().renderReplacedContent(this);
                    this.getViewport().getRenderer().finishElementContents(this);
                }
            }
        }
    }

    @Override
    public void drawStackingContext(boolean include) {
        if (this.isDisplayed() && this.isDeclaredVisible()) {
            if (this.isBlock()) {
                this.getViewport().getRenderer().renderElementBackground(this);
            }
            this.getViewport().getRenderer().startElementContents(this);
            this.getViewport().getRenderer().renderReplacedContent(this);
            this.getViewport().getRenderer().finishElementContents(this);
        }
    }
}

