/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.NodeData;
import java.awt.Graphics2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BlockReplacedBox;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBlockReplacedBox;
import org.fit.cssbox.layout.InlineReplacedBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.ReplacedImage;
import org.fit.cssbox.layout.ReplacedText;
import org.fit.cssbox.layout.Viewport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class HTMLBoxFactory {
    private static Logger log = LoggerFactory.getLogger(HTMLBoxFactory.class);
    private BoxFactory factory;
    private Set<String> supported;

    public HTMLBoxFactory(BoxFactory parent) {
        this.factory = parent;
        this.supported = new HashSet<String>(2);
        this.supported.add("object");
        this.supported.add("img");
    }

    public boolean isTagSupported(Element e) {
        if (e.getNodeName() != null && this.supported.contains(e.getNodeName().toLowerCase())) {
            return true;
        }
        return e.getNodeName().toLowerCase().equals("a") && e.hasAttribute("name") && (e.getTextContent() == null || e.getTextContent().trim().length() == 0);
    }

    public ElementBox createBox(ElementBox parent, Element e, Viewport viewport, NodeData style) {
        String name = e.getNodeName().toLowerCase();
        if (name.equals("object")) {
            return this.createSubtreeObject(parent, e, viewport, style);
        }
        if (name.equals("img")) {
            return this.createSubtreeImg(parent, e, viewport, style);
        }
        if (name.equals("a") && e.hasAttribute("name") && (e.getTextContent() == null || e.getTextContent().trim().length() == 0)) {
            ElementBox eb = this.factory.createElementInstance(parent, e, style);
            eb.setSticky(true);
            return eb;
        }
        return null;
    }

    protected ElementBox createSubtreeImg(ElementBox parent, Element e, Viewport viewport, NodeData style) {
        InlineReplacedBox rbox = new InlineReplacedBox(e, (Graphics2D)parent.getGraphics().create(), parent.getVisualContext().create());
        rbox.setViewport(viewport);
        rbox.setStyle(style);
        String src = e.getAttribute("src");
        rbox.setContentObj(new ReplacedImage(rbox, rbox.getVisualContext(), this.factory.getBaseURL(), src));
        if (rbox.isBlock()) {
            return new BlockReplacedBox(rbox);
        }
        return rbox;
    }

    protected ElementBox createSubtreeObject(ElementBox parent, Element e, Viewport viewport, NodeData style) {
        InlineReplacedBox rbox = new InlineReplacedBox(e, (Graphics2D)parent.getGraphics().create(), parent.getVisualContext().create());
        rbox.setViewport(viewport);
        rbox.setStyle(style);
        try {
            String mime = e.getAttribute("type").toLowerCase();
            String cb = e.getAttribute("codebase");
            String dataurl = e.getAttribute("data");
            URL base = new URL(this.factory.getBaseURL(), cb);
            if (!dataurl.trim().isEmpty()) {
                DocumentSource src = this.factory.createDocumentSource(base, dataurl);
                if (mime.isEmpty() && ((mime = src.getContentType()) == null || mime.isEmpty())) {
                    mime = "text/html";
                }
                log.debug("ctype=" + mime);
                ReplacedContent content = null;
                if (mime.startsWith("image/")) {
                    content = new ReplacedImage(rbox, rbox.getVisualContext(), base, dataurl);
                } else if (mime.equals("text/html")) {
                    log.info("Parsing: " + src.getURL());
                    DefaultDOMSource parser = new DefaultDOMSource(src);
                    Document doc = ((DOMSource)parser).parse();
                    String encoding = parser.getCharset();
                    content = new ReplacedText(rbox, doc, src.getURL(), encoding);
                }
                rbox.setContentObj(content);
            }
        }
        catch (MalformedURLException e1) {
        }
        catch (SAXException e1) {
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (rbox.getContentObj() != null) {
            if (rbox.getDisplay() == ElementBox.DISPLAY_BLOCK) {
                return new BlockReplacedBox(rbox);
            }
            return new InlineBlockReplacedBox(rbox);
        }
        return null;
    }
}

