/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.preferences.general;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.coreplugin.preferences.general.GeneralPage;
import org.gvsig.utils.BrowserControl;
import org.gvsig.utils.XMLEntity;
import org.gvsig.utils.swing.JComboBox;

public class BrowserControlPage
extends AbstractPreferencePage
implements ActionListener {
    private static final String DEFAULT_BROWSER_KEY_NAME = "DefaultBrowser";
    private String id;
    private ImageIcon icon;
    private JRadioButton rdBtnSelectBrowser;
    private JRadioButton rdBtnSpecifyCommand;
    private JComboBox cmbBrowsers;
    private JTextField txtCustomCommand;
    private ArrayList supportedBrowsers = BrowserControl.getSupportedBrowsers();

    public BrowserControlPage() {
        this.id = this.getClass().getName();
        this.icon = PluginServices.getIconTheme().get("edit-setup-browsercontrol");
        this.setParentID(GeneralPage.id);
        ButtonGroup group = new ButtonGroup();
        this.rdBtnSelectBrowser = new JRadioButton(PluginServices.getText((Object)this, (String)"options.general.browser.select_a_known_browser"));
        this.rdBtnSelectBrowser.addActionListener(this);
        JPanel aux = new JPanel(new FlowLayout(3));
        this.cmbBrowsers = new JComboBox((Object[])this.supportedBrowsers.toArray(new String[0]));
        aux.add((Component)this.cmbBrowsers);
        this.addComponent(this.rdBtnSelectBrowser, aux);
        this.rdBtnSpecifyCommand = new JRadioButton(PluginServices.getText((Object)this, (String)"options.general.browser.specify_a_command"));
        this.rdBtnSpecifyCommand.setVerticalAlignment(3);
        this.rdBtnSpecifyCommand.addActionListener(this);
        aux = new JPanel(new FlowLayout(3));
        this.txtCustomCommand = new JTextField(25);
        aux.add(this.txtCustomCommand);
        this.addComponent(this.rdBtnSpecifyCommand, aux);
        group.add(this.rdBtnSelectBrowser);
        group.add(this.rdBtnSpecifyCommand);
        this.actionPerformed(null);
    }

    public void storeValues() throws StoreException {
        String cmd = this.rdBtnSelectBrowser.isSelected() ? (String)this.cmbBrowsers.getSelectedItem() : this.txtCustomCommand.getText();
        BrowserControl.setBrowserCommand((String)cmd);
        PluginServices ps = PluginServices.getPluginServices((Object)this);
        XMLEntity xml = ps.getPersistentXML();
        xml.putProperty(DEFAULT_BROWSER_KEY_NAME, cmd);
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }

    public String getID() {
        return this.id;
    }

    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"browser");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        PluginServices ps = PluginServices.getPluginServices((Object)this);
        XMLEntity xml = ps.getPersistentXML();
        if (xml.contains(DEFAULT_BROWSER_KEY_NAME)) {
            String cmd = xml.getStringProperty(DEFAULT_BROWSER_KEY_NAME);
            boolean b = this.supportedBrowsers.contains(cmd);
            if (b) {
                this.cmbBrowsers.setSelectedItem((Object)cmd);
                this.cmbBrowsers.setEnabled(true);
                this.txtCustomCommand.setEnabled(false);
            } else {
                this.txtCustomCommand.setText(cmd);
                this.txtCustomCommand.setEnabled(true);
                this.cmbBrowsers.setEnabled(false);
            }
            this.rdBtnSelectBrowser.setSelected(b);
            this.rdBtnSpecifyCommand.setSelected(!b);
        } else {
            this.initializeDefaults();
        }
    }

    public void initializeDefaults() {
        this.rdBtnSelectBrowser.setSelected(true);
        this.actionPerformed(null);
        this.cmbBrowsers.setSelectedItem((Object)"Firefox");
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return super.hasChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.rdBtnSelectBrowser.isSelected()) {
            this.cmbBrowsers.setEnabled(true);
            this.txtCustomCommand.setEnabled(false);
        } else if (this.rdBtnSpecifyCommand.isSelected()) {
            this.txtCustomCommand.setEnabled(true);
            this.cmbBrowsers.setEnabled(false);
        }
    }
}

