/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.preferences.general;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.config.generate.PluginConfig;
import org.gvsig.andami.plugins.config.generate.SkinExtension;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.coreplugin.preferences.general.GeneralPage;
import org.gvsig.utils.XMLEntity;
import org.gvsig.utils.swing.JComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinPreferences
extends AbstractPreferencePage {
    private static final Logger logger = LoggerFactory.getLogger(SkinPreferences.class);
    private String id = ((Object)((Object)this)).getClass().getName();
    private ImageIcon icon;
    private Vector listSkinsPlugins;
    private JComboBox comboBox;
    private String skinName = "org.gvsig.coreplugin.mdiManager.NewSkin";

    public SkinPreferences() {
        this.setParentID(GeneralPage.id);
        this.icon = PluginServices.getIconTheme().get("edit-setup-skin");
    }

    public void setChangesApplied() {
    }

    public void storeValues() throws StoreException {
        PluginServices ps = PluginServices.getPluginServices((String)"org.gvsig.coreplugin");
        XMLEntity xml = ps.getPersistentXML();
        xml.putProperty("Skin-Selected", this.skinName);
    }

    public String getID() {
        return this.id;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public JPanel getPanel() {
        if (this.comboBox == null) {
            this.comboBox = this.getComboBox();
            this.addComponent(new JLabel(PluginServices.getText((Object)((Object)this), (String)"skin_label")));
            this.addComponent((Component)this.comboBox);
        }
        return this;
    }

    private JComboBox getComboBox() {
        this.comboBox = new JComboBox(this.listSkinsPlugins);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String newSkinName = (String)cb.getSelectedItem();
                if (newSkinName != null && !newSkinName.equals(SkinPreferences.this.skinName)) {
                    SkinPreferences.this.skinName = newSkinName;
                    JOptionPane.showMessageDialog(null, PluginServices.getText((Object)this, (String)"skin_message"));
                }
            }
        });
        this.comboBox.setSelectedItem((Object)this.skinName);
        return this.comboBox;
    }

    public String getTitle() {
        return PluginServices.getText((Object)((Object)this), (String)"skin");
    }

    public void initializeDefaults() {
    }

    public void initializeValues() {
        this.listSkinsPlugins = new Vector();
        HashMap pluginsConfig = Launcher.getPluginConfig();
        for (String name : pluginsConfig.keySet()) {
            PluginConfig pc = (PluginConfig)pluginsConfig.get(name);
            if (pc.getExtensions().getSkinExtension() == null) continue;
            SkinExtension[] se = pc.getExtensions().getSkinExtension();
            for (int j = 0; j < se.length; ++j) {
                String extensionName = se[j].getClassName();
                this.listSkinsPlugins.add(extensionName);
                logger.info("Skin plugin '" + name + "', extension '" + extensionName + ".");
            }
        }
        PluginServices ps = PluginServices.getPluginServices((String)"org.gvsig.coreplugin");
        XMLEntity xml = ps.getPersistentXML();
        if (xml.contains("Skin-Selected")) {
            this.skinName = xml.getStringProperty("Skin-Selected");
        }
    }

    public boolean isValueChanged() {
        return true;
    }
}

