/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxVmlCanvas
extends mxBasicCanvas {
    protected Document document;

    public mxVmlCanvas() {
        this(null);
    }

    public mxVmlCanvas(Document document) {
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void appendVmlElement(Element node) {
        Node body;
        if (this.document != null && (body = this.document.getDocumentElement().getFirstChild().getNextSibling()) != null) {
            body.appendChild(node);
        }
    }

    @Override
    public Object drawCell(mxCellState state) {
        Map<String, Object> style = state.getStyle();
        Element elem = null;
        if (state.getAbsolutePointCount() > 1) {
            List<mxPoint> pts = state.getAbsolutePoints();
            pts = mxUtils.translatePoints(pts, this.translate.getX(), this.translate.getY());
            elem = this.drawLine(pts, style);
            Element strokeNode = this.document.createElement("v:stroke");
            String start = mxUtils.getString(style, mxConstants.STYLE_STARTARROW);
            String end = mxUtils.getString(style, mxConstants.STYLE_ENDARROW);
            if (start != null || end != null) {
                if (start != null) {
                    strokeNode.setAttribute("startarrow", start);
                    String startWidth = "medium";
                    String startLength = "medium";
                    double startSize = (double)mxUtils.getFloat(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_MARKERSIZE) * this.scale;
                    if (startSize < 6.0) {
                        startWidth = "narrow";
                        startLength = "short";
                    } else if (startSize > 10.0) {
                        startWidth = "wide";
                        startLength = "long";
                    }
                    strokeNode.setAttribute("startarrowwidth", startWidth);
                    strokeNode.setAttribute("startarrowlength", startLength);
                }
                if (end != null) {
                    strokeNode.setAttribute("endarrow", end);
                    String endWidth = "medium";
                    String endLength = "medium";
                    double endSize = (double)mxUtils.getFloat(style, mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE) * this.scale;
                    if (endSize < 6.0) {
                        endWidth = "narrow";
                        endLength = "short";
                    } else if (endSize > 10.0) {
                        endWidth = "wide";
                        endLength = "long";
                    }
                    strokeNode.setAttribute("endarrowwidth", endWidth);
                    strokeNode.setAttribute("endarrowlength", endLength);
                }
            }
            if (mxUtils.isTrue(style, mxConstants.STYLE_DASHED)) {
                strokeNode.setAttribute("dashstyle", "2 2");
            }
            elem.appendChild(strokeNode);
        } else {
            int x = (int)(state.getX() + this.translate.getX());
            int y = (int)(state.getY() + this.translate.getY());
            int w = (int)state.getWidth();
            int h = (int)state.getHeight();
            if (!mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                elem = this.drawShape(x, y, w, h, style);
                if (mxUtils.isTrue(style, mxConstants.STYLE_DASHED)) {
                    Element strokeNode = this.document.createElement("v:stroke");
                    strokeNode.setAttribute("dashstyle", "2 2");
                    elem.appendChild(strokeNode);
                }
            } else {
                int start = (int)Math.round((double)mxUtils.getInt(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * this.scale);
                Hashtable<String, Object> cloned = new Hashtable<String, Object>(style);
                cloned.remove(mxConstants.STYLE_FILLCOLOR);
                cloned.remove(mxConstants.STYLE_ROUNDED);
                if (mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
                    elem = this.drawShape(x, y, w, start, style);
                    this.drawShape(x, y + start, w, h - start, cloned);
                } else {
                    elem = this.drawShape(x, y, start, h, style);
                    this.drawShape(x + start, y, w - start, h, cloned);
                }
            }
        }
        return elem;
    }

    @Override
    public Object drawLabel(String label, mxCellState state, boolean html) {
        mxRectangle bounds = state.getLabelBounds();
        if (this.drawLabels && bounds != null) {
            int x = (int)(bounds.getX() + this.translate.getX());
            int y = (int)(bounds.getY() + this.translate.getY());
            int w = (int)bounds.getWidth();
            int h = (int)bounds.getHeight();
            Map<String, Object> style = state.getStyle();
            return this.drawText(label, x, y, w, h, style);
        }
        return null;
    }

    public Element drawShape(int x, int y, int w, int h, Map<String, Object> style) {
        String points;
        String fillColor = mxUtils.getString(style, mxConstants.STYLE_FILLCOLOR);
        String strokeColor = mxUtils.getString(style, mxConstants.STYLE_STROKECOLOR);
        float strokeWidth = (float)((double)mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        String shape = mxUtils.getString(style, mxConstants.STYLE_SHAPE);
        Element elem = null;
        if (shape.equals("image")) {
            String img = this.getImageForStyle(style);
            if (img != null) {
                elem = this.document.createElement("v:img");
                elem.setAttribute("src", img);
            }
        } else if (shape.equals("line")) {
            String direction = mxUtils.getString(style, mxConstants.STYLE_DIRECTION, "east");
            points = null;
            if (direction.equals("east") || direction.equals("west")) {
                int mid = Math.round(h / 2);
                points = "m 0 " + mid + " l " + w + " " + mid;
            } else {
                int mid = Math.round(w / 2);
                points = "m " + mid + " 0 L " + mid + " " + h;
            }
            elem = this.document.createElement("v:shape");
            elem.setAttribute("coordsize", w + " " + h);
            elem.setAttribute("path", points + " x e");
        } else if (shape.equals("ellipse")) {
            elem = this.document.createElement("v:oval");
        } else if (shape.equals("doubleEllipse")) {
            elem = this.document.createElement("v:shape");
            elem.setAttribute("coordsize", w + " " + h);
            int inset = (int)((double)(3.0f + strokeWidth) * this.scale);
            points = "ar 0 0 " + w + " " + h + " 0 " + h / 2 + " " + w / 2 + " " + h / 2 + " e ar " + inset + " " + inset + " " + (w - inset) + " " + (h - inset) + " 0 " + h / 2 + " " + w / 2 + " " + h / 2;
            elem.setAttribute("path", points + " x e");
        } else if (shape.equals("rhombus")) {
            elem = this.document.createElement("v:shape");
            elem.setAttribute("coordsize", w + " " + h);
            String points2 = "m " + w / 2 + " 0 l " + w + " " + h / 2 + " l " + w / 2 + " " + h + " l 0 " + h / 2;
            elem.setAttribute("path", points2 + " x e");
        } else if (shape.equals("triangle")) {
            elem = this.document.createElement("v:shape");
            elem.setAttribute("coordsize", w + " " + h);
            String direction = mxUtils.getString(style, mxConstants.STYLE_DIRECTION, "");
            points = null;
            points = direction.equals("north") ? "m 0 " + h + " l " + w / 2 + " 0  l " + w + " " + h : (direction.equals("south") ? "m 0 0 l " + w / 2 + " " + h + " l " + w + " 0" : (direction.equals("west") ? "m " + w + " 0 l " + w + " " + h / 2 + " l " + w + " " + h : "m 0 0 l " + w + " " + h / 2 + " l 0 " + h));
            elem.setAttribute("path", points + " x e");
        } else if (shape.equals("hexagon")) {
            elem = this.document.createElement("v:shape");
            elem.setAttribute("coordsize", w + " " + h);
            String direction = mxUtils.getString(style, mxConstants.STYLE_DIRECTION, "");
            points = null;
            points = direction.equals("north") || direction.equals("south") ? "m " + (int)(0.5 * (double)w) + " 0 l " + w + " " + (int)(0.25 * (double)h) + " l " + w + " " + (int)(0.75 * (double)h) + " l " + (int)(0.5 * (double)w) + " " + h + " l 0 " + (int)(0.75 * (double)h) + " l 0 " + (int)(0.25 * (double)h) : "m " + (int)(0.25 * (double)w) + " 0 l " + (int)(0.75 * (double)w) + " 0 l " + w + " " + (int)(0.5 * (double)h) + " l " + (int)(0.75 * (double)w) + " " + h + " l " + (int)(0.25 * (double)w) + " " + h + " l 0 " + (int)(0.5 * (double)h);
            elem.setAttribute("path", points + " x e");
        } else if (shape.equals("cloud")) {
            elem = this.document.createElement("v:shape");
            elem.setAttribute("coordsize", w + " " + h);
            String points3 = "m " + (int)(0.25 * (double)w) + " " + (int)(0.25 * (double)h) + " c " + (int)(0.05 * (double)w) + " " + (int)(0.25 * (double)h) + " 0 " + (int)(0.5 * (double)h) + " " + (int)(0.16 * (double)w) + " " + (int)(0.55 * (double)h) + " c 0 " + (int)(0.66 * (double)h) + " " + (int)(0.18 * (double)w) + " " + (int)(0.9 * (double)h) + " " + (int)(0.31 * (double)w) + " " + (int)(0.8 * (double)h) + " c " + (int)(0.4 * (double)w) + " " + h + " " + (int)(0.7 * (double)w) + " " + h + " " + (int)(0.8 * (double)w) + " " + (int)(0.8 * (double)h) + " c " + w + " " + (int)(0.8 * (double)h) + " " + w + " " + (int)(0.6 * (double)h) + " " + (int)(0.875 * (double)w) + " " + (int)(0.5 * (double)h) + " c " + w + " " + (int)(0.3 * (double)h) + " " + (int)(0.8 * (double)w) + " " + (int)(0.1 * (double)h) + " " + (int)(0.625 * (double)w) + " " + (int)(0.2 * (double)h) + " c " + (int)(0.5 * (double)w) + " " + (int)(0.05 * (double)h) + " " + (int)(0.3 * (double)w) + " " + (int)(0.05 * (double)h) + " " + (int)(0.25 * (double)w) + " " + (int)(0.25 * (double)h);
            elem.setAttribute("path", points3 + " x e");
        } else if (shape.equals("actor")) {
            elem = this.document.createElement("v:shape");
            elem.setAttribute("coordsize", w + " " + h);
            double width3 = w / 3;
            String points4 = "m 0 " + h + " C 0 " + 3 * h / 5 + " 0 " + 2 * h / 5 + " " + w / 2 + " " + 2 * h / 5 + " c " + (int)((double)(w / 2) - width3) + " " + 2 * h / 5 + " " + (int)((double)(w / 2) - width3) + " 0 " + w / 2 + " 0 c " + (int)((double)(w / 2) + width3) + " 0 " + (int)((double)(w / 2) + width3) + " " + 2 * h / 5 + " " + w / 2 + " " + 2 * h / 5 + " c " + w + " " + 2 * h / 5 + " " + w + " " + 3 * h / 5 + " " + w + " " + h;
            elem.setAttribute("path", points4 + " x e");
        } else if (shape.equals("cylinder")) {
            elem = this.document.createElement("v:shape");
            elem.setAttribute("coordsize", w + " " + h);
            double dy = Math.min(40.0, Math.floor(h / 5));
            String points5 = "m 0 " + (int)dy + " C 0 " + (int)(dy / 3.0) + " " + w + " " + (int)(dy / 3.0) + " " + w + " " + (int)dy + " L " + w + " " + (int)((double)h - dy) + " C " + w + " " + (int)((double)h + dy / 3.0) + " 0 " + (int)((double)h + dy / 3.0) + " 0 " + (int)((double)h - dy) + " x e m 0 " + (int)dy + " C 0 " + (int)(2.0 * dy) + " " + w + " " + (int)(2.0 * dy) + " " + w + " " + (int)dy;
            elem.setAttribute("path", points5 + " e");
        } else if (mxUtils.isTrue(style, mxConstants.STYLE_ROUNDED, false)) {
            elem = this.document.createElement("v:roundrect");
            elem.setAttribute("arcsize", mxConstants.RECTANGLE_ROUNDING_FACTOR * 100.0 + "%");
        } else {
            elem = this.document.createElement("v:rect");
        }
        String s = "position:absolute;left:" + String.valueOf(x) + "px;top:" + String.valueOf(y) + "px;width:" + String.valueOf(w) + "px;height:" + String.valueOf(h) + "px;";
        double rotation = mxUtils.getDouble(style, mxConstants.STYLE_ROTATION);
        if (rotation != 0.0) {
            s = s + "rotation:" + rotation + ";";
        }
        elem.setAttribute("style", s);
        if (mxUtils.isTrue(style, mxConstants.STYLE_SHADOW, false) && fillColor != null) {
            Element shadow = this.document.createElement("v:shadow");
            shadow.setAttribute("on", "true");
            shadow.setAttribute("color", mxConstants.W3C_SHADOWCOLOR);
            elem.appendChild(shadow);
        }
        float opacity = mxUtils.getFloat(style, mxConstants.STYLE_OPACITY, 100.0f);
        float fillOpacity = mxUtils.getFloat(style, mxConstants.STYLE_FILL_OPACITY, 100.0f);
        float strokeOpacity = mxUtils.getFloat(style, mxConstants.STYLE_STROKE_OPACITY, 100.0f);
        if (fillColor != null) {
            Element fill = this.document.createElement("v:fill");
            fill.setAttribute("color", fillColor);
            if (opacity != 100.0f || fillOpacity != 100.0f) {
                fill.setAttribute("opacity", String.valueOf(opacity * fillOpacity / 10000.0f));
            }
            elem.appendChild(fill);
        } else {
            elem.setAttribute("filled", "false");
        }
        if (strokeColor != null) {
            elem.setAttribute("strokecolor", strokeColor);
            Element stroke = this.document.createElement("v:stroke");
            if (opacity != 100.0f || strokeOpacity != 100.0f) {
                stroke.setAttribute("opacity", String.valueOf(opacity * strokeOpacity / 10000.0f));
            }
            elem.appendChild(stroke);
        } else {
            elem.setAttribute("stroked", "false");
        }
        elem.setAttribute("strokeweight", String.valueOf(strokeWidth) + "px");
        this.appendVmlElement(elem);
        return elem;
    }

    public Element drawLine(List<mxPoint> pts, Map<String, Object> style) {
        String strokeColor = mxUtils.getString(style, mxConstants.STYLE_STROKECOLOR);
        float strokeWidth = (float)((double)mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        Element elem = this.document.createElement("v:shape");
        if (strokeColor != null && strokeWidth > 0.0f) {
            mxPoint pt = pts.get(0);
            Rectangle r = new Rectangle(pt.getPoint());
            StringBuilder buf = new StringBuilder("m " + Math.round(pt.getX()) + " " + Math.round(pt.getY()));
            for (int i = 1; i < pts.size(); ++i) {
                pt = pts.get(i);
                buf.append(" l " + Math.round(pt.getX()) + " " + Math.round(pt.getY()));
                r = r.union(new Rectangle(pt.getPoint()));
            }
            String d = buf.toString();
            elem.setAttribute("path", d);
            elem.setAttribute("filled", "false");
            elem.setAttribute("strokecolor", strokeColor);
            elem.setAttribute("strokeweight", String.valueOf(strokeWidth) + "px");
            String s = "position:absolute;left:" + String.valueOf(r.x) + "px;top:" + String.valueOf(r.y) + "px;width:" + String.valueOf(r.width) + "px;height:" + String.valueOf(r.height) + "px;";
            elem.setAttribute("style", s);
            elem.setAttribute("coordorigin", String.valueOf(r.x) + " " + String.valueOf(r.y));
            elem.setAttribute("coordsize", String.valueOf(r.width) + " " + String.valueOf(r.height));
        }
        this.appendVmlElement(elem);
        return elem;
    }

    public Element drawText(String text, int x, int y, int w, int h, Map<String, Object> style) {
        Element table = mxUtils.createTable(this.document, text, x, y, w, h, this.scale, style);
        this.appendVmlElement(table);
        return table;
    }
}

