/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.model;

import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyEdge;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyNode;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class mxGraphHierarchyModel {
    public int maxRank;
    protected Map<Object, mxGraphHierarchyNode> vertexMapper = null;
    protected Map<Object, mxGraphHierarchyEdge> edgeMapper = null;
    public Map<Integer, mxGraphHierarchyRank> ranks = null;
    public List<Object> roots;
    public Object parent = null;
    protected int dfsCount = 0;
    private final int SOURCESCANSTARTRANK = 100000000;

    public mxGraphHierarchyModel(mxHierarchicalLayout layout, Object[] vertices, List<Object> roots, Object parent) {
        mxGraph graph = layout.getGraph();
        this.roots = roots;
        this.parent = parent;
        if (vertices == null) {
            vertices = graph.getChildVertices(parent);
        }
        this.vertexMapper = new Hashtable<Object, mxGraphHierarchyNode>(vertices.length);
        this.edgeMapper = new Hashtable<Object, mxGraphHierarchyEdge>(vertices.length);
        this.maxRank = 100000000;
        mxGraphHierarchyNode[] internalVertices = new mxGraphHierarchyNode[vertices.length];
        this.createInternalCells(layout, vertices, internalVertices);
        for (int i = 0; i < vertices.length; ++i) {
            Collection<mxGraphHierarchyEdge> edges = internalVertices[i].connectsAsSource;
            for (mxGraphHierarchyEdge internalEdge : edges) {
                List<Object> realEdges = internalEdge.edges;
                Iterator iter2 = realEdges.iterator();
                if (!iter2.hasNext()) continue;
                Object realEdge = iter2.next();
                Object targetCell = graph.getView().getVisibleTerminal(realEdge, false);
                mxGraphHierarchyNode internalTargetCell = this.vertexMapper.get(targetCell);
                if (internalVertices[i] == internalTargetCell) {
                    targetCell = graph.getView().getVisibleTerminal(realEdge, true);
                    internalTargetCell = this.vertexMapper.get(targetCell);
                }
                if (internalTargetCell == null || internalVertices[i] == internalTargetCell) continue;
                internalEdge.target = internalTargetCell;
                if (internalTargetCell.connectsAsTarget.size() == 0) {
                    internalTargetCell.connectsAsTarget = new LinkedHashSet<mxGraphHierarchyEdge>(4);
                }
                internalTargetCell.connectsAsTarget.add(internalEdge);
            }
            internalVertices[i].temp[0] = 1;
        }
    }

    protected void createInternalCells(mxHierarchicalLayout layout, Object[] vertices, mxGraphHierarchyNode[] internalVertices) {
        mxGraph graph = layout.getGraph();
        for (int i = 0; i < vertices.length; ++i) {
            internalVertices[i] = new mxGraphHierarchyNode(vertices[i]);
            this.vertexMapper.put(vertices[i], internalVertices[i]);
            Object[] conns = layout.getEdges(vertices[i]);
            List<Object> outgoingCells = Arrays.asList(graph.getOpposites(conns, vertices[i]));
            internalVertices[i].connectsAsSource = new LinkedHashSet<mxGraphHierarchyEdge>(outgoingCells.size());
            for (Object cell : outgoingCells) {
                if (cell == vertices[i] || !graph.getModel().isVertex(cell) || layout.isVertexIgnored(cell)) continue;
                Object[] undirectEdges = graph.getEdgesBetween(vertices[i], cell, false);
                Object[] directedEdges = graph.getEdgesBetween(vertices[i], cell, true);
                if (undirectEdges == null || undirectEdges.length <= 0 || this.edgeMapper.get(undirectEdges[0]) != null || directedEdges.length * 2 < undirectEdges.length) continue;
                ArrayList<Object> listEdges = new ArrayList<Object>(undirectEdges.length);
                for (int j = 0; j < undirectEdges.length; ++j) {
                    listEdges.add(undirectEdges[j]);
                }
                mxGraphHierarchyEdge internalEdge = new mxGraphHierarchyEdge(listEdges);
                for (Object edge : listEdges) {
                    this.edgeMapper.put(edge, internalEdge);
                    graph.resetEdge(edge);
                    if (!layout.isDisableEdgeStyle()) continue;
                    layout.setEdgeStyleEnabled(edge, false);
                    layout.setOrthogonalEdge(edge, true);
                }
                internalEdge.source = internalVertices[i];
                internalVertices[i].connectsAsSource.add(internalEdge);
            }
            internalVertices[i].temp[0] = 0;
        }
    }

    public void initialRank() {
        Collection<mxGraphHierarchyNode> internalNodes = this.vertexMapper.values();
        LinkedList<mxGraphHierarchyNode> startNodes = new LinkedList<mxGraphHierarchyNode>();
        if (this.roots != null) {
            Iterator<Object> iter = this.roots.iterator();
            while (iter.hasNext()) {
                mxGraphHierarchyNode internalNode = this.vertexMapper.get(iter.next());
                if (internalNode == null) continue;
                startNodes.add(internalNode);
            }
        }
        for (mxGraphHierarchyNode internalNode : internalNodes) {
            internalNode.temp[0] = -1;
        }
        ArrayList startNodesCopy = new ArrayList(startNodes);
        while (!startNodes.isEmpty()) {
            mxGraphHierarchyNode internalNode = (mxGraphHierarchyNode)startNodes.getFirst();
            Collection<mxGraphHierarchyEdge> layerDeterminingEdges = internalNode.connectsAsTarget;
            Collection<mxGraphHierarchyEdge> edgesToBeMarked = internalNode.connectsAsSource;
            boolean allEdgesScanned = true;
            Iterator<mxGraphHierarchyEdge> iter2 = layerDeterminingEdges.iterator();
            int minimumLayer = 100000000;
            while (allEdgesScanned && iter2.hasNext()) {
                mxGraphHierarchyEdge internalEdge = iter2.next();
                if (internalEdge.temp[0] == 5270620) {
                    mxGraphHierarchyNode otherNode = internalEdge.source;
                    minimumLayer = Math.min(minimumLayer, otherNode.temp[0] - 1);
                    continue;
                }
                allEdgesScanned = false;
            }
            if (allEdgesScanned) {
                internalNode.temp[0] = minimumLayer;
                this.maxRank = Math.min(this.maxRank, minimumLayer);
                if (edgesToBeMarked != null) {
                    for (mxGraphHierarchyEdge internalEdge : edgesToBeMarked) {
                        internalEdge.temp[0] = 5270620;
                        mxGraphHierarchyNode otherNode = internalEdge.target;
                        if (otherNode.temp[0] != -1) continue;
                        startNodes.addLast(otherNode);
                        otherNode.temp[0] = -2;
                    }
                }
                startNodes.removeFirst();
                continue;
            }
            Object removedCell = startNodes.removeFirst();
            startNodes.addLast(internalNode);
            if (removedCell != internalNode || startNodes.size() != 1) continue;
            break;
        }
        for (mxGraphHierarchyNode internalNode : internalNodes) {
            internalNode.temp[0] = internalNode.temp[0] - this.maxRank;
        }
        for (int i = 0; i < startNodesCopy.size(); ++i) {
            mxGraphHierarchyNode internalNode = (mxGraphHierarchyNode)startNodesCopy.get(i);
            int currentMaxLayer = 0;
            for (mxGraphHierarchyEdge internalEdge : internalNode.connectsAsSource) {
                mxGraphHierarchyNode otherNode = internalEdge.target;
                internalNode.temp[0] = Math.max(currentMaxLayer, otherNode.temp[0] + 1);
                currentMaxLayer = internalNode.temp[0];
            }
        }
        this.maxRank = 100000000 - this.maxRank;
    }

    public void fixRanks() {
        final mxGraphHierarchyRank[] rankList = new mxGraphHierarchyRank[this.maxRank + 1];
        this.ranks = new LinkedHashMap<Integer, mxGraphHierarchyRank>(this.maxRank + 1);
        for (int i = 0; i < this.maxRank + 1; ++i) {
            rankList[i] = new mxGraphHierarchyRank();
            this.ranks.put(new Integer(i), rankList[i]);
        }
        mxGraphHierarchyNode[] rootsArray = null;
        if (this.roots != null) {
            Object[] oldRootsArray = this.roots.toArray();
            rootsArray = new mxGraphHierarchyNode[oldRootsArray.length];
            for (int i = 0; i < oldRootsArray.length; ++i) {
                mxGraphHierarchyNode internalNode;
                Object node = oldRootsArray[i];
                rootsArray[i] = internalNode = this.vertexMapper.get(node);
            }
        }
        this.visit(new CellVisitor(){

            @Override
            public void visit(mxGraphHierarchyNode parent, mxGraphHierarchyNode cell, mxGraphHierarchyEdge connectingEdge, int layer, int seen) {
                int parentToCellRankDifference;
                mxGraphHierarchyNode node = cell;
                if (seen == 0 && node.maxRank < 0 && node.minRank < 0) {
                    rankList[node.temp[0]].add(cell);
                    node.maxRank = node.temp[0];
                    node.minRank = node.temp[0];
                    node.temp[0] = rankList[node.maxRank].size() - 1;
                }
                if (parent != null && connectingEdge != null && (parentToCellRankDifference = parent.maxRank - node.maxRank) > 1) {
                    mxGraphHierarchyEdge edge = connectingEdge;
                    edge.maxRank = parent.maxRank;
                    edge.minRank = cell.maxRank;
                    edge.temp = new int[parentToCellRankDifference - 1];
                    edge.x = new double[parentToCellRankDifference - 1];
                    edge.y = new double[parentToCellRankDifference - 1];
                    for (int i = edge.minRank + 1; i < edge.maxRank; ++i) {
                        rankList[i].add(edge);
                        edge.setGeneralPurposeVariable(i, rankList[i].size() - 1);
                    }
                }
            }
        }, rootsArray, false, null);
    }

    public void visit(CellVisitor visitor, mxGraphHierarchyNode[] dfsRoots, boolean trackAncestors, Set<mxGraphHierarchyNode> seenNodes) {
        if (dfsRoots != null) {
            for (int i = 0; i < dfsRoots.length; ++i) {
                mxGraphHierarchyNode internalNode = dfsRoots[i];
                if (internalNode == null) continue;
                if (seenNodes == null) {
                    seenNodes = new HashSet<mxGraphHierarchyNode>();
                }
                if (trackAncestors) {
                    internalNode.hashCode = new int[2];
                    internalNode.hashCode[0] = this.dfsCount;
                    internalNode.hashCode[1] = i;
                    this.dfs(null, internalNode, null, visitor, seenNodes, internalNode.hashCode, i, 0);
                    continue;
                }
                this.dfs(null, internalNode, null, visitor, seenNodes, 0);
            }
            ++this.dfsCount;
        }
    }

    public void dfs(mxGraphHierarchyNode parent, mxGraphHierarchyNode root, mxGraphHierarchyEdge connectingEdge, CellVisitor visitor, Set<mxGraphHierarchyNode> seen, int layer) {
        if (root != null) {
            if (!seen.contains(root)) {
                visitor.visit(parent, root, connectingEdge, layer, 0);
                seen.add(root);
                Object[] outgoingEdges = root.connectsAsSource.toArray();
                for (int i = 0; i < outgoingEdges.length; ++i) {
                    mxGraphHierarchyEdge internalEdge = (mxGraphHierarchyEdge)outgoingEdges[i];
                    mxGraphHierarchyNode targetNode = internalEdge.target;
                    this.dfs(root, targetNode, internalEdge, visitor, seen, layer + 1);
                }
            } else {
                visitor.visit(parent, root, connectingEdge, layer, 1);
            }
        }
    }

    public void dfs(mxGraphHierarchyNode parent, mxGraphHierarchyNode root, mxGraphHierarchyEdge connectingEdge, CellVisitor visitor, Set<mxGraphHierarchyNode> seen, int[] ancestors, int childHash, int layer) {
        if (root != null) {
            if (parent != null && (root.hashCode == null || root.hashCode[0] != parent.hashCode[0])) {
                int hashCodeLength = parent.hashCode.length + 1;
                root.hashCode = new int[hashCodeLength];
                System.arraycopy(parent.hashCode, 0, root.hashCode, 0, parent.hashCode.length);
                root.hashCode[hashCodeLength - 1] = childHash;
            }
            if (!seen.contains(root)) {
                visitor.visit(parent, root, connectingEdge, layer, 0);
                seen.add(root);
                Object[] outgoingEdges = root.connectsAsSource.toArray();
                for (int i = 0; i < outgoingEdges.length; ++i) {
                    mxGraphHierarchyEdge internalEdge = (mxGraphHierarchyEdge)outgoingEdges[i];
                    mxGraphHierarchyNode targetNode = internalEdge.target;
                    this.dfs(root, targetNode, internalEdge, visitor, seen, root.hashCode, i, layer + 1);
                }
            } else {
                visitor.visit(parent, root, connectingEdge, layer, 1);
            }
        }
    }

    public Map<Object, mxGraphHierarchyNode> getVertexMapper() {
        if (this.vertexMapper == null) {
            this.vertexMapper = new Hashtable<Object, mxGraphHierarchyNode>();
        }
        return this.vertexMapper;
    }

    public void setVertexMapper(Map<Object, mxGraphHierarchyNode> vertexMapping) {
        this.vertexMapper = vertexMapping;
    }

    public Map<Object, mxGraphHierarchyEdge> getEdgeMapper() {
        return this.edgeMapper;
    }

    public void setEdgeMapper(Map<Object, mxGraphHierarchyEdge> edgeMapper) {
        this.edgeMapper = edgeMapper;
    }

    public int getDfsCount() {
        return this.dfsCount;
    }

    public void setDfsCount(int dfsCount) {
        this.dfsCount = dfsCount;
    }

    public static interface CellVisitor {
        public void visit(mxGraphHierarchyNode var1, mxGraphHierarchyNode var2, mxGraphHierarchyEdge var3, int var4, int var5);
    }
}

