/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.cache.AbstractBaseCache;
import org.exolab.castor.persist.cache.Cache;

public class TimeLimited
extends AbstractBaseCache
implements Cache {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$persist$cache$TimeLimited == null ? (class$org$exolab$castor$persist$cache$TimeLimited = TimeLimited.class$("org.exolab.castor.persist.cache.TimeLimited")) : class$org$exolab$castor$persist$cache$TimeLimited);
    public static final int DEFAULT_PRECISION = 1000;
    private static TimeThread ticker = new TimeThread(1000);
    private int interval;
    private int tailtime;
    private QueueItem head;
    private QueueItem tail;
    private Hashtable map = new Hashtable();
    static /* synthetic */ Class class$org$exolab$castor$persist$cache$TimeLimited;

    public TimeLimited(int interval) {
        this.interval = interval + 1;
        ticker.addListener(this);
    }

    public synchronized Object put(Object key, Object value) {
        QueueItem oldItem = (QueueItem)this.map.get(key);
        if (oldItem != null) {
            Object oldObject = oldItem.item;
            oldItem.item = value;
            this.remove(oldItem);
            this.add(oldItem);
            return oldObject;
        }
        QueueItem newitem = new QueueItem(key, value);
        this.map.put(key, newitem);
        this.add(newitem);
        return null;
    }

    public synchronized Object get(Object key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        return ((QueueItem)o).item;
    }

    public synchronized Object remove(Object key) {
        QueueItem queueItem = (QueueItem)this.map.remove(key);
        if (queueItem == null) {
            if (_log.isDebugEnabled()) {
                _log.trace((Object)("TimeLimiteLRU: not in cache ... remove(" + key + ")"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("TimeLimiteLRU: remove(" + key + ") = " + queueItem.item));
        }
        this.remove(queueItem);
        return queueItem.item;
    }

    public synchronized Enumeration elements() {
        return new ValuesEnumeration(this.map.elements());
    }

    public void expire(Object key) {
        this.remove(key);
        this.dispose(key);
    }

    public boolean contains(Object key) {
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Testing for entry for key " + key));
        }
        return this.get(key) != null;
    }

    protected void dispose(Object o) {
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Disposing " + o));
        }
    }

    private void remove(QueueItem item) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (item == this.head) {
            QueueItem temp = item;
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            } else {
                this.head.prev = null;
                this.head.time += temp.time;
            }
            temp.prev = null;
            temp.next = null;
            temp.time = 0;
        } else if (item == this.tail) {
            this.tail = this.tail.prev;
            this.tailtime = 0;
        } else {
            QueueItem temp = item;
            temp.prev.next = temp.next;
            temp.next.prev = temp.prev;
            temp.next.time += temp.time;
            temp.prev = null;
            temp.next = null;
            temp.time = 0;
        }
    }

    private void add(QueueItem item) {
        ticker.startTick();
        if (this.head == null) {
            this.head = this.tail = item;
            item.prev = null;
            item.next = null;
            item.time = this.interval;
            this.tailtime = this.interval;
        } else {
            this.tail.next = item;
            item.prev = this.tail;
            item.next = null;
            item.time = this.interval - this.tailtime;
            this.tailtime = this.interval;
            this.tail = item;
        }
    }

    private synchronized void tick() {
        if (this.head != null) {
            this.head.time--;
            --this.tailtime;
        }
        while (this.head != null && this.head.time <= 0) {
            QueueItem temp = this.head;
            Object o = this.head.item;
            this.remove(temp);
            this.map.remove(temp.key);
            this.dispose(o);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TimeThread
    extends Thread {
        private int[] listenerLock = new int[0];
        private LinkList listener;
        private int[] lock = new int[0];
        private int tick;
        private long lastTime;
        private boolean isStopped;
        private boolean isStarted;

        public TimeThread(int tick) {
            super("Time-limited cache daemon");
            this.tick = tick;
            this.setDaemon(true);
            this.setPriority(1);
            this.isStopped = true;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startTick() {
            if (!this.isStarted || !this.isStopped) return;
            int[] nArray = this.lock;
            synchronized (this.lock) {
                this.lastTime = System.currentTimeMillis();
                this.lock.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void stopTick() {
            this.isStopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            this.isStarted = true;
            try {
                block4: while (true) {
                    if (this.isStopped) {
                        int[] nArray = this.lock;
                        // MONITORENTER : this.lock
                        this.lock.wait();
                        // MONITOREXIT : nArray
                        this.isStopped = false;
                    } else {
                        long time = System.currentTimeMillis();
                        if (time - this.lastTime < (long)this.tick) {
                            TimeThread.sleep((long)this.tick - (time - this.lastTime));
                        }
                        this.lastTime = System.currentTimeMillis();
                    }
                    LinkList temp = this.listener;
                    while (true) {
                        if (temp == null) continue block4;
                        temp.t.tick();
                        temp = temp.next;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(TimeLimited t) {
            int[] nArray = this.listenerLock;
            synchronized (this.listenerLock) {
                this.listener = new LinkList(this.listener, t);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private class LinkList {
            private LinkList next;
            private TimeLimited t;

            LinkList(LinkList next, TimeLimited t) {
                this.next = next;
                this.t = t;
            }
        }
    }

    private class QueueItem {
        private QueueItem next;
        private QueueItem prev;
        private Object key;
        private Object item;
        private int time;

        private QueueItem(Object key, Object item) {
            this.key = key;
            this.item = item;
        }
    }

    private class ValuesEnumeration
    implements Enumeration {
        private Vector v = new Vector();
        private int cur;

        private ValuesEnumeration(Enumeration e) {
            while (e.hasMoreElements()) {
                this.v.add(e.nextElement());
            }
            this.v.trimToSize();
        }

        public boolean hasMoreElements() {
            return this.v.size() > this.cur;
        }

        public Object nextElement() throws NoSuchElementException {
            Object o;
            if (this.v.size() <= this.cur) {
                throw new NoSuchElementException();
            }
            if ((o = this.v.get(this.cur++)) != null) {
                return ((QueueItem)o).item;
            }
            return null;
        }
    }
}

