/*
 * Decompiled with CFR 0.152.
 */
package jwizardcomponent;

import javax.swing.JPanel;
import jwizardcomponent.JWizardComponents;

public abstract class JWizardPanel
extends JPanel {
    private JWizardComponents wizardComponents;
    private String panelTitle;

    public JWizardPanel(JWizardComponents jWizardComponents) {
        this(jWizardComponents, null);
    }

    public JWizardPanel(JWizardComponents jWizardComponents, String string) {
        this.wizardComponents = jWizardComponents;
        this.panelTitle = string;
    }

    public void update() {
    }

    public void next() {
        this.goNext();
    }

    public void back() {
        this.goBack();
    }

    public JWizardComponents getWizardComponents() {
        return this.wizardComponents;
    }

    public void setWizardComponents(JWizardComponents jWizardComponents) {
        this.wizardComponents = jWizardComponents;
    }

    public String getPanelTitle() {
        return this.panelTitle;
    }

    public void setPanelTitle(String string) {
        this.panelTitle = string;
    }

    protected boolean goNext() {
        if (this.wizardComponents.getWizardPanelList().size() > this.wizardComponents.getCurrentIndex() + 1) {
            this.wizardComponents.setCurrentIndex(this.wizardComponents.getCurrentIndex() + 1);
            this.wizardComponents.updateComponents();
            return true;
        }
        return false;
    }

    protected boolean goBack() {
        if (this.wizardComponents.getCurrentIndex() - 1 >= 0) {
            this.wizardComponents.setCurrentIndex(this.wizardComponents.getCurrentIndex() - 1);
            this.wizardComponents.updateComponents();
            return true;
        }
        return false;
    }

    protected void switchPanel(int n) {
        this.getWizardComponents().setCurrentIndex(n);
        this.getWizardComponents().updateComponents();
    }

    protected void setBackButtonEnabled(boolean bl) {
        this.wizardComponents.getBackButton().setEnabled(bl);
    }

    protected void setNextButtonEnabled(boolean bl) {
        this.wizardComponents.getNextButton().setEnabled(bl);
    }

    protected void setFinishButtonEnabled(boolean bl) {
        this.wizardComponents.getFinishButton().setEnabled(bl);
    }
}

