/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformset.simpletable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.services.dynformset.simpletable.SimpleTableCellEditor;
import org.gvsig.tools.dynform.services.dynformset.simpletable.SimpleTableCellRenderer;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformset.AbstractJDynFormSet;
import org.gvsig.tools.dynform.spi.dynformset.JDynFormSetFactory;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.service.ServiceException;

public class SimpleTableJDynFormSet
extends AbstractJDynFormSet {
    private JButton addButton;
    private JButton deleteButton;
    private JTable table;
    private DynObjectListTableModel tableModel;
    private int currentIndex;
    private int currentCol;

    public SimpleTableJDynFormSet(DynFormSPIManager manager, JDynFormSetFactory factory, JDynForm.DynFormContext context, DynFormDefinition definition, Tags contextTags) {
        super(manager, factory, context, definition, contextTags);
        this.formHeight = 80;
    }

    public void setValues(List values) {
        super.setValues(values);
        this.tableModel.setValues(values);
        if (values == null) {
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            this.deleteButton.setEnabled(!values.isEmpty());
        }
    }

    public JComponent asJComponent() {
        if (this.contents == null) {
            try {
                this.initComponents();
            }
            catch (ServiceException e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        this.fireFormMovedToEvent(0);
        return this.contents;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int index) {
        if (index < this.tableModel.getRowCount()) {
            this.currentIndex = index;
        }
    }

    private void initComponents() throws ServiceException {
        this.contents = this.getTablePanel();
    }

    private JPanel getTablePanel() {
        JPanel panel_chartType = new JPanel();
        GridBagLayout gbl_panel_chartType = new GridBagLayout();
        panel_chartType.setLayout(gbl_panel_chartType);
        this.createJTable();
        GridBagConstraints gbc_table = new GridBagConstraints();
        gbc_table.gridheight = 3;
        gbc_table.gridwidth = 2;
        gbc_table.insets = new Insets(0, 0, 0, 5);
        gbc_table.fill = 1;
        gbc_table.weightx = 1.0;
        gbc_table.weighty = 0.0;
        gbc_table.gridx = 0;
        gbc_table.gridy = 0;
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setPreferredSize(new Dimension(scrollPane.getWidth(), this.formHeight));
        panel_chartType.add((Component)scrollPane, gbc_table);
        GridBagConstraints gbc_addButton = new GridBagConstraints();
        gbc_addButton.anchor = 13;
        gbc_addButton.insets = new Insets(0, 0, 5, 0);
        gbc_addButton.gridx = 2;
        gbc_addButton.gridy = 0;
        panel_chartType.add((Component)this.getAddButton(), gbc_addButton);
        GridBagConstraints gbc_deleteButton = new GridBagConstraints();
        gbc_deleteButton.anchor = 12;
        gbc_deleteButton.gridx = 2;
        gbc_deleteButton.gridy = 2;
        panel_chartType.add((Component)this.getDeleteButton(), gbc_deleteButton);
        return panel_chartType;
    }

    private void createJTable() {
        this.table = new JTable();
        this.table.setBackground(Color.white);
        this.table.setSelectionMode(0);
        this.table.setColumnModel(this.getColumnModel());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                SimpleTableJDynFormSet.this.setCurrentIndex(SimpleTableJDynFormSet.this.table.getSelectedRow());
                SimpleTableJDynFormSet.this.setCurrentCol(SimpleTableJDynFormSet.this.table.getSelectedColumn());
            }
        });
        this.tableModel = new DynObjectListTableModel(this.values, this.getDefinition().getElementsType());
        this.table.setModel(this.tableModel);
    }

    public void addAction(Action action) {
        LOGGER.info("AddAction not implemented over SimpleTableJDynFormSet.");
    }

    public Action getAction(String actionId) {
        LOGGER.info("getAction not implemented over SimpleTableJDynFormSet.");
        return null;
    }

    public List<Action> getActions() {
        LOGGER.info("getActions not implemented over SimpleTableJDynFormSet.");
        return Collections.EMPTY_LIST;
    }

    public void setActionEnabled(String action, boolean enabled) {
        LOGGER.info("setActionEnabled not implemented over SimpleTableJDynFormSet.");
    }

    public void setActionVisible(String action, boolean visible) {
        LOGGER.info("setActionVisible not implemented over SimpleTableJDynFormSet.");
    }

    public boolean isActionEnabled(String action) {
        LOGGER.info("isActionEnabled not implemented over SimpleTableJDynFormSet.");
        return true;
    }

    public boolean isActionVisible(String action) {
        LOGGER.info("isActionVisible not implemented over SimpleTableJDynFormSet.");
        return true;
    }

    public JComponent getActionButton(String action) {
        return null;
    }

    private TableColumnModel getColumnModel() {
        DefaultTableColumnModel colModel = new DefaultTableColumnModel();
        ArrayList names = new ArrayList();
        for (int i = 0; i < this.getDefinition().size(); ++i) {
            TableColumn col = new TableColumn();
            DynFormFieldDefinition field = this.getDefinition().get(i);
            if (field.getTags().has("dynform.width")) {
                try {
                    int width = field.getTags().getInt("dynform.width");
                    col.setMaxWidth(width);
                }
                catch (CoercionException coercionException) {
                    // empty catch block
                }
            }
            col.setHeaderValue(field.getLabel());
            colModel.addColumn(col);
        }
        return colModel;
    }

    private SimpleTableCellEditor getDefaultTableCellEditor(DynFormFieldDefinition field) {
        return new SimpleTableCellEditor(this.getContext(), field, this.getServiceManager());
    }

    private SimpleTableCellRenderer getDefaultTableCellRenderer(DynFormFieldDefinition field) {
        return new SimpleTableCellRenderer(field);
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton("");
            this.addButton.setIcon(this.getIcon("dynform-table-add.png"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SimpleTableJDynFormSet.this.tableModel.addNew();
                    SimpleTableJDynFormSet.this.deleteButton.setEnabled(true);
                }
            });
            if (this.values == null) {
                this.addButton.setEnabled(false);
            }
        }
        return this.addButton;
    }

    private Icon getIcon(String fielName) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/gvsig/tools/dynform/services/" + fielName);
        return new ImageIcon(url);
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton("");
            this.deleteButton.setIcon(this.getIcon("dynform-table-delete.png"));
            this.deleteButton.setEnabled(false);
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int index = SimpleTableJDynFormSet.this.table.getSelectedRow();
                    if (index >= 0) {
                        SimpleTableJDynFormSet.this.tableModel.remove(index);
                        if (SimpleTableJDynFormSet.this.table.getRowCount() == 0) {
                            SimpleTableJDynFormSet.this.deleteButton.setEnabled(false);
                        }
                    }
                }
            });
        }
        return this.deleteButton;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.table.setEnabled(!readOnly);
        this.getAddButton().setEnabled(!readOnly);
        this.getDeleteButton().setEnabled(!readOnly);
    }

    void setCurrentCol(int col) {
        this.currentCol = col;
    }

    public boolean hasValidValues() {
        return true;
    }

    public boolean hasValidValues(List<String> fieldsName) {
        return true;
    }

    public List getValues() {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        return this.values;
    }

    public static class DynObjectListTableModel
    implements TableModel {
        private List<DynObject> values;
        private DynStruct definition;
        private final List<TableModelListener> listeners;
        private DynField[] fields;

        public DynObjectListTableModel(List<DynObject> objs, DynStruct struct) {
            this.values = objs;
            this.definition = struct;
            this.fields = this.definition.getDynFields();
            Arrays.sort(this.fields, new Comparator<DynField>(){

                @Override
                public int compare(DynField o1, DynField o2) {
                    return o1.getOder() - o2.getOder();
                }
            });
            this.listeners = new ArrayList<TableModelListener>();
        }

        public void setValues(List objs) {
            this.values = objs;
            this.fireTableChangeEvent(-1, -1);
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.listeners.add(arg0);
        }

        @Override
        public Class<?> getColumnClass(int arg0) {
            DynField field = this.fields[arg0];
            return field.getDataType().getDefaultClass();
        }

        @Override
        public int getColumnCount() {
            return this.fields.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.fields[index].getName();
        }

        @Override
        public int getRowCount() {
            if (this.values == null) {
                return 0;
            }
            return this.values.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.values == null) {
                return null;
            }
            DynObject value = this.values.get(row);
            String colName = this.getColumnName(col);
            return value.getDynValue(colName);
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return true;
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            this.listeners.remove(arg0);
        }

        @Override
        public void setValueAt(Object arg0, int row, int col) {
            if (this.values == null) {
                return;
            }
            DynObject value = this.values.get(row);
            String colName = this.getColumnName(col);
            value.setDynValue(colName, arg0);
            this.fireTableChangeEvent(row, 0);
        }

        public void addNew() {
            if (this.values == null) {
                return;
            }
            DynObject dynobj = ToolsLocator.getDynObjectManager().createDynObject(this.definition);
            this.values.add(dynobj);
            this.fireTableChangeEvent(this.values.size(), 1);
        }

        public void remove(int index) {
            if (this.values == null) {
                return;
            }
            this.values.remove(index);
            this.fireTableChangeEvent(index, -1);
        }

        private void fireTableChangeEvent(int row, int type) {
            for (TableModelListener listener : this.listeners) {
                TableModelEvent ev = row < 0 ? new TableModelEvent(this) : new TableModelEvent(this, row, row, -1, type);
                listener.tableChanged(ev);
            }
        }
    }
}

