/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class QuaquaBorders {
    private QuaquaBorders() {
    }

    public static class OptionDialogBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(3, 3, 3, 3);
        int titleHeight = 0;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color borderColor;
            Object obj;
            g.translate(x, y);
            int messageType = -1;
            if (c instanceof JInternalFrame && (obj = ((JInternalFrame)c).getClientProperty("JInternalFrame.messageType")) != null && obj instanceof Integer) {
                messageType = (Integer)obj;
            }
            switch (messageType) {
                case 0: {
                    borderColor = UIManager.getColor("OptionPane.errorDialog.border.background");
                    break;
                }
                case 3: {
                    borderColor = UIManager.getColor("OptionPane.questionDialog.border.background");
                    break;
                }
                case 2: {
                    borderColor = UIManager.getColor("OptionPane.warningDialog.border.background");
                    break;
                }
                default: {
                    borderColor = Color.black;
                }
            }
            g.setColor(borderColor);
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            for (int i = 1; i < 3; ++i) {
                g.drawRect(i, i, w - i * 2 - 1, h - i * 2 - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = OptionDialogBorder.insets.top;
            newInsets.left = OptionDialogBorder.insets.left;
            newInsets.bottom = OptionDialogBorder.insets.bottom;
            newInsets.right = OptionDialogBorder.insets.right;
            return newInsets;
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);
        int titleHeight = 0;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(Color.black);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, 0, w - 2, 0);
            g.drawRect(1, 1, w - 3, h - 3);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = PaletteBorder.insets.top;
            newInsets.left = PaletteBorder.insets.left;
            newInsets.bottom = PaletteBorder.insets.bottom;
            newInsets.right = PaletteBorder.insets.right;
            return newInsets;
        }
    }

    static class WarningDialogBorder
    extends DialogBorder
    implements UIResource {
        WarningDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.warningDialog.border.background");
        }
    }

    static class QuestionDialogBorder
    extends DialogBorder
    implements UIResource {
        QuestionDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.questionDialog.border.background");
        }
    }

    static class ErrorDialogBorder
    extends DialogBorder
    implements UIResource {
        ErrorDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.errorDialog.border.background");
        }
    }

    static class DialogBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int corner = 14;

        DialogBorder() {
        }

        protected Color getActiveBackground() {
            return Color.gray;
        }

        protected Color getActiveHighlight() {
            return Color.white;
        }

        protected Color getActiveShadow() {
            return Color.black;
        }

        protected Color getInactiveBackground() {
            return Color.darkGray;
        }

        protected Color getInactiveHighlight() {
            return Color.white;
        }

        protected Color getInactiveShadow() {
            return Color.black;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color shadow;
            Color highlight;
            Color background;
            Window window = SwingUtilities.getWindowAncestor(c);
            if (window != null && QuaquaUtilities.isOnActiveWindow(window)) {
                background = this.getActiveBackground();
                highlight = this.getActiveHighlight();
                shadow = this.getActiveShadow();
            } else {
                background = this.getInactiveBackground();
                highlight = this.getInactiveHighlight();
                shadow = this.getInactiveShadow();
            }
            g.setColor(background);
            g.drawLine(x + 1, y + 0, x + w - 2, y + 0);
            g.drawLine(x + 0, y + 1, x + 0, y + h - 2);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
            for (int i = 1; i < 5; ++i) {
                g.drawRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1);
            }
            if (window instanceof Dialog && ((Dialog)window).isResizable()) {
                g.setColor(highlight);
                g.drawLine(15, 3, w - 14, 3);
                g.drawLine(3, 15, 3, h - 14);
                g.drawLine(w - 2, 15, w - 2, h - 14);
                g.drawLine(15, h - 2, w - 14, h - 2);
                g.setColor(shadow);
                g.drawLine(14, 2, w - 14 - 1, 2);
                g.drawLine(2, 14, 2, h - 14 - 1);
                g.drawLine(w - 3, 14, w - 3, h - 14 - 1);
                g.drawLine(14, h - 3, w - 14 - 1, h - 3);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = DialogBorder.insets.top;
            newInsets.left = DialogBorder.insets.left;
            newInsets.bottom = DialogBorder.insets.bottom;
            newInsets.right = DialogBorder.insets.right;
            return newInsets;
        }
    }

    static class FrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int corner = 14;

        FrameBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color shadow;
            Color highlight;
            Color background;
            Window window = SwingUtilities.getWindowAncestor(c);
            if (window != null && QuaquaUtilities.isOnActiveWindow(window)) {
                background = Color.gray;
                highlight = Color.white;
                shadow = Color.black;
            } else {
                background = Color.darkGray;
                highlight = Color.white;
                shadow = Color.black;
            }
            g.setColor(background);
            g.drawLine(x + 1, y + 0, x + w - 2, y + 0);
            g.drawLine(x + 0, y + 1, x + 0, y + h - 2);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
            for (int i = 1; i < 5; ++i) {
                g.drawRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1);
            }
            if (window instanceof Frame && ((Frame)window).isResizable()) {
                g.setColor(highlight);
                g.drawLine(15, 3, w - 14, 3);
                g.drawLine(3, 15, 3, h - 14);
                g.drawLine(w - 2, 15, w - 2, h - 14);
                g.drawLine(15, h - 2, w - 14, h - 2);
                g.setColor(shadow);
                g.drawLine(14, 2, w - 14 - 1, 2);
                g.drawLine(2, 14, 2, h - 14 - 1);
                g.drawLine(w - 3, 14, w - 3, h - 14 - 1);
                g.drawLine(14, h - 3, w - 14 - 1, h - 3);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = FrameBorder.insets.top;
            newInsets.left = FrameBorder.insets.left;
            newInsets.bottom = FrameBorder.insets.bottom;
            newInsets.right = FrameBorder.insets.right;
            return newInsets;
        }
    }
}

