/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.ArrayList;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractVfsComponent;
import org.apache.commons.vfs2.provider.VfsComponent;

public abstract class AbstractVfsContainer
extends AbstractVfsComponent {
    private final ArrayList<Object> components = new ArrayList();

    protected void addComponent(Object component) throws FileSystemException {
        if (!this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.setLogger(this.getLogger());
                vfsComponent.setContext(this.getContext());
                vfsComponent.init();
            }
            this.components.add(component);
        }
    }

    protected void removeComponent(Object component) {
        this.components.remove(component);
    }

    public void close() {
        int count = this.components.size();
        for (int i = 0; i < count; ++i) {
            Object component = this.components.get(i);
            if (!(component instanceof VfsComponent)) continue;
            VfsComponent vfsComponent = (VfsComponent)component;
            vfsComponent.close();
        }
        this.components.clear();
    }
}

