/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.IContour;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPaneDivider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class Contour
extends JComponent
implements IContour {
    public static final int PARTIAL_OUTLINE_MODE = 0;
    public static final int MIX_OUTLINE_MODE = 1;
    public static final int FULL_OUTLINE_MODE = 2;
    private int _thickness = 4;
    private static final int TAB_WIDTH = 42;
    private static final int TAB_LEADING = 8;
    private Color _lineColor = new Color(136, 136, 136);
    private int _tabHeight = 22;
    private boolean _allowDocking = true;
    private boolean _tabDocking;
    private int _tabSide;
    private boolean _floating;
    private Component _attachedComponent;
    private int _attachedSide;
    private boolean _single;
    private JComponent _saveDraggedComponent;
    private int _saveX;
    private int _saveY;
    private int _saveMouseModifier;
    private Container _relativeContainer;
    private int _outlineMode = 0;
    private Outline _topOutline;
    private Outline _bottomOutline;
    private Outline _leftOutline;
    private Outline _rightOutline;
    private boolean _ghost = false;
    private Component _glassPane;
    private boolean _changeCursor = false;

    public Contour() {
        this(22);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
    }

    public Contour(int tabHeight) {
        this._thickness = UIDefaultsLookup.getInt("Contour.thickness") == 0 ? 4 : UIDefaultsLookup.getInt("Contour.thickness");
        this._lineColor = UIDefaultsLookup.getColor("Contour.color") == null ? new Color(136, 136, 136) : UIDefaultsLookup.getColor("Contour.color");
        this.setTabHeight(tabHeight);
        if (this.getOutlineMode() != 0) {
            this.initOutline();
        }
    }

    private void initOutline() {
        this._topOutline = new Outline();
        this._bottomOutline = new Outline();
        this._leftOutline = new Outline();
        this._rightOutline = new Outline();
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void paint(Graphics g) {
        if (!this._ghost) {
            this.paintOutline(g, false);
        }
    }

    private void paintOutline(Graphics g, boolean xorMode) {
        Rectangle bounds = this.getBounds();
        g.translate(-bounds.x, -bounds.y);
        if (xorMode) {
            bounds = SwingUtilities.convertRectangle(this, bounds, this.getRelativeContainer() != null ? this.getRelativeContainer() : this.getParent());
        } else {
            g.setColor(this._lineColor);
        }
        if (this.getOutlineMode() != 2 && this.isTabDocking()) {
            Contour.drawTab(g, bounds.x, bounds.y, bounds.width, bounds.height - 1, this._tabHeight - 1, 42, 8, this._thickness, this.getTabSide());
        } else {
            Contour.drawRect(g, bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this._thickness);
        }
    }

    private static void drawLine(Graphics g, int x1, int y1, int x2, int y2, int thick) {
        if (x1 == x2) {
            if (y2 > y1) {
                g.fillRect(x1, y1, thick, y2 - y1);
            } else {
                g.fillRect(x1, y2, thick, y1 - y2);
            }
        } else if (y1 == y2) {
            if (x2 > x1) {
                g.fillRect(x1, y1, x2 - x1, thick);
            } else {
                g.fillRect(x2, y1, x1 - x2, thick);
            }
        }
    }

    private static void drawRect(Graphics g, int x, int y, int width, int height, int thick) {
        if (width <= thick) {
            Contour.drawLine(g, x, y, x, y + height, thick);
        } else if (height <= thick) {
            Contour.drawLine(g, x, y, x + width, y, thick);
        } else {
            Contour.drawLine(g, x, y, x + width - thick, y, thick);
            Contour.drawLine(g, x + width - thick, y, x + width - thick, y + height - thick, thick);
            Contour.drawLine(g, x + width, y + height - thick, x + thick, y + height - thick, thick);
            Contour.drawLine(g, x, y + height, x, y + thick, thick);
        }
    }

    private static void drawTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, int thick, int side) {
        switch (side) {
            case 1: {
                Contour.drawTopTab(g, x, y, width, height, tabHeight, tabWidth, tabLeading, thick);
                break;
            }
            case 3: {
                Contour.drawBottomTab(g, x, y, width, height, tabHeight, tabWidth, tabLeading, thick);
            }
        }
    }

    private static void drawTopTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, int thick) {
        Contour.drawLine(g, x + width - thick, y + tabHeight, x + width - thick, y + height - 1, thick);
        Contour.drawLine(g, x + tabLeading + thick, y + tabHeight, x, y + tabHeight, thick);
        Contour.drawLine(g, x + tabWidth + tabLeading, y + tabHeight, x + tabWidth + tabLeading, y, thick);
        Contour.drawLine(g, x + tabWidth + tabLeading, y, x + tabLeading + 1, y, thick);
        Contour.drawLine(g, x + tabLeading, y, x + tabLeading, y + tabHeight, thick);
        Contour.drawLine(g, x + width, y + tabHeight, x + tabWidth + tabLeading, y + tabHeight, thick);
        Contour.drawLine(g, x, y + tabHeight, x, y + height, thick);
        Contour.drawLine(g, x, y + height - thick, x + width, y + height - thick, thick);
    }

    private static void drawBottomTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, int thick) {
        Contour.drawLine(g, x, y, x + width - 1, y, thick);
        Contour.drawLine(g, x + width - thick, y, x + width - thick, y + height - tabHeight - 1, thick);
        Contour.drawLine(g, x + width, y + height - tabHeight - thick, x + tabWidth + tabLeading, y + height - tabHeight - thick, thick);
        Contour.drawLine(g, x + tabWidth + tabLeading, y + height - tabHeight, x + tabWidth + tabLeading, y + height, thick);
        Contour.drawLine(g, x + tabWidth + tabLeading, y + height - thick, x + tabLeading + 1, y + height - thick, thick);
        Contour.drawLine(g, x + tabLeading, y + height, x + tabLeading, y + height - tabHeight, thick);
        Contour.drawLine(g, x + tabLeading + thick, y + height - tabHeight - thick, x + 1, y + height - tabHeight - thick, thick);
        Contour.drawLine(g, x, y + height - tabHeight, x, y + 1, thick);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.isLightweight()) {
            if (this.getOutlineMode() == 0) {
                if (this._ghost && (this.getRelativeContainer() != null || this.getParent() != null)) {
                    Graphics g = (this.getRelativeContainer() != null ? this.getRelativeContainer() : this.getParent()).getGraphics();
                    g.setXORMode(this._lineColor);
                    this.paintOutline(g, true);
                    super.setBounds(x, y, width % 2 == 0 ? width + 1 : width, height % 2 == 0 ? height + 1 : height);
                } else {
                    super.setBounds(x, y, width % 2 == 0 ? width + 1 : width, height % 2 == 0 ? height + 1 : height);
                }
            } else {
                Rectangle rectangle = new Rectangle(x, y, width % 2 == 0 ? width + 1 : width, height % 2 == 0 ? height + 1 : height);
                if (this.getParent() != null) {
                    Rectangle parentRectangle = this.getParent().getBounds();
                    super.setBounds(x, y, width % 2 == 0 ? width + 1 : width, height % 2 == 0 ? height + 1 : height);
                    if (this.getOutlineMode() == 1 && parentRectangle.contains(rectangle)) {
                        this._leftOutline.setVisible(false);
                        this._rightOutline.setVisible(false);
                        this._topOutline.setVisible(false);
                        this._bottomOutline.setVisible(false);
                    } else {
                        super.setVisible(false);
                        Point point = rectangle.getLocation();
                        SwingUtilities.convertPointToScreen(point, this.getParent());
                        this.arrangeOutline(rectangle, point);
                    }
                }
            }
        } else if (this.getRelativeContainer() != null) {
            Point point = new Point(x, y);
            SwingUtilities.convertPointToScreen(point, this.getRelativeContainer());
            super.setBounds(point.x, point.y, width % 2 == 0 ? width + 1 : width, height % 2 == 0 ? height + 1 : height);
        }
    }

    private void arrangeOutline(Rectangle rectangle, Point point) {
        this._leftOutline.setBounds(point.x, point.y, this._thickness, rectangle.height - this._thickness);
        this._topOutline.setBounds(point.x + this._thickness, point.y, rectangle.width - this._thickness - 1, this._thickness);
        this._rightOutline.setBounds(point.x + rectangle.width - this._thickness - 1, point.y + this._thickness, this._thickness, rectangle.height - this._thickness);
        this._bottomOutline.setBounds(point.x, point.y + rectangle.height - this._thickness, rectangle.width - 1, this._thickness);
        if (!this._topOutline.isVisible()) {
            this._topOutline.setVisible(true);
        }
        if (!this._leftOutline.isVisible()) {
            this._leftOutline.setVisible(true);
        }
        if (!this._rightOutline.isVisible()) {
            this._rightOutline.setVisible(true);
        }
        if (!this._bottomOutline.isVisible()) {
            this._bottomOutline.setVisible(true);
        }
    }

    public int getTabHeight() {
        return this._tabHeight;
    }

    public void setTabHeight(int tabHeight) {
        this._tabHeight = tabHeight;
    }

    public boolean isTabDocking() {
        return this._tabDocking;
    }

    public void setTabDocking(boolean tabDocking) {
        this._tabDocking = tabDocking;
        this.updateCursor();
    }

    public int getTabSide() {
        return this._tabSide;
    }

    public void setTabSide(int tabSide) {
        this._tabSide = tabSide;
    }

    public boolean isFloating() {
        return this._floating;
    }

    public void setFloating(boolean floating) {
        this._floating = floating;
        this.updateCursor();
    }

    public Component getAttachedComponent() {
        return this._attachedComponent;
    }

    public void setAttachedComponent(Component attachedComponent) {
        this._attachedComponent = attachedComponent;
    }

    public int getAttachedSide() {
        return this._attachedSide;
    }

    public void setAttachedSide(int attachedSide) {
        this._attachedSide = attachedSide;
        this.updateCursor();
    }

    private void updateCursor() {
        if (this.getGlassPane() == null) {
            return;
        }
        if (!this.isVisible() && this._floating) {
            this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(23));
            return;
        }
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
        if (!this._changeCursor) {
            return;
        }
        if (!this.isVisible()) {
            this.getGlassPane().setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.isVisible() && (!this._allowDocking || this._floating)) {
            this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(29));
        } else if (this.isVisible() && this._tabDocking) {
            this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(28));
        } else if (this.getAttachedComponent() instanceof JideSplitPaneDivider) {
            if (((JideSplitPaneDivider)this.getAttachedComponent()).getJideSplitPane().getOrientation() == 1) {
                this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(31));
            } else {
                this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(30));
            }
        } else {
            switch (this._attachedSide) {
                case 1: {
                    this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(24));
                    break;
                }
                case 2: {
                    this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(25));
                    break;
                }
                case 4: {
                    this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(26));
                    break;
                }
                case 8: {
                    this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(27));
                    break;
                }
                default: {
                    this.getGlassPane().setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    public boolean isSingle() {
        return this._single;
    }

    public void setSingle(boolean single) {
        this._single = single;
    }

    public boolean isAllowDocking() {
        return this._allowDocking;
    }

    public void setAllowDocking(boolean allowDocking) {
        this._allowDocking = allowDocking;
        this.updateCursor();
    }

    public Container getRelativeContainer() {
        return this._relativeContainer;
    }

    public void setRelativeContainer(Container relativeContainer) {
        this._relativeContainer = relativeContainer;
    }

    public int getSaveX() {
        return this._saveX;
    }

    public int getSaveY() {
        return this._saveY;
    }

    public int getSaveMouseModifier() {
        return this._saveMouseModifier;
    }

    public JComponent getSaveDraggedComponent() {
        return this._saveDraggedComponent;
    }

    public void setDraggingInformation(JComponent comp, int saveX, int saveY, int saveMouseModifier) {
        this._saveDraggedComponent = comp;
        this._saveX = saveX;
        this._saveY = saveY;
        this._saveMouseModifier = saveMouseModifier;
    }

    public void cleanup() {
        if (this.getOutlineMode() != 0) {
            this._leftOutline.dispose();
            this._rightOutline.dispose();
            this._topOutline.dispose();
            this._bottomOutline.dispose();
            this._leftOutline = null;
            this._rightOutline = null;
            this._topOutline = null;
            this._bottomOutline = null;
        }
        if (this.getGlassPane() != null) {
            this.getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.updateCursor();
        if (!aFlag && this.getOutlineMode() != 0) {
            this._leftOutline.setVisible(false);
            this._rightOutline.setVisible(false);
            this._topOutline.setVisible(false);
            this._bottomOutline.setVisible(false);
        }
    }

    public boolean isVisible() {
        if (super.isVisible()) {
            return true;
        }
        return this.getOutlineMode() != 0 && (this._topOutline.isVisible() || this._bottomOutline.isVisible() || this._leftOutline.isVisible() || this._rightOutline.isVisible());
    }

    public int getOutlineMode() {
        return this._outlineMode;
    }

    public void setOutlineMode(int outlineMode) {
        if (outlineMode != 0 && this._outlineMode == 0) {
            this.initOutline();
        }
        this._outlineMode = outlineMode;
    }

    public Component getGlassPane() {
        return this._glassPane;
    }

    public void setGlassPane(Component glassPane) {
        this._glassPane = glassPane;
    }

    public boolean isChangeCursor() {
        return this._changeCursor;
    }

    public void setChangeCursor(boolean changeCursor) {
        this._changeCursor = changeCursor;
    }

    class Outline
    extends JWindow {
        public Outline() {
            this.setVisible(false);
            this.setBackground(Contour.this._lineColor);
        }

        public void paint(Graphics g) {
            g.setColor(Contour.this._lineColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

