/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl;

import java.io.File;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypes;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dataTypes.impl.DefaultDataType;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToBoolean;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToByte;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToBytearray;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToDate;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToDecimal;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToDouble;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToFile;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToFloat;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToInt;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToLocale;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToLong;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToObject;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToString;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToTime;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToTimestamp;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToURI;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToURL;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToVersion;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataTypesManager
implements DataTypesManager,
DataTypes {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDataTypesManager.class);
    private static final int NEWINDEXES_AT = 65;
    private final DataType[] types = new DefaultDataType[127];

    public DefaultDataTypesManager() {
        this.addtype(1, null, "Boolean", Boolean.class, new CoerceToBoolean(), "datatype-boolean");
        this.addtype(2, null, "Byte", Byte.class, new CoerceToByte(), "datatype-byte", 11, 3, 3);
        this.addtype(3, null, "Char", Character.class, new CoerceToString());
        this.addtype(4, null, "Integer", Integer.class, new CoerceToInt(), "datatype-integer", 11, 10, 10).addAlias("int");
        this.addtype(5, null, "Long", Long.class, new CoerceToLong(), "datatype-long", 11, 19, 19).addAlias("bigint");
        this.addtype(6, null, "Float", Float.class, new CoerceToFloat(), "datatype-float", 46, 8, 8, 3);
        this.addtype(7, null, "Double", Double.class, new CoerceToDouble(), "datatype-double", 46, 16, 16, 8);
        this.addtype(19, null, "Decimal", BigDecimal.class, new CoerceToDecimal(), "datatype-decimal", 7, 2000000, 20, 3).addAlias("numeric").addAlias("double precision");
        this.addtype(8, null, "String", String.class, new CoerceToString(), "datatype-string", 16).setDefaultSize(50).addAlias("character varying").addAlias("text");
        this.addtype(9, "Date", "Date", Date.class, new CoerceToDate(), "datatype-date").addAlias("date");
        this.addtype(10, "Date", "Time", Time.class, new CoerceToTime(), "datatype-time");
        this.addtype(11, "Date", "Timestamp", Timestamp.class, new CoerceToTimestamp(), "datatype-timestamp").addAlias("timestamp").addAlias("timestamp with time zone").addAlias("timestamp without time zone");
        this.addtype(20, null, "Locale", Locale.class, new CoerceToLocale(), "datatype-locale");
        this.addtype(18, null, "Version", Version.class, new CoerceToVersion());
        this.addtype(12, null, "ByteArray", new byte[1].getClass(), new CoerceToBytearray(), "datatype-bytearray", 16).addAlias("bytea");
        this.addtype(13, "File", "File", File.class, new CoerceToFile());
        this.addtype(14, "Folder", "Folder", File.class, new CoerceToFile());
        this.addtype(15, null, "DynObject", DynObject.class, null);
        this.addtype(16, null, "URL", URL.class, new CoerceToURL());
        this.addtype(17, null, "URI", URI.class, new CoerceToURI());
        this.addtype(33, null, "Array", new Object[1].getClass(), null);
        this.addtype(34, null, "List", List.class, null);
        this.addtype(35, null, "Set", Set.class, null);
        this.addtype(36, null, "Map", Map.class, null);
        this.addtype(64, null, "Object", Object.class, new CoerceToObject(), "datatype-object");
    }

    @Override
    public final synchronized DataType addtype(int type, String subtype, String name, Class defaultClass, Coercion coercion) {
        return this.addtype(type, subtype, name, defaultClass, coercion, null, 0, -1, -1, -1);
    }

    public final synchronized DataType addtype(int type, String subtype, String name, Class defaultClass, Coercion coercion, String iconName) {
        return this.addtype(type, subtype, name, defaultClass, coercion, iconName, 0, -1, -1, -1);
    }

    @Override
    public final synchronized DataType addtype(int type, String subtype, String name, Class defaultClass, Coercion coercion, String iconName, int flags) {
        return this.addtype(type, subtype, name, defaultClass, coercion, iconName, flags, -1, -1, -1);
    }

    public final synchronized DataType addtype(int type, String subtype, String name, Class defaultClass, Coercion coercion, String iconName, int flags, int max_precision, int default_precision) {
        return this.addtype(type, subtype, name, defaultClass, coercion, iconName, flags, max_precision, default_precision, -1);
    }

    @Override
    public final synchronized DataType addtype(int type, String subtype, String name, Class defaultClass, Coercion coercion, String iconName, int flags, int max_precision, int default_precision, int default_scale) {
        if (type == 0) {
            type = this.getNewObjectIndexType();
        }
        if (type < 1 || type > 127) {
            throw new IllegalArgumentException("Wrong type " + Integer.toHexString(type).toUpperCase() + ".");
        }
        try {
            this.get(type);
            throw new IllegalArgumentException("type " + Integer.toHexString(type).toUpperCase() + ", name '" + name + "', already registered as '" + this.getTypeName(type) + "'.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DefaultDataType dataType = new DefaultDataType(type, subtype, name, defaultClass, coercion, iconName, flags, max_precision, default_precision, default_scale);
            this.types[type] = dataType;
            LOG.debug("Registered data type {}.", (Object)((Object)dataType).toString());
            return dataType;
        }
    }

    private int getNewObjectIndexType() {
        for (int i = 65; i <= 127; ++i) {
            if (this.types[i] != null) continue;
            return i;
        }
        return 0;
    }

    @Override
    public DataType get(String typename) {
        for (DataType type : this.types) {
            if (type == null) continue;
            if (StringUtils.equalsIgnoreCase((CharSequence)typename, (CharSequence)type.getName())) {
                return type;
            }
            for (String alias : type.getAlias()) {
                if (alias == null || !StringUtils.equalsIgnoreCase((CharSequence)typename, (CharSequence)alias)) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    public DataType get(int type) {
        DataType dataType = null;
        if (type > 0 && type <= 127) {
            dataType = this.types[type];
        }
        if (dataType == null) {
            throw new IllegalArgumentException("DataType " + type + " not registered");
        }
        return dataType;
    }

    @Override
    public boolean isValidType(int type) {
        return type > 0 && type <= 127 && this.types[type] != null;
    }

    @Override
    public boolean isObject(int type) {
        return (type & 0x40) == 64;
    }

    @Override
    public boolean isContainer(int type) {
        return (type & 0x20) == 32;
    }

    @Override
    public int getType(String name) {
        if (name != null) {
            for (int i = 0; i < this.types.length; ++i) {
                if (this.types[i] == null || !name.equalsIgnoreCase(this.types[i].getName())) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public String getTypeName(int type) {
        DataType dataType = this.get(type);
        String name = dataType.getName();
        if (name == null) {
            return "unknow";
        }
        return name;
    }

    @Override
    public Class getDefaultClass(int type) {
        DataType dataType = this.get(type);
        return dataType.getDefaultClass();
    }

    @Override
    public String getSubtype(int type) {
        DataType dataType = this.get(type);
        return dataType.getSubtype();
    }

    @Override
    public Coercion getCoercion(int type) {
        DataType dataType = this.get(type);
        return dataType.getCoercion();
    }

    @Override
    public void addCoercion(int type, Coercion coercion) {
        DataType dataType = this.get(type);
        dataType.addCoercion(coercion);
    }

    @Override
    public Object coerce(int type, Object value) throws CoercionException {
        DataType dataType = this.get(type);
        return dataType.coerce(value);
    }

    @Override
    public Object coerce(int type, Object value, CoercionContext ctx) throws CoercionException {
        DataType dataType = this.get(type);
        return dataType.coerce(value, ctx);
    }

    @Override
    public Iterator iterator() {
        ArrayList<DataType> list = new ArrayList<DataType>();
        for (int i = 0; i < this.types.length; ++i) {
            DataType type = this.types[i];
            if (type == null) continue;
            list.add(this.types[i]);
        }
        return list.iterator();
    }

    @Override
    public DataType getDataType(Class defaultClass) {
        Class typeClass;
        for (DataType type : this.types) {
            if (type == null || (typeClass = type.getDefaultClass()) == null || !typeClass.equals(defaultClass)) continue;
            return type;
        }
        for (DataType type : this.types) {
            if (type == null || (typeClass = type.getDefaultClass()) == null || !typeClass.isAssignableFrom(defaultClass)) continue;
            return type;
        }
        throw new IllegalArgumentException("There is not any registered data type with the class or a parent of the class: " + defaultClass);
    }
}

