/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dispose.impl;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableInfo;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class DefaultDisposableInfo
implements DisposableInfo {
    private final Disposable disposable;
    private int referencesCount;
    private final List<LabeledValue<StackTraceElement[]>> allStackTrace = new ArrayList<LabeledValue<StackTraceElement[]>>();
    private final int limit;

    public DefaultDisposableInfo(Disposable disposable, StackTraceElement[] stackTrace, int limit) {
        this.disposable = disposable;
        this.referencesCount = 0;
        this.limit = limit < 2 ? 2 : limit;
        this.addStackTrace("Bind", stackTrace);
    }

    @Override
    public StackTraceElement[] getFirstBindDisposableStackTrace() {
        if (this.allStackTrace.isEmpty()) {
            return null;
        }
        return this.allStackTrace.get(0).getValue();
    }

    public final void addStackTrace(String label, StackTraceElement[] stackTrace) {
        if (this.allStackTrace.size() >= this.limit) {
            this.allStackTrace.set(this.allStackTrace.size() - 1, new LabeledValueImpl<StackTraceElement[]>(label, stackTrace));
        } else {
            this.allStackTrace.add(new LabeledValueImpl<StackTraceElement[]>(label, stackTrace));
        }
    }

    @Override
    public Disposable getDisposable() {
        return this.disposable;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Disposable:\n\t").append(this.getDisposable()).append("\nReferencesCount:\n\t").append(this.referencesCount).append("\nStack trace:");
        StackTraceElement[] stackTrace = this.getFirstBindDisposableStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            buffer.append("\n\t").append(stackTrace[i]);
        }
        return buffer.toString();
    }

    @Override
    public String getFullDescription() {
        StringBuilder buffer = new StringBuilder();
        Disposable disposable = this.getDisposable();
        int code = disposable.hashCode();
        buffer.append("Class: ").append(disposable.getClass().getSimpleName()).append("\n");
        buffer.append("Full class: ").append(disposable.getClass().getName()).append("\n");
        buffer.append("References: ").append(this.getReferencesCount()).append("\n");
        buffer.append(String.format("Code: %x (%d)\n", code, code));
        buffer.append("toString: ").append(disposable.toString()).append("\n");
        try {
            List<LabeledValue<StackTraceElement[]>> allStackTraces = this.getAllStackTrace();
            for (int i = 0; i < allStackTraces.size(); ++i) {
                LabeledValue<StackTraceElement[]> trace = allStackTraces.get(i);
                buffer.append("#");
                buffer.append(i + 1);
                buffer.append(" ");
                buffer.append(trace.getLabel());
                buffer.append(" from (stack):\n");
                for (StackTraceElement stackTrace1 : trace.getValue()) {
                    buffer.append("  ").append(stackTrace1.toString()).append("\n");
                }
            }
        }
        catch (Exception ex) {
            buffer.append("\n\nError showing stack\n").append(ex.getMessage());
        }
        return buffer.toString();
    }

    public void incReferencesCount() {
        ++this.referencesCount;
    }

    public void decReferencesCount() {
        --this.referencesCount;
    }

    @Override
    public int getReferencesCount() {
        return this.referencesCount;
    }

    @Override
    public List<LabeledValue<StackTraceElement[]>> getAllStackTrace() {
        return this.allStackTrace;
    }
}

