/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.locator;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.tools.locator.Locator;
import org.gvsig.tools.locator.LocatorException;

public class LocatorReferenceException
extends LocatorException {
    private static final long serialVersionUID = -6623935035803501270L;
    private static final String KEY = "locator_exception";
    private static final String MESSAGE = "Error getting a reference to %(referenceName), through the Locator %(locatorName)";
    private String referenceName;
    private String locatorName;

    public LocatorReferenceException(String referenceName, Locator locator) {
        this(MESSAGE, KEY, -6623935035803501270L, referenceName, locator);
    }

    public LocatorReferenceException(Throwable cause, String referenceName, Locator locator) {
        this(MESSAGE, cause, KEY, -6623935035803501270L, referenceName, locator);
    }

    public LocatorReferenceException(String message, String key, long code, String referenceName, Locator locator) {
        super(message, key, code);
        this.setReferenceName(referenceName);
        this.setLocatorName(locator.getLocatorName());
    }

    public LocatorReferenceException(String message, Throwable cause, String key, long code, String referenceName, Locator locator) {
        super(message, cause, key, code);
        this.setReferenceName(referenceName);
        this.setLocatorName(locator.getLocatorName());
    }

    @Override
    protected Map values() {
        HashMap<String, String> values = new HashMap<String, String>(2);
        values.put("referenceName", this.getReferenceName());
        values.put("locatorName", this.getLocatorName());
        return values;
    }

    private String getReferenceName() {
        return this.referenceName;
    }

    private void setReferenceName(String name) {
        this.referenceName = name;
    }

    private String getLocatorName() {
        return this.locatorName;
    }

    private void setLocatorName(String name) {
        this.locatorName = name;
    }
}

