/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.operations.impl;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.tools.operations.Operation;
import org.gvsig.tools.operations.OperationContext;
import org.gvsig.tools.operations.OperationException;
import org.gvsig.tools.operations.OperationManager;
import org.gvsig.tools.operations.OperationNotSupportedException;

public class DefaultOperationManager
implements OperationManager {
    private Operation[] operations;
    private Map operationsInfoMap = new HashMap();
    private OperationInfo[] operationsInfo;

    public DefaultOperationManager() {
        this.operations = new Operation[1];
    }

    @Override
    public int registerOperation(Operation operation, Class theClass) {
        OperationInfo info = new OperationInfo(theClass, 0, operation);
        OperationInfo oldInfo = (OperationInfo)this.operationsInfoMap.get(info.getKey());
        if (oldInfo != null) {
            oldInfo.theClass = theClass;
            oldInfo.operation = operation;
            return oldInfo.code;
        }
        if (this.operations == null) {
            this.operations = new Operation[1];
            this.operationsInfo = new OperationInfo[1];
            info.code = 0;
        } else {
            Operation[] temp1 = new Operation[this.operations.length + 1];
            System.arraycopy(this.operations, 0, temp1, 0, this.operations.length);
            OperationInfo[] temp2 = new OperationInfo[this.operationsInfo.length + 1];
            System.arraycopy(this.operationsInfo, 0, temp2, 0, this.operationsInfo.length);
            info.code = this.operations.length - 1;
        }
        this.operations[info.code] = info.operation;
        this.operationsInfo[info.code] = info;
        this.operationsInfoMap.put(info.getKey(), info);
        return info.code;
    }

    private String getKey(Object obj, String name) {
        return obj.getClass().getName() + ":" + name;
    }

    private String getKey(Class theClass, String name) {
        return theClass.getName() + ":" + name;
    }

    @Override
    public Operation getOperation(Object obj, String name) throws OperationNotSupportedException {
        OperationInfo info = (OperationInfo)this.operationsInfoMap.get(this.getKey(obj, name));
        if (info == null) {
            throw new OperationNotSupportedException(obj.getClass(), name);
        }
        return info.operation;
    }

    @Override
    public Operation getOperation(Class theClass, String name) throws OperationNotSupportedException {
        OperationInfo info = (OperationInfo)this.operationsInfoMap.get(this.getKey(theClass, name));
        if (info == null) {
            throw new OperationNotSupportedException(theClass, name);
        }
        return info.operation;
    }

    @Override
    public Operation getOperation(Object obj, int code) throws OperationNotSupportedException {
        if (code >= this.operationsInfo.length) {
            throw new OperationNotSupportedException(obj.getClass(), code);
        }
        OperationInfo info = this.operationsInfo[code];
        if (!info.theClass.isAssignableFrom(obj.getClass())) {
            throw new OperationNotSupportedException(obj.getClass(), code);
        }
        return info.operation;
    }

    @Override
    public Operation getOperation(Class theClass, int code) throws OperationNotSupportedException {
        if (code >= this.operationsInfo.length) {
            throw new OperationNotSupportedException(theClass, code);
        }
        OperationInfo info = this.operationsInfo[code];
        if (!info.theClass.isAssignableFrom(theClass)) {
            throw new OperationNotSupportedException(theClass, code);
        }
        return info.operation;
    }

    @Override
    public boolean hasOperation(Object obj, String name) {
        try {
            Operation op = this.getOperation(obj, name);
            return op != null;
        }
        catch (OperationNotSupportedException e) {
            return false;
        }
    }

    @Override
    public boolean hasOperation(Object obj, int code) {
        try {
            Operation op = this.getOperation(obj, code);
            return op != null;
        }
        catch (OperationNotSupportedException e) {
            return false;
        }
    }

    @Override
    public boolean hasOperation(Class theClass, String name) {
        try {
            Operation op = this.getOperation(theClass, name);
            return op != null;
        }
        catch (OperationNotSupportedException e) {
            return false;
        }
    }

    @Override
    public boolean hasOperation(Class theClass, int code) {
        try {
            Operation op = this.getOperation(theClass, code);
            return op != null;
        }
        catch (OperationNotSupportedException e) {
            return false;
        }
    }

    @Override
    public Object invokeOperation(Object obj, String name, OperationContext context) throws OperationException {
        Operation op = this.getOperation(obj, name);
        return op.invoke(obj, context);
    }

    @Override
    public Object invokeOperation(Object obj, int code, OperationContext context) throws OperationException {
        try {
            return this.operations[code].invoke(obj, context);
        }
        catch (RuntimeException e) {
            this.getOperation(obj, code);
            throw e;
        }
        catch (OperationException e) {
            this.getOperation(obj, code);
            throw e;
        }
    }

    @Override
    public int getOperationCode(Class theClass, String name) throws OperationNotSupportedException {
        OperationInfo info = (OperationInfo)this.operationsInfoMap.get(this.getKey(theClass, name));
        if (info == null) {
            throw new OperationNotSupportedException(theClass, name);
        }
        return info.code;
    }

    @Override
    public int registerOperation(Operation operation, Object obj) {
        return this.registerOperation(operation, obj.getClass());
    }

    private class OperationInfo {
        Class theClass;
        int code;
        Operation operation;

        OperationInfo(Class theClass, int code, Operation operation) {
            this.theClass = theClass;
            this.code = code;
            this.operation = operation;
        }

        String getKey() {
            return this.theClass.getName() + ":" + this.operation.getName();
        }
    }
}

