/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util.impl;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gvsig.tools.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceLoader
implements ServiceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceLoader.class);
    private Set classLoaders = new LinkedHashSet();

    public DefaultServiceLoader() {
        try {
            Class.forName("java.util.ServiceLoader");
            LOG.info("Will use java.util.ServiceLoader to load services");
        }
        catch (ClassNotFoundException e) {
            LOG.info("Will use sun.misc.Service to load services");
        }
    }

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    @Override
    public Set load(Class serviceClass) {
        Set services = this.load(serviceClass, null);
        for (ClassLoader classLoader : this.classLoaders) {
            services.addAll(this.load(serviceClass, classLoader));
        }
        return services;
    }

    @Override
    public Set load(Class serviceClass, ClassLoader classLoader) {
        try {
            return this.postJDK16Load(serviceClass, classLoader);
        }
        catch (Exception e) {
            LOG.debug("Could not use the JDK >= 1.6 utility classes to load the {} implementation classes, we may be running on a JDK < 1.6, so I will try to use the JDK < 1.6 sun.misc.Service class", (Object)serviceClass);
            LOG.trace("The exception thrown is: ", (Throwable)e);
            try {
                return this.preJDK16Load(serviceClass, classLoader);
            }
            catch (Exception e2) {
                LOG.error("Error finding available " + serviceClass + " objects", (Throwable)e2);
                return null;
            }
        }
    }

    private Set preJDK16Load(Class serviceClass, ClassLoader classLoader) throws Exception {
        LOG.info("Loading " + serviceClass + " " + (serviceClass.isInterface() ? "implementations" : "extensions") + " from '" + (classLoader == null ? "System" : classLoader.toString()) + "' class loader (using sun.misc.Service class).");
        Class<?> serviceClazz = Class.forName("sun.misc.Service");
        if (serviceClazz == null) {
            LOG.error("Could not load Class sun.misc.Service using reflection");
            return null;
        }
        Method providersMethod = null;
        providersMethod = classLoader == null ? serviceClazz.getMethod("providers", Class.class) : serviceClazz.getMethod("providers", Class.class, ClassLoader.class);
        Iterator iterator = null;
        iterator = classLoader == null ? (Iterator)providersMethod.invoke(null, serviceClass) : (Iterator)providersMethod.invoke(null, serviceClass, classLoader);
        if (iterator == null) {
            LOG.debug("Empty {} objects iterator returned by the sun.misc.Service.providers method", (Object)serviceClass);
            return null;
        }
        LinkedHashSet services = new LinkedHashSet();
        while (iterator.hasNext()) {
            services.add(iterator.next());
        }
        return services;
    }

    private Set postJDK16Load(Class serviceClass, ClassLoader classLoader) throws Exception {
        LOG.info("Loading " + serviceClass + " " + (serviceClass.isInterface() ? "implementations" : "extensions") + " from '" + (classLoader == null ? "System" : classLoader.toString()) + "' class loader (using java.util.ServiceLoader class).");
        Class<?> serviceLoaderClazz = Class.forName("java.util.ServiceLoader");
        Method loadMethod = null;
        loadMethod = classLoader == null ? serviceLoaderClazz.getMethod("load", Class.class) : serviceLoaderClazz.getMethod("load", Class.class, ClassLoader.class);
        Object serviceLoader = null;
        serviceLoader = classLoader == null ? loadMethod.invoke(null, serviceClass) : loadMethod.invoke(null, serviceClass, classLoader);
        if (serviceLoader == null) {
            LOG.error("Could not load a ServiceLoader to load {} objects", (Object)serviceClass);
            return null;
        }
        Method iteratorMethod = serviceLoaderClazz.getMethod("iterator", new Class[0]);
        Iterator iterator = (Iterator)iteratorMethod.invoke(serviceLoader, new Object[0]);
        if (iterator == null) {
            LOG.debug("java.util.ServiceLoader of {} returned an empty iterator", (Object)serviceClass);
            return null;
        }
        Object obj = null;
        LinkedHashSet<Object> services = new LinkedHashSet<Object>();
        while (iterator.hasNext()) {
            try {
                obj = iterator.next();
                services.add(obj);
            }
            catch (Throwable t) {
                LOG.error("Can't load service (" + (obj == null ? "unknow" : obj.toString()) + ") from " + (classLoader == null ? "unknow" : classLoader.toString()) + ".", t);
            }
        }
        return services;
    }
}

