/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.xml.parser;

import [Ljava.lang.Object;;
import com.jeta.forms.store.JETAPersistable;
import com.jeta.forms.store.jml.JMLException;
import com.jeta.forms.store.jml.PrimitiveHolder;
import com.jeta.forms.store.jml.dom.JMLAttributes;
import com.jeta.forms.store.properties.ColorHolder;
import com.jeta.forms.store.support.PropertyMap;
import com.jeta.forms.store.xml.parser.ColorHolderHandler;
import com.jeta.forms.store.xml.parser.HashMapHandler;
import com.jeta.forms.store.xml.parser.InsetsHandler;
import com.jeta.forms.store.xml.parser.JETAPersistableHandler;
import com.jeta.forms.store.xml.parser.ListHandler;
import com.jeta.forms.store.xml.parser.ObjectArrayHandler;
import com.jeta.forms.store.xml.parser.ObjectHandler;
import com.jeta.forms.store.xml.parser.PrimitiveHandler;
import com.jeta.forms.store.xml.parser.PrimitiveHolderHandler;
import com.jeta.forms.store.xml.parser.PropertyMapHandler;
import com.jeta.forms.store.xml.parser.XMLHandler;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.xml.sax.SAXException;

public class XMLHandlerFactory {
    private HashMap m_handlers = new HashMap();
    private static XMLHandlerFactory m_singleton = new XMLHandlerFactory();
    static /* synthetic */ Class class$com$jeta$forms$store$xml$parser$XMLHandlerFactory;

    private XMLHandlerFactory() {
        this.registerHandlers();
    }

    public static XMLHandlerFactory getInstance() {
        return m_singleton;
    }

    protected XMLHandler createHandler(String className) {
        block6: {
            Class<?> c = (Class<?>)this.m_handlers.get(className);
            if (c != null) {
                try {
                    return (XMLHandler)c.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block6;
                }
            }
            try {
                c = Class.forName(className);
                if (JETAPersistable.class.isAssignableFrom(c)) {
                    return new JETAPersistableHandler();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void registerHandlers() {
        this.m_handlers.put("Boolean", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Boolean", PrimitiveHandler.class);
        this.m_handlers.put("Byte", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Byte", PrimitiveHandler.class);
        this.m_handlers.put("Character", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Character", PrimitiveHandler.class);
        this.m_handlers.put("Short", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Short", PrimitiveHandler.class);
        this.m_handlers.put("Integer", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Integer", PrimitiveHandler.class);
        this.m_handlers.put("Long", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Long", PrimitiveHandler.class);
        this.m_handlers.put("Float", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Float", PrimitiveHandler.class);
        this.m_handlers.put("Double", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Double", PrimitiveHandler.class);
        this.m_handlers.put(PropertyMap.class.getName(), PropertyMapHandler.class);
        this.m_handlers.put(HashMap.class.getName(), HashMapHandler.class);
        this.m_handlers.put(ArrayList.class.getName(), ListHandler.class);
        this.m_handlers.put(LinkedList.class.getName(), ListHandler.class);
        this.m_handlers.put(Insets.class.getName(), InsetsHandler.class);
        this.m_handlers.put("insets", InsetsHandler.class);
        this.m_handlers.put(ColorHolder.class.getName(), ColorHolderHandler.class);
        this.m_handlers.put("color", ColorHolderHandler.class);
        this.m_handlers.put(Object;.class.getName(), ObjectArrayHandler.class);
        this.m_handlers.put(PrimitiveHolder.class.getName(), PrimitiveHolderHandler.class);
    }

    private boolean isPrimitive(Class c) {
        return c == Boolean.class || c == Byte.class || c == Character.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class;
    }

    private boolean isPrimitive(String className) {
        if ("Boolean".equalsIgnoreCase(className) || "java.lang.Boolean".equalsIgnoreCase(className)) {
            return true;
        }
        if ("Byte".equalsIgnoreCase(className) || "java.lang.Byte".equalsIgnoreCase(className)) {
            return true;
        }
        if ("Character".equalsIgnoreCase(className) || "java.lang.Character".equalsIgnoreCase(className)) {
            return true;
        }
        if ("Short".equalsIgnoreCase(className) || "java.lang.Short".equalsIgnoreCase(className)) {
            return true;
        }
        if ("Integer".equalsIgnoreCase(className) || "java.lang.Integer".equalsIgnoreCase(className)) {
            return true;
        }
        if ("Long".equalsIgnoreCase(className) || "java.lang.Long".equalsIgnoreCase(className)) {
            return true;
        }
        if ("Float".equalsIgnoreCase(className) || "java.lang.Float".equalsIgnoreCase(className)) {
            return true;
        }
        return "Double".equalsIgnoreCase(className) || "java.lang.Double".equalsIgnoreCase(className);
    }

    public XMLHandler getHandler(String className) throws JMLException {
        try {
            XMLHandler handler;
            if ("null".equalsIgnoreCase(className) || className.length() == 0) {
                return new NullHandler();
            }
            if (this.isPrimitive(className) && !className.startsWith("java.lang")) {
                className = "java.lang." + className;
            }
            if ((handler = this.createHandler(className)) == null) {
                throw new JMLException("XMLHandlerFactory  handler is null for: " + className);
            }
            return handler;
        }
        catch (Exception e) {
            throw new JMLException(e.getMessage());
        }
    }

    private static class NullHandler
    extends ObjectHandler {
        static final /* synthetic */ boolean $assertionsDisabled;

        private NullHandler() {
        }

        public Object getProperty(String propName) {
            return null;
        }

        protected void setProperty(Object name, Object value, JMLAttributes attribs) throws SAXException {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        protected Object instantiateObject(JMLAttributes attribs) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            String className = attribs.getValue("classname");
            if ("null".equalsIgnoreCase(className) || className.length() == 0) {
                return null;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public Object getObject() {
            return null;
        }

        static {
            $assertionsDisabled = !(class$com$jeta$forms$store$xml$parser$XMLHandlerFactory == null ? (class$com$jeta$forms$store$xml$parser$XMLHandlerFactory = XMLHandlerFactory.class$("com.jeta.forms.store.xml.parser.XMLHandlerFactory")) : class$com$jeta$forms$store$xml$parser$XMLHandlerFactory).desiredAssertionStatus();
        }
    }
}

