/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import org.gvsig.expressionevaluator.ExpressionSyntaxException;
import org.gvsig.expressionevaluator.LexicalAnalyzer;
import org.gvsig.expressionevaluator.impl.I18N;
import org.gvsig.expressionevaluator.spi.AbstractLexicalAnalyzer;

public class SQLLexicalAnalyzer
extends AbstractLexicalAnalyzer {
    public SQLLexicalAnalyzer(String source) {
        super(source);
        this.tokens.put("null", 4);
        this.tokens.put("true", 5);
        this.tokens.put("false", 6);
        this.tokens.put("not", 9);
        this.tokens.put("like", 23);
        this.tokens.put("ilike", 24);
        this.tokens.put("is", 25);
        this.tokens.put("between", 22);
        this.tokens.put("and", 27);
        this.tokens.put("or", 26);
        this.tokens.put("isnull", 28);
        this.tokens.put("notnull", 29);
        this.tokens.put("in", 43);
    }

    public SQLLexicalAnalyzer() {
        this(null);
    }

    public LexicalAnalyzer clone() throws CloneNotSupportedException {
        SQLLexicalAnalyzer other = (SQLLexicalAnalyzer)super.clone();
        return other;
    }

    private void skipcomments() {
        if (this.isEOF()) {
            return;
        }
        char ch = this.getch();
        while (ch == '-') {
            ch = this.lookch();
            if (ch != '-') continue;
            while (ch != '\u0000' && ch != '\n') {
                ch = this.getch();
            }
            this.ungetch();
            this.skipblanks();
            ch = this.getch();
        }
        this.ungetch();
    }

    protected LexicalAnalyzer.Token getToken() {
        this.skipblanks();
        this.skipcomments();
        char ch = this.getch();
        switch (ch) {
            case '\u0000': {
                this.token.set(-1, null, null);
                return this.token;
            }
            case '~': {
                this.token.set(15, "~");
                return this.token;
            }
            case '*': {
                this.token.set(12, "*");
                return this.token;
            }
            case '/': {
                this.token.set(13, "/");
                return this.token;
            }
            case '%': {
                ch = this.getch();
                switch (ch) {
                    case '\u0000': {
                        throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), (LexicalAnalyzer)this);
                    }
                    case '>': {
                        this.token.set(42, "%>");
                        return this.token;
                    }
                }
                this.ungetch();
                this.token.set(14, "%");
                return this.token;
            }
            case '=': {
                ch = this.getch();
                switch (ch) {
                    case '\u0000': {
                        throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), (LexicalAnalyzer)this);
                    }
                    case '>': {
                        this.token.set(39, "=>");
                        return this.token;
                    }
                }
                this.ungetch();
                this.token.set(20, "=");
                return this.token;
            }
            case ':': {
                ch = this.getch();
                switch (ch) {
                    case '\u0000': {
                        throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), (LexicalAnalyzer)this);
                    }
                    case '=': {
                        this.token.set(38, ":=");
                        return this.token;
                    }
                }
                this.ungetch();
                this.token.set(40, ":");
                return this.token;
            }
            case '<': {
                ch = this.getch();
                switch (ch) {
                    case '\u0000': {
                        throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), (LexicalAnalyzer)this);
                    }
                    case '>': {
                        this.token.set(21, "<>");
                        return this.token;
                    }
                    case '=': {
                        this.token.set(18, "<=");
                        return this.token;
                    }
                    case '%': {
                        this.token.set(41, "<%");
                        return this.token;
                    }
                }
                this.ungetch();
                this.token.set(16, "<");
                return this.token;
            }
            case '>': {
                ch = this.getch();
                switch (ch) {
                    case '\u0000': {
                        throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), (LexicalAnalyzer)this);
                    }
                    case '=': {
                        this.token.set(19, ">=");
                        return this.token;
                    }
                }
                this.ungetch();
                this.token.set(17, ">");
                return this.token;
            }
            case '|': {
                ch = this.getch();
                switch (ch) {
                    case '\u0000': {
                        throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), (LexicalAnalyzer)this);
                    }
                    case '|': {
                        this.token.set(35, "||");
                        return this.token;
                    }
                }
                this.ungetch();
                break;
            }
            case '.': {
                this.token.set(33, ".");
                return this.token;
            }
            case ',': {
                this.token.set(32, ",");
                return this.token;
            }
            case '(': {
                this.token.set(30, "(");
                return this.token;
            }
            case ')': {
                this.token.set(31, ")");
                return this.token;
            }
            case '+': {
                this.token.set(10, "+");
                return this.token;
            }
            case '-': {
                ch = this.getch();
                switch (ch) {
                    case '\u0000': {
                        throw new ExpressionSyntaxException(I18N.unexpected_end_of_source(), (LexicalAnalyzer)this);
                    }
                    case '>': {
                        this.token.set(33, "->");
                        return this.token;
                    }
                }
                this.ungetch();
                this.token.set(11, "-");
                return this.token;
            }
            case '\"': {
                this.buffer.clear();
                ch = this.getch();
                while (ch != '\"') {
                    if (ch == '\u0000') {
                        throw new ExpressionSyntaxException(I18N.End_of_string_was_expected_and_end_of_source_was_found(), (LexicalAnalyzer)this);
                    }
                    this.buffer.add(ch);
                    ch = this.getch();
                }
                if (this.buffer.length() < 1) {
                    throw new ExpressionSyntaxException(I18N.Incorrect_string_length(), (LexicalAnalyzer)this);
                }
                this.token.set(0, this.buffer.toString());
                return this.token;
            }
            case ']': {
                this.token.set(37, "]");
                return this.token;
            }
            case '[': {
                if (!this.useBracketsForIdentifiers) {
                    this.token.set(36, "[");
                    return this.token;
                }
                this.buffer.clear();
                ch = this.getch();
                while (ch != ']') {
                    if (ch == '\u0000') {
                        throw new ExpressionSyntaxException(I18N.Closing_square_bracket_was_expected_and_end_of_source_was_found(), (LexicalAnalyzer)this);
                    }
                    this.buffer.add(ch);
                    ch = this.getch();
                }
                if (this.buffer.length() < 1) {
                    throw new ExpressionSyntaxException(I18N.Incorrect_identifier_length(), (LexicalAnalyzer)this);
                }
                this.token.set(0, this.buffer.toString());
                return this.token;
            }
            case '\'': {
                this.parseString();
                return this.token;
            }
            case '@': {
                char ch2 = this.getch();
                if (ch2 == '-' || ch2 == '+' || Character.isWhitespace(ch2) || Character.isDigit(ch2)) {
                    this.ungetch();
                    this.ungetch();
                    this.parseDMSNumber();
                    return this.token;
                }
                this.ungetch();
            }
        }
        if (Character.isDigit(ch)) {
            this.ungetch();
            this.parseNumber();
            return this.token;
        }
        if (Character.isAlphabetic(ch) || ch == '$' || ch == '@') {
            this.buffer.clear();
            while (Character.isLetterOrDigit(ch) || ch == '$' || ch == '_' || ch == '@') {
                this.buffer.add(ch);
                ch = this.getch();
            }
            if (ch != '\u0000') {
                this.ungetch();
            }
            String id = this.buffer.toString();
            int type = this.tokens.getOrDefault(id.toLowerCase(), 0);
            this.token.set(type, id);
            return this.token;
        }
        this.token.set(34, Character.toString(ch), (Object)Character.toString(ch));
        return this.token;
    }
}

