/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class BitAndFunction
extends AbstractFunction {
    public BitAndFunction() {
        super("Numeric", "BITAND", Range.is((Comparable)Integer.valueOf(2)), "The BITAND function treats its inputs and its output as vectors of bits; the output is the bitwise AND of the inputs.\n\nThe types of expr1 and expr2 are INTEGER or LONG, and the result is of type INTEGER or LONG.\nIf the types of expr1 or expr2 are not INTEGER or LONG a error is raised.\n", "BITAND({{expr1}}, expr2)", new String[]{"expr1 - the fisrt argument", "expr2 - the second argument"}, "Long", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object op1 = args[0];
        Object op2 = args[1];
        if (op1 instanceof Integer) {
            int value = ((Number)op1).intValue() & ((Number)op2).intValue();
            return value;
        }
        if (op1 instanceof Number) {
            long value = ((Number)op1).longValue() & ((Number)op2).longValue();
            return value;
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' function.");
    }
}

