/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.script.ScriptManager;
import org.gvsig.tools.util.MapBuilder;

public class CreateFnFunction
extends AbstractFunction {
    public static final String NAME = "CREATE_FUNCTION";
    private static final int FUNCTION_NAME = 0;
    private static final int PARAMETERS = 1;
    private static final int BODY = 2;
    private static final int SCRIPT_PATH = 3;
    private static final int SCRIPT_FUNCTION = 4;
    private static final int LANGUAGE = 5;
    private static final int EXCEPT = 6;
    private static final int DECLARE = 7;
    private static final int TYPE_USER_FUNCTION = 0;
    private static final int TYPE_JAVA_FUNCTION = 1;
    private static final int TYPE_SCRIPT_FUNCTION = 2;

    public CreateFnFunction() {
        super("Programming", NAME, Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8)), "This function allows you to define functions within the expression evaluator.\nWe can define three types of functions:\n\n<ul><li>Functions defined in the evaluator itself.</li>\n<li>Functions implemented as a static method of a java class.</li>\n<li>Functions defined in an external script.</li>\n\n</ul><b> Functions defined in the evaluator itself. </b>\n\nThey have the form:\n\n<pre>\nCREATE PROCEDURE myfun param1 AS\nBEGIN\n  RETURN 'Hello' || param1;\nEND PROCEDURE\n</pre>\n\n<b> Functions implemented as a static method </b>\n\nThey allow defining a function that will invoke a static method of a java class.\n\nThey have the form:\n\n<pre>\nCREATE FUNCTION parseInt(value) AS 'java.lang.Integer', 'parseInt' LANGUAGE 'java'\n</pre>\n\nDefines the \"parseInt\" function that receives a single parameter, and links it to the method\nstatic 'parseInt' of the class 'java.lang.Integer',\n\n<b> Functions defined in an external script. </b>\n\nIt allows defining functions that are implemented in an external script module.\n\nThey have the form:\n\n<pre>\nCREATE FUNCTION getCRS(crs) AS 'crs.py', 'getCRS' LANGUAGE 'script'\n</pre>\n\nWhat defines a \"getCRS\" function that is implemented in the python module\nlocated in \"Users / crs\" with the name 'getCRS'.", "CREATE FUNCTION {{name}}(param1, param2) AS\nBEGIN\n  PASS\nEND FUNCTION\n", null, "Object", false);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        if (args.size() == 2) {
            List argNames = (List)this.getObject(interpreter, args, 0);
            Code body = (Code)args.get(1);
            UserFunction fn = new UserFunction("Other", "", argNames, body, null, null);
            return fn;
        }
        if (!(interpreter.getSymbolTable() instanceof MutableSymbolTable)) {
            throw new ExpressionRuntimeException("The use of user functions require a mutable symbol table.");
        }
        MutableSymbolTable symbolTable = (MutableSymbolTable)interpreter.getSymbolTable();
        String name = (String)this.getObject(interpreter, args, 0);
        List argNames = (List)this.getObject(interpreter, args, 1);
        Code body = (Code)args.get(2);
        String script_path = (String)this.getObject(interpreter, args, 3);
        String script_function = (String)this.getObject(interpreter, args, 4);
        String language = (String)this.getObject(interpreter, args, 5);
        Code except = (Code)args.get(6);
        Code declare = (Code)args.get(7);
        if (StringUtils.isBlank((CharSequence)language)) {
            language = "script";
        }
        int type = 0;
        if (!StringUtils.isBlank((CharSequence)script_path) || !StringUtils.isBlank((CharSequence)script_function)) {
            switch (language.toLowerCase()) {
                case "script": {
                    type = 2;
                    break;
                }
                case "java": {
                    type = 1;
                    break;
                }
                default: {
                    throw new ExpressionRuntimeException("Unsupported language '" + language + ".");
                }
            }
        }
        AbstractFunction fn = null;
        switch (type) {
            case 0: {
                fn = new UserFunction("Other", name, argNames, body, except, declare);
                symbolTable.addFunction((Function)fn);
                break;
            }
            case 1: {
                if (StringUtils.isBlank((CharSequence)script_path) || StringUtils.isBlank((CharSequence)script_function)) {
                    throw new ExpressionRuntimeException("Requiered classname and methodname.");
                }
                fn = new JavaFunction(name, script_path, script_function);
                symbolTable.addFunction((Function)fn);
                break;
            }
            case 2: {
                if (StringUtils.isBlank((CharSequence)script_path) || StringUtils.isBlank((CharSequence)script_function)) {
                    throw new ExpressionRuntimeException("Requiered module and function name.");
                }
                fn = new ExternalFunction(name, script_path, script_function);
                symbolTable.addFunction((Function)fn);
            }
        }
        return fn;
    }

    private static class JavaFunction
    extends AbstractFunction {
        private final String fullClassName;
        private final String methodName;
        private static Map<Class, Class> typeMapping = new MapBuilder().add(Character.class, Character.TYPE).add(Byte.class, Byte.TYPE).add(Short.class, Short.TYPE).add(Integer.class, Integer.TYPE).add(Long.class, Long.TYPE).add(Float.class, Float.TYPE).add(Double.class, Double.TYPE).add(Boolean.class, Boolean.TYPE).build();

        public JavaFunction(String name, String fullClassName, String methodName) {
            super("Other", name, Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.fullClassName = fullClassName;
            this.methodName = methodName;
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            List loaders = ExpressionEvaluatorLocator.getManager().getClassLoaders();
            Class<?> theClass = null;
            for (ClassLoader loader : loaders) {
                try {
                    theClass = loader.loadClass(this.fullClassName);
                    if (theClass == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                }
            }
            if (theClass == null) {
                throw new ExpressionRuntimeException("Can't localte the class '" + this.fullClassName + "'.");
            }
            Class[] parameterTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) {
                    parameterTypes[i] = null;
                    continue;
                }
                Class<?> paramClass = args[i].getClass();
                parameterTypes[i] = typeMapping.getOrDefault(paramClass, paramClass);
            }
            Method method = theClass.getMethod(this.methodName, parameterTypes);
            Object value = method.invoke(null, args);
            return value;
        }
    }

    private static class ExternalFunction
    extends AbstractFunction {
        private final String script_path;
        private final String script_function;
        private final Script script;

        public ExternalFunction(String name, String script_path, String script_function) {
            super("Other", name, Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.script_path = script_path;
            this.script_function = script_function;
            ScriptManager scriptManager = ToolsLocator.getScriptManager();
            ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
            ResourcesStorage resourcesStorage = expressionManager.getScriptsResourcesStorage();
            this.script = scriptManager.loadScript(resourcesStorage, script_path);
            if (this.script == null) {
                throw new ExpressionRuntimeException("Can't locate '" + this.script_path + "'.");
            }
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            Object r = this.script.invokeFunction(this.script_function, args);
            return r;
        }
    }

    public static class UserFunction
    extends AbstractFunction {
        protected final Code body;
        protected final List<String> argNames;
        private final Code except;
        private final Code declare;

        public UserFunction(String group, String name, List<String> argNames, Code body, Code except, Code declare) {
            super(group, name, Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            this.argNames = argNames;
            this.body = body;
            this.except = except;
            this.declare = declare;
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            return this.call(interpreter, null, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Interpreter interpreter, MutableSymbolTable localSymbolTable, Object[] args) throws Exception {
            Object value;
            if (localSymbolTable == null) {
                ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
                localSymbolTable = manager.createSymbolTable();
            }
            ArrayList<Object> $args = new ArrayList<Object>();
            if (args != null) {
                $args.addAll(Arrays.asList(args));
            }
            localSymbolTable.setVar("$ARGS", $args);
            int max = this.argNames == null ? 0 : Math.min(this.argNames.size(), args.length);
            for (int i = 0; i < max; ++i) {
                localSymbolTable.setVar(this.argNames.get(i), args[i]);
            }
            SymbolTable savedSymbolTable = interpreter.getSymbolTable();
            localSymbolTable.addSymbolTable(savedSymbolTable);
            try {
                interpreter.setSymbolTable((SymbolTable)localSymbolTable);
                if (this.declare != null) {
                    Object object = interpreter.run(this.declare);
                }
                value = interpreter.run(this.body);
            }
            catch (Exception ex) {
                if (this.except == null) {
                    throw ex;
                }
                value = interpreter.run(this.except);
            }
            finally {
                interpreter.setSymbolTable(savedSymbolTable);
            }
            return value;
        }
    }
}

