/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.plugins.config.generate;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.gvsig.andami.plugins.config.generate.AlternativeNames;
import org.gvsig.andami.plugins.config.generate.Depends;
import org.gvsig.andami.plugins.config.generate.Extensions;
import org.gvsig.andami.plugins.config.generate.Icon;
import org.gvsig.andami.plugins.config.generate.LabelSet;
import org.gvsig.andami.plugins.config.generate.Libraries;
import org.gvsig.andami.plugins.config.generate.PopupMenus;
import org.gvsig.andami.plugins.config.generate.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class PluginConfig
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfig.class);
    private String _updateUrl;
    private Icon _icon;
    private Vector _dependsList = new Vector();
    private Vector _alternativeNamesList = new Vector();
    private ResourceBundle _resourceBundle;
    private Vector _labelSetList = new Vector();
    private Libraries _libraries;
    private PopupMenus _popupMenus;
    private Extensions _extensions;
    private String pluginName = null;
    private File pluginFolder = null;

    public void addDepends(Depends vDepends) throws IndexOutOfBoundsException {
        this._dependsList.addElement(vDepends);
        if ("org.gvsig.app".equals(vDepends.getPluginName())) {
            logger.info("Deprecated dependency 'org.gvsig.app' add optional depdency with 'org.gvsig.shp.app.mainplugin' to ensure compatibility with gvSIG 2.0.");
            Depends dep2 = new Depends();
            dep2.setOptional(true);
            dep2.setPluginName("org.gvsig.shp.app.mainplugin");
            this._dependsList.addElement(dep2);
        }
    }

    public void addDepends(int index, Depends vDepends) throws IndexOutOfBoundsException {
        this._dependsList.insertElementAt(vDepends, index);
    }

    public void addAlternativeNames(AlternativeNames vAlternativeName) throws IndexOutOfBoundsException {
        this._alternativeNamesList.addElement(vAlternativeName);
    }

    public void addAlternativeNames(int index, AlternativeNames vAlternativeName) throws IndexOutOfBoundsException {
        this._alternativeNamesList.insertElementAt(vAlternativeName, index);
    }

    public void addLabelSet(LabelSet vLabelSet) throws IndexOutOfBoundsException {
        this._labelSetList.addElement(vLabelSet);
    }

    public void addLabelSet(int index, LabelSet vLabelSet) throws IndexOutOfBoundsException {
        this._labelSetList.insertElementAt(vLabelSet, index);
    }

    public Enumeration enumerateDepends() {
        return this._dependsList.elements();
    }

    public Enumeration enumerateAlternativeNames() {
        return this._alternativeNamesList.elements();
    }

    public Enumeration enumerateLabelSet() {
        return this._labelSetList.elements();
    }

    public Depends getDepends(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._dependsList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Depends)this._dependsList.elementAt(index);
    }

    public Depends[] getDepends() {
        int size = this._dependsList.size();
        Depends[] mArray = new Depends[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Depends)this._dependsList.elementAt(index);
        }
        return mArray;
    }

    public int getDependsCount() {
        return this._dependsList.size();
    }

    public AlternativeNames getAlternativeNames(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._alternativeNamesList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (AlternativeNames)this._alternativeNamesList.elementAt(index);
    }

    public AlternativeNames[] getAlternativeNames() {
        int size = this._alternativeNamesList.size();
        AlternativeNames[] mArray = new AlternativeNames[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (AlternativeNames)this._alternativeNamesList.elementAt(index);
        }
        return mArray;
    }

    public int getAlternativeNamesCount() {
        return this._alternativeNamesList.size();
    }

    public Extensions getExtensions() {
        return this._extensions;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public LabelSet getLabelSet(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._labelSetList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (LabelSet)this._labelSetList.elementAt(index);
    }

    public LabelSet[] getLabelSet() {
        int size = this._labelSetList.size();
        LabelSet[] mArray = new LabelSet[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (LabelSet)this._labelSetList.elementAt(index);
        }
        return mArray;
    }

    public int getLabelSetCount() {
        return this._labelSetList.size();
    }

    public Libraries getLibraries() {
        return this._libraries;
    }

    public PopupMenus getPopupMenus() {
        return this._popupMenus;
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    public String getUpdateUrl() {
        return this._updateUrl;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllDepends() {
        this._dependsList.removeAllElements();
    }

    public void removeAllAlternativeNames() {
        this._alternativeNamesList.removeAllElements();
    }

    public void removeAllLabelSet() {
        this._labelSetList.removeAllElements();
    }

    public Depends removeDepends(int index) {
        Object obj = this._dependsList.elementAt(index);
        this._dependsList.removeElementAt(index);
        return (Depends)obj;
    }

    public AlternativeNames removeAlternativeNames(int index) {
        Object obj = this._alternativeNamesList.elementAt(index);
        this._alternativeNamesList.removeElementAt(index);
        return (AlternativeNames)obj;
    }

    public LabelSet removeLabelSet(int index) {
        Object obj = this._labelSetList.elementAt(index);
        this._labelSetList.removeElementAt(index);
        return (LabelSet)obj;
    }

    public void setDepends(int index, Depends vDepends) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._dependsList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._dependsList.setElementAt(vDepends, index);
    }

    public void setDepends(Depends[] dependsArray) {
        this._dependsList.removeAllElements();
        for (int i = 0; i < dependsArray.length; ++i) {
            this._dependsList.addElement(dependsArray[i]);
        }
    }

    public void setAlternativeNames(int index, AlternativeNames vAlternativeNames) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._alternativeNamesList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._alternativeNamesList.setElementAt(vAlternativeNames, index);
    }

    public void setAlternativeNames(AlternativeNames[] alternativeNamesArray) {
        this._alternativeNamesList.removeAllElements();
        for (int i = 0; i < alternativeNamesArray.length; ++i) {
            this._alternativeNamesList.addElement(alternativeNamesArray[i]);
        }
    }

    public void setExtensions(Extensions extensions) {
        this._extensions = extensions;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public void setLabelSet(int index, LabelSet vLabelSet) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._labelSetList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._labelSetList.setElementAt(vLabelSet, index);
    }

    public void setLabelSet(LabelSet[] labelSetArray) {
        this._labelSetList.removeAllElements();
        for (int i = 0; i < labelSetArray.length; ++i) {
            this._labelSetList.addElement(labelSetArray[i]);
        }
    }

    public void setLibraries(Libraries libraries) {
        this._libraries = libraries;
    }

    public void setPopupMenus(PopupMenus popupMenus) {
        this._popupMenus = popupMenus;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this._resourceBundle = resourceBundle;
    }

    public void setUpdateUrl(String updateUrl) {
        this._updateUrl = updateUrl;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (PluginConfig)Unmarshaller.unmarshal(PluginConfig.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String name) {
        this.pluginName = name;
    }

    public File getPluginFolder() {
        return this.pluginFolder;
    }

    public void setPluginFolder(File folder) {
        this.pluginFolder = folder;
    }
}

