/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.api;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.BasePropertiesPanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class BasePropertiesPanelHelper
implements BasePropertiesPanel {
    protected final JComponent component;
    protected final JComponent accept;
    protected boolean canceled;
    protected ActionListenerSupport listeners;

    public BasePropertiesPanelHelper(JComponent component, JComponent accept) {
        this.component = component;
        this.accept = accept;
        this.canceled = false;
        this.listeners = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
    }

    @Override
    public void closeWindow() {
        this.component.setVisible(false);
    }

    @Override
    public void showWindow(String title, WindowManager.MODE mode) {
        WindowManager manager = ToolsSwingLocator.getWindowManager();
        this.component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent arg0) {
                BasePropertiesPanelHelper.this.fireCloseEvent();
            }

            @Override
            public void ancestorMoved(AncestorEvent arg0) {
            }

            @Override
            public void ancestorAdded(AncestorEvent arg0) {
            }
        });
        manager.showWindow(this.component, title, mode);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listeners.addActionListener(listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.listeners.removeActionListener(listener);
    }

    @Override
    public void removeAllActionListener() {
        this.listeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        this.listeners.fireActionEvent(actionEvent);
    }

    public void fireAcceptEvent() {
        this.listeners.fireActionEvent(new ActionEvent(this.component, 1, "accept"));
    }

    public void fireCancelEvent() {
        this.listeners.fireActionEvent(new ActionEvent(this.component, 2, "cancel"));
    }

    public void fireCloseEvent() {
        this.listeners.fireActionEvent(new ActionEvent(this.component, 0, "close"));
    }

    @Override
    public void setVisibleAceptCancel(boolean visible) {
        this.accept.setVisible(visible);
    }

    @Override
    public boolean getVisibleAceptCancel() {
        return this.accept.isVisible();
    }

    @Override
    public void clear() {
    }

    @Override
    public JComponent asJComponent() {
        return this.component;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }
}

