/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.api.documentfilters;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class IntegerDocumentFilter
extends DocumentFilter {
    public static void install(JTextField text) {
        Document doc = text.getDocument();
        if (doc instanceof PlainDocument) {
            ((PlainDocument)doc).setDocumentFilter(new IntegerDocumentFilter());
        }
    }

    public static int getValue(JTextField text) {
        String s = text.getText();
        try {
            int n = Integer.parseInt(s);
            return n;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static void setValue(JTextField text, int value) {
        text.setText(String.valueOf(value));
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.insert(offset, string);
        String s = sb.toString();
        if (s.length() == 0 || s.length() == 1 && (s.charAt(0) == '-' || s.charAt(0) == '+') || this.test(s)) {
            super.insertString(fb, offset, string, attr);
        }
    }

    protected boolean test(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.replace(offset, offset + length, text);
        String s = sb.toString();
        if (s.length() == 0 || s.length() == 1 && (s.charAt(0) == '-' || s.charAt(0) == '+') || this.test(s)) {
            super.replace(fb, offset, length, text, attrs);
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.delete(offset, offset + length);
        String s = sb.toString();
        if (s.length() == 0 || s.length() == 1 && (s.charAt(0) == '-' || s.charAt(0) == '+') || this.test(s)) {
            super.remove(fb, offset, length);
        }
    }
}

