/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ocr.tess4j;

import java.awt.image.BufferedImage;
import org.apache.tika.parser.ocr.tess4j.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDeskew {
    private static final Logger LOG = LoggerFactory.getLogger(ImageDeskew.class);
    private final BufferedImage cImage;
    private final int cSteps = 200;
    private double[] cSinA;
    private double[] cCosA;
    private double cDMin;
    private int[] cHMatrix;

    public ImageDeskew(BufferedImage var1) {
        this.cImage = var1;
    }

    public double getSkewAngle() {
        double var2 = 0.0;
        int var4 = 0;
        this.calc();
        HoughLine[] var1 = this.getTop(20);
        if (var1.length < 20) {
            return 0.0;
        }
        for (int var5 = 0; var5 < 19; ++var5) {
            var2 += var1[var5].alpha;
            ++var4;
        }
        return var2 / (double)var4;
    }

    private HoughLine[] getTop(int var1) {
        int var5;
        int var4;
        HoughLine[] var2 = new HoughLine[var1];
        for (int var3 = 0; var3 < var1; ++var3) {
            var2[var3] = new HoughLine();
        }
        for (var4 = 0; var4 < this.cHMatrix.length - 1; ++var4) {
            if (this.cHMatrix[var4] <= var2[var1 - 1].count) continue;
            var2[var1 - 1].count = this.cHMatrix[var4];
            var2[var1 - 1].index = var4;
            for (var5 = var1 - 1; var5 > 0 && var2[var5].count > var2[var5 - 1].count; --var5) {
                HoughLine var7 = var2[var5];
                var2[var5] = var2[var5 - 1];
                var2[var5 - 1] = var7;
            }
        }
        for (int var6 = 0; var6 < var1; ++var6) {
            var5 = var2[var6].index / this.cSteps;
            var4 = var2[var6].index - var5 * this.cSteps;
            var2[var6].alpha = this.getAlpha(var4);
            var2[var6].d = (double)var5 + this.cDMin;
        }
        return var2;
    }

    private void calc() {
        int var1 = (int)((double)this.cImage.getHeight() / 4.0);
        int var2 = (int)((double)this.cImage.getHeight() * 3.0 / 4.0);
        this.init();
        for (int var3 = var1; var3 < var2; ++var3) {
            for (int var4 = 1; var4 < this.cImage.getWidth() - 2; ++var4) {
                if (!ImageUtil.isBlack(this.cImage, var4, var3) || ImageUtil.isBlack(this.cImage, var4, var3 + 1)) continue;
                this.calc(var4, var3);
            }
        }
    }

    private void calc(int var1, int var2) {
        for (int var7 = 0; var7 < this.cSteps - 1; ++var7) {
            double var3 = (double)var2 * this.cCosA[var7] - (double)var1 * this.cSinA[var7];
            int var5 = (int)(var3 - this.cDMin);
            int var6 = var5 * this.cSteps + var7;
            try {
                int n = var6;
                this.cHMatrix[n] = this.cHMatrix[n] + 1;
                continue;
            }
            catch (Exception var9) {
                LOG.warn("", (Throwable)var9);
            }
        }
    }

    private void init() {
        this.cSinA = new double[this.cSteps - 1];
        this.cCosA = new double[this.cSteps - 1];
        for (int var3 = 0; var3 < this.cSteps - 1; ++var3) {
            double var1 = this.getAlpha(var3) * Math.PI / 180.0;
            this.cSinA[var3] = Math.sin(var1);
            this.cCosA[var3] = Math.cos(var1);
        }
        this.cDMin = -this.cImage.getWidth();
        double cDStep = 1.0;
        int cDCount = (int)(2.0 * (double)(this.cImage.getWidth() + this.cImage.getHeight()) / 1.0);
        this.cHMatrix = new int[cDCount * this.cSteps];
    }

    public double getAlpha(int var1) {
        double cAlphaStart = -20.0;
        double cAlphaStep = 0.2;
        return -20.0 + (double)var1 * 0.2;
    }

    public static class HoughLine {
        public int count = 0;
        public int index = 0;
        public double alpha;
        public double d;
    }
}

