/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.ViewFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.io.StreamDocumentSource;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.swingbox.BrowserPane;
import org.fit.cssbox.swingbox.SwingBoxDocument;
import org.fit.cssbox.swingbox.SwingBoxViewFactory;
import org.fit.cssbox.swingbox.util.CSSBoxAnalyzer;
import org.fit.cssbox.swingbox.util.ContentReader;
import org.fit.cssbox.swingbox.util.ContentWriter;
import org.fit.cssbox.swingbox.util.GeneralEvent;
import org.fit.cssbox.swingbox.util.MouseController;

public class SwingBoxEditorKit
extends StyledEditorKit {
    private static final long serialVersionUID = -2774578978116020429L;
    private CSSBoxAnalyzer cbanalyzer;
    private ViewFactory vfactory;
    private JEditorPane component;
    private MouseController mcontroller;

    public SwingBoxEditorKit() {
        String tmp = System.getProperty("swingbox.default.analyzer", "property_not_set");
        if (tmp == "property_not_set") {
            System.setProperty("swingbox.default.analyzer", "org.fit.cssbox.swingbox.util.DefaultAnalyzer");
        }
        if ((tmp = System.getProperty("swingbox.document.async_load_priority", "property_not_set")) == "property_not_set") {
            System.setProperty("swingbox.document.async_load_priority", "-1");
        }
        this.mcontroller = new MouseController();
    }

    public SwingBoxEditorKit(CSSBoxAnalyzer cba) {
        this();
        this.cbanalyzer = cba;
    }

    @Override
    public void install(JEditorPane c) {
        super.install(c);
        c.addMouseListener(this.mcontroller);
        c.addMouseMotionListener(this.mcontroller);
        this.component = c;
    }

    @Override
    public void deinstall(JEditorPane c) {
        super.deinstall(c);
        c.removeMouseListener(this.mcontroller);
        c.removeMouseMotionListener(this.mcontroller);
        this.component = null;
    }

    @Override
    public Document createDefaultDocument() {
        SwingBoxDocument doc = new SwingBoxDocument();
        int priority = -1;
        String tmp = System.getProperty("swingbox.document.async_load_priority", "property_not_set");
        if (tmp != "property_not_set") {
            try {
                priority = Integer.parseInt(tmp);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        doc.setAsynchronousLoadPriority(priority);
        return doc;
    }

    @Override
    public ViewFactory getViewFactory() {
        if (this.vfactory == null) {
            this.vfactory = new SwingBoxViewFactory();
        }
        return this.vfactory;
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public Caret createCaret() {
        return null;
    }

    @Override
    public void write(OutputStream out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof SwingBoxDocument) {
            BufferedWriter tmpOut = new BufferedWriter(new OutputStreamWriter(out, Charset.defaultCharset()), 8192);
            this.writeImpl(tmpOut, (SwingBoxDocument)doc, pos, len);
            ((Writer)tmpOut).flush();
            ((Writer)tmpOut).close();
        } else {
            super.write(out, doc, pos, len);
        }
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof SwingBoxDocument) {
            BufferedWriter tmpOut = new BufferedWriter(out, 8192);
            this.writeImpl(tmpOut, (SwingBoxDocument)doc, pos, len);
            ((Writer)tmpOut).flush();
            ((Writer)tmpOut).close();
        } else {
            super.write(out, doc, pos, len);
        }
    }

    @Override
    public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof SwingBoxDocument) {
            this.readImpl(in, (SwingBoxDocument)doc, pos);
        } else {
            super.read(in, doc, pos);
        }
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof SwingBoxDocument) {
            ReaderInputStream is = new ReaderInputStream(in);
            this.readImpl((InputStream)is, (SwingBoxDocument)doc, pos);
        } else {
            super.read(in, doc, pos);
        }
    }

    public void update(SwingBoxDocument doc, Viewport root, Dimension dim) throws IOException {
        ContentReader rdr = new ContentReader();
        List<DefaultStyledDocument.ElementSpec> elements = rdr.update(root, dim, this.getCSSBoxAnalyzer());
        DefaultStyledDocument.ElementSpec[] elementsArray = elements.toArray(new DefaultStyledDocument.ElementSpec[0]);
        doc.create(elementsArray);
    }

    public void setCSSBoxAnalyzer(CSSBoxAnalyzer cba) {
        this.cbanalyzer = cba;
    }

    public CSSBoxAnalyzer getCSSBoxAnalyzer() {
        if (this.cbanalyzer == null) {
            this.cbanalyzer = this.getDefaultAnalyzer();
        }
        return this.cbanalyzer;
    }

    protected CSSBoxAnalyzer getDefaultAnalyzer() {
        CSSBoxAnalyzer cba;
        String cname = System.getProperty("swingbox.default.analyzer", "property_not_set");
        if ("property_not_set" == cname) {
            cba = null;
        } else {
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> c = loader != null ? loader.loadClass(cname) : Class.forName(cname);
                Object o = c.newInstance();
                cba = o instanceof CSSBoxAnalyzer ? (CSSBoxAnalyzer)o : null;
            }
            catch (Exception e) {
                cba = null;
            }
        }
        return cba;
    }

    private void readImpl(InputStream in, SwingBoxDocument doc, int pos) throws IOException, BadLocationException {
        List<DefaultStyledDocument.ElementSpec> elements;
        if (this.component == null) {
            throw new IllegalStateException("Component is null, editor kit is probably deinstalled from a JEditorPane.");
        }
        if (pos > doc.getLength() || pos < 0) {
            BadLocationException e = new BadLocationException("Invalid location", pos);
            this.readError(null, e);
            throw e;
        }
        ContentReader rdr = new ContentReader();
        URL url = (URL)doc.getProperty("stream");
        CSSBoxAnalyzer analyzer = this.getCSSBoxAnalyzer();
        Container parent = this.component.getParent();
        Dimension dim = parent != null && parent instanceof JViewport ? ((JViewport)parent).getExtentSize() : this.component.getBounds().getSize();
        if (dim.width <= 10) {
            Dimension tmp = Toolkit.getDefaultToolkit().getScreenSize();
            dim.setSize((double)tmp.width / 2.5, (double)tmp.height / 2.5);
        }
        try {
            String ctype = null;
            Object ct = doc.getProperty("Content-Type");
            if (ct != null) {
                ctype = ct instanceof List ? (String)((List)ct).get(0) : ct.toString();
            }
            StreamDocumentSource docSource = new StreamDocumentSource(in, url, ctype);
            elements = rdr.read((DocumentSource)docSource, analyzer, dim);
            String title = analyzer.getDocumentTitle();
            if (title == null) {
                title = "No title";
            }
            doc.putProperty("title", title);
        }
        catch (IOException e) {
            this.readError(url, e);
            throw e;
        }
        DefaultStyledDocument.ElementSpec[] elementsArray = elements.toArray(new DefaultStyledDocument.ElementSpec[0]);
        doc.create(elementsArray);
        this.readFinish(url);
    }

    private void readError(URL url, Exception e) {
        if (this.component instanceof BrowserPane) {
            ((BrowserPane)this.component).fireGeneralEvent(new GeneralEvent(this, GeneralEvent.EventType.page_loading_error, url, e));
        }
    }

    private void readFinish(URL url) {
        if (this.component instanceof BrowserPane) {
            ((BrowserPane)this.component).fireGeneralEvent(new GeneralEvent(this, GeneralEvent.EventType.page_loading_end, url, null));
        }
    }

    private void writeImpl(Writer out, SwingBoxDocument doc, int pos, int len) throws BadLocationException, IOException {
        if (pos > doc.getLength() || pos < 0) {
            throw new BadLocationException("Invalid location", pos);
        }
        if (len < 0) {
            len = 0;
        }
        ContentWriter wrt = new ContentWriter();
        StringBuilder sb = wrt.write(this.getCSSBoxAnalyzer().getDocument());
        out.write(sb.toString());
        out.flush();
    }
}

