/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.util;

import java.awt.Cursor;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DefaultHyperlinkHandler
implements HyperlinkListener {
    private static final Cursor HandCursor = Cursor.getPredefinedCursor(12);
    private static final Cursor DefaultCursor = Cursor.getPredefinedCursor(0);

    @Override
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        JEditorPane pane = (JEditorPane)evt.getSource();
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setCursor(pane, DefaultCursor);
            this.loadPage(pane, evt);
        } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.regionEntered(pane, evt);
        } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.regionExited(pane, evt);
        }
    }

    protected void loadPage(JEditorPane pane, HyperlinkEvent evt) {
        try {
            pane.setPage(evt.getURL());
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    protected void regionEntered(JEditorPane pane, HyperlinkEvent evt) {
        this.setCursor(pane, HandCursor);
    }

    protected void regionExited(JEditorPane pane, HyperlinkEvent evt) {
        this.setCursor(pane, DefaultCursor);
    }

    protected void setCursor(JEditorPane editor, Cursor cursor) {
        if (editor.getCursor() != cursor) {
            editor.setCursor(cursor);
        }
    }
}

