/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.view;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.CompositeView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.swingbox.util.Anchor;
import org.fit.cssbox.swingbox.view.CSSBoxView;
import org.w3c.dom.Element;

public class ElementBoxView
extends CompositeView
implements CSSBoxView {
    protected ElementBox box;
    protected Anchor anchor;
    protected int order;
    private AttributeSet attributes;
    private boolean refreshAttributes;
    private boolean refreshProperties;
    private Dimension oldDimension;
    private int majorAxis = 1;
    private boolean majorAllocValid;
    private boolean minorAllocValid;
    private boolean majorReqValid;
    private boolean minorReqValid;
    private SizeRequirements majorRequest;
    private SizeRequirements minorRequest;

    public ElementBoxView(javax.swing.text.Element elem) {
        super(elem);
        AttributeSet tmpAttr = elem.getAttributes();
        Object obj = tmpAttr.getAttribute("attribute_box_reference");
        Integer i = (Integer)tmpAttr.getAttribute("attribute_drawing_order");
        int n = this.order = i == null ? -1 : i;
        if (obj != null && obj instanceof ElementBox) {
            this.box = (ElementBox)obj;
            if (this.box instanceof BlockBox && ((BlockBox)this.box).isFloating()) {
                this.majorAxis = 0;
            }
        } else {
            throw new IllegalArgumentException("Box reference is null or not an instance of ElementBox");
        }
        obj = tmpAttr.getAttribute("attribute_anchor_reference");
        if (obj == null || !(obj instanceof Anchor)) {
            throw new IllegalArgumentException("Anchor reference is null or not an instance of Anchor");
        }
        this.anchor = (Anchor)obj;
        this.oldDimension = new Dimension();
        this.loadElementAttributes();
    }

    private void loadElementAttributes() {
        Element elem = Anchor.findAnchorElement(this.box.getElement());
        Map<String, String> elementAttributes = this.anchor.getProperties();
        if (elem != null) {
            this.anchor.setActive(true);
            elementAttributes.put("a_href", elem.getAttribute("href"));
            elementAttributes.put("a_name", elem.getAttribute("name"));
            elementAttributes.put("a_title", elem.getAttribute("title"));
            String target = elem.getAttribute("target");
            if ("".equals(target)) {
                target = "_self";
            }
            elementAttributes.put("a_target", target);
        } else {
            this.anchor.setActive(false);
            elementAttributes.clear();
        }
    }

    public String toString() {
        String s = this.getClass().getSimpleName();
        s = s + " " + this.order;
        if (this.box != null) {
            s = s + ": " + this.box;
        }
        return s;
    }

    @Override
    public int getDrawingOrder() {
        return this.order;
    }

    public int getAxis() {
        return this.majorAxis;
    }

    public void setAxis(int axis) {
        boolean axisChanged = axis != this.majorAxis;
        this.majorAxis = axis;
        if (axisChanged) {
            this.preferenceChanged(null, true, true);
        }
    }

    public void layoutChanged(int axis) {
        if (axis == this.majorAxis) {
            this.majorAllocValid = false;
        } else {
            this.minorAllocValid = false;
        }
    }

    protected boolean isLayoutValid(int axis) {
        if (axis == this.majorAxis) {
            return this.majorAllocValid;
        }
        return this.minorAllocValid;
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes(this.getElement().getAttributes());
            this.refreshAttributes = true;
            this.refreshProperties = false;
        } else {
            this.attributes = null;
            this.box = null;
            this.refreshAttributes = true;
            this.refreshProperties = false;
        }
    }

    protected void setPropertiesFromAttributes(AttributeSet attributes) {
    }

    protected Anchor getAnchor() {
        return this.anchor;
    }

    @Override
    public void replace(int offset, int length, View[] views) {
        super.replace(offset, length, views);
        this.majorReqValid = false;
        this.majorAllocValid = false;
        this.minorReqValid = false;
        this.minorAllocValid = false;
    }

    @Override
    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory f) {
        boolean wasValid = this.isLayoutValid(this.majorAxis);
        super.forwardUpdate(ec, e, a, f);
        if (wasValid && !this.isLayoutValid(this.majorAxis)) {
            Container c = this.getContainer();
            if (a != null && c != null) {
                Rectangle alloc = this.getInsideAllocation(a);
                c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }
    }

    @Override
    public void preferenceChanged(View child, boolean width, boolean height) {
        boolean minorChanged;
        boolean majorChanged = this.majorAxis == 0 ? width : height;
        boolean bl = minorChanged = this.majorAxis == 0 ? height : width;
        if (majorChanged) {
            this.majorReqValid = false;
            this.majorAllocValid = false;
        }
        if (minorChanged) {
            this.minorReqValid = false;
            this.minorAllocValid = false;
        }
        super.preferenceChanged(child, width, height);
    }

    @Override
    public int getResizeWeight(int axis) {
        if (axis == this.majorAxis ? this.majorRequest.preferred != this.majorRequest.minimum || this.majorRequest.preferred != this.majorRequest.maximum : this.minorRequest.preferred != this.minorRequest.minimum || this.minorRequest.preferred != this.minorRequest.maximum) {
            return 1;
        }
        return 0;
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.refreshAttributes) {
            this.attributes = this.createAttributes();
            this.refreshAttributes = false;
            this.refreshProperties = false;
        }
        return this.attributes;
    }

    protected SimpleAttributeSet createAttributes() {
        SimpleAttributeSet res = new SimpleAttributeSet();
        res.addAttribute("attribute_anchor_reference", this.anchor);
        res.addAttribute("attribute_box_reference", this.box);
        return res;
    }

    private SizeRequirements getRequirements(int axis, SizeRequirements r) {
        if (r == null) {
            r = new SizeRequirements();
        }
        r.alignment = 0.0f;
        if (axis == 0) {
            r.minimum = r.preferred = this.box.getWidth();
            r.maximum = r.preferred;
        } else {
            r.minimum = r.preferred = this.box.getHeight();
            r.maximum = r.preferred;
        }
        return r;
    }

    public void updateProperties() {
        this.invalidateProperties();
    }

    protected void invalidateCache() {
        this.refreshAttributes = true;
    }

    protected void invalidateProperties() {
        this.refreshProperties = true;
    }

    @Override
    public float getAlignment(int axis) {
        this.checkRequests(axis);
        if (axis == this.majorAxis) {
            return this.majorRequest.alignment;
        }
        return this.minorRequest.alignment;
    }

    @Override
    public void paint(Graphics graphics, Shape allocation) {
        if (!(graphics instanceof Graphics2D)) {
            throw new RuntimeException("Unknown graphics enviroment, java.awt.Graphics2D required !");
        }
        Graphics2D g = (Graphics2D)graphics;
        Rectangle clip = ElementBoxView.toRect(g.getClip());
        Rectangle alloc = ElementBoxView.toRect(allocation);
        int count = this.getViewCount();
        for (int i = 0; i < count; ++i) {
            Rectangle bounds = new Rectangle(alloc);
            this.childAllocation(i, bounds);
            if (!clip.intersects(bounds)) continue;
            this.getView(i).paint(g, allocation);
        }
    }

    @Override
    public Shape getChildAllocation(int index, Shape a) {
        if (a != null) {
            Box tmpBox = ElementBoxView.getBox(this.getView(index));
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            alloc.setBounds(this.getCompleteBoxAllocation(tmpBox));
            return alloc;
        }
        return null;
    }

    @Override
    protected void childAllocation(int index, Rectangle alloc) {
        alloc.setBounds(this.getCompleteBoxAllocation(ElementBoxView.getBox(this.getView(index))));
    }

    private Rectangle getCompleteBoxAllocation(Box b) {
        Rectangle ret = b.getAbsoluteBounds();
        if (b instanceof ElementBox) {
            ElementBox eb = (ElementBox)b;
            for (int i = eb.getStartChild(); i < eb.getEndChild(); ++i) {
                Box child = eb.getSubBox(i);
                if (!child.isVisible()) continue;
                Rectangle r = this.getCompleteBoxAllocation(child);
                ret.add(r);
            }
        }
        return ret.intersection(b.getClipBlock().getClippedContentBounds());
    }

    @Override
    public float getPreferredSpan(int axis) {
        float marginSpan;
        this.checkRequests(axis);
        float f = marginSpan = axis == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (axis == this.majorAxis) {
            return (float)this.majorRequest.preferred + marginSpan;
        }
        return (float)this.minorRequest.preferred + marginSpan;
    }

    @Override
    public float getMinimumSpan(int axis) {
        float marginSpan;
        this.checkRequests(axis);
        float f = marginSpan = axis == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (axis == this.majorAxis) {
            return (float)this.majorRequest.minimum + marginSpan;
        }
        return (float)this.minorRequest.minimum + marginSpan;
    }

    @Override
    public float getMaximumSpan(int axis) {
        float marginSpan;
        this.checkRequests(axis);
        float f = marginSpan = axis == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (axis == this.majorAxis) {
            return (float)this.majorRequest.maximum + marginSpan;
        }
        return (float)this.minorRequest.maximum + marginSpan;
    }

    protected boolean isAllocationValid() {
        return this.majorAllocValid && this.minorAllocValid;
    }

    @Override
    protected boolean isBefore(int x, int y, Rectangle innerAlloc) {
        innerAlloc.setBounds(this.box.getAbsoluteBounds());
        if (this.majorAxis == 0) {
            return x < innerAlloc.x;
        }
        return y < innerAlloc.y;
    }

    @Override
    protected boolean isAfter(int x, int y, Rectangle innerAlloc) {
        innerAlloc.setBounds(this.box.getAbsoluteBounds());
        if (this.majorAxis == 0) {
            return x > innerAlloc.width + innerAlloc.x;
        }
        return y > innerAlloc.height + innerAlloc.y;
    }

    @Override
    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        View retv = null;
        int retorder = -1;
        Vector<View> leaves = new Vector<View>();
        this.findLeaves(this, leaves);
        for (View leaf : leaves) {
            Box b;
            View v = leaf;
            if (!(v instanceof CSSBoxView) || this.locateBox(b = ElementBoxView.getBox(v), x, y) == null) continue;
            while (v.getParent() != null && v.getParent() != this) {
                v = v.getParent();
            }
            int o = ((CSSBoxView)((Object)v)).getDrawingOrder();
            if (retv != null && o < retorder) continue;
            retv = v;
            retorder = this.order;
            alloc.setBounds(this.getCompleteBoxAllocation(b));
        }
        return retv;
    }

    private void findLeaves(View root, Vector<View> leaves) {
        if (root instanceof ElementBoxView) {
            ElementBoxView ev = (ElementBoxView)root;
            if (ev.getViewCount() == 0) {
                leaves.add(ev);
            } else {
                for (int i = 0; i < ev.getViewCount(); ++i) {
                    this.findLeaves(ev.getView(i), leaves);
                }
            }
        } else {
            leaves.add(root);
        }
    }

    private Box locateBox(Box root, int x, int y) {
        if (root.isVisible()) {
            Box found = null;
            Rectangle bounds = root.getAbsoluteContentBounds().intersection(root.getClipBlock().getClippedContentBounds());
            if (bounds.contains(x, y)) {
                found = root;
            }
            if (root instanceof ElementBox) {
                ElementBox eb = (ElementBox)root;
                for (int i = eb.getStartChild(); i < eb.getEndChild(); ++i) {
                    Box inside = this.locateBox(((ElementBox)root).getSubBox(i), x, y);
                    if (inside == null) continue;
                    if (found == null) {
                        found = inside;
                        continue;
                    }
                    if (inside.getAbsoluteBounds().width * inside.getAbsoluteBounds().height >= found.getAbsoluteBounds().width * found.getAbsoluteBounds().height) continue;
                    found = inside;
                }
            }
            return found;
        }
        return null;
    }

    @Override
    public void setSize(float width, float height) {
        if ((float)this.oldDimension.width != width) {
            this.oldDimension.setSize((int)width, this.oldDimension.height);
            this.layoutChanged(0);
        }
        if ((float)this.oldDimension.height != height) {
            this.oldDimension.setSize(this.oldDimension.width, (int)height);
            this.layoutChanged(1);
        }
    }

    protected boolean validateLayout(Dimension dim) {
        if (this.majorAxis == 0) {
            this.majorRequest = this.getRequirements(0, this.majorRequest);
            this.minorRequest = this.getRequirements(1, this.minorRequest);
            this.oldDimension.setSize(this.majorRequest.preferred, this.minorRequest.preferred);
        } else {
            this.majorRequest = this.getRequirements(1, this.majorRequest);
            this.minorRequest = this.getRequirements(0, this.minorRequest);
            this.oldDimension.setSize(this.minorRequest.preferred, this.majorRequest.preferred);
        }
        this.majorReqValid = true;
        this.minorReqValid = true;
        this.majorAllocValid = true;
        this.minorAllocValid = true;
        return false;
    }

    private void checkRequests(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
        if (axis == this.majorAxis) {
            if (!this.majorReqValid) {
                this.majorRequest = this.getRequirements(axis, this.majorRequest);
                this.majorReqValid = true;
            }
        } else if (!this.minorReqValid) {
            this.minorRequest = this.getRequirements(axis, this.minorRequest);
            this.minorReqValid = true;
        }
    }

    public static final Rectangle toRect(Shape a) {
        return a instanceof Rectangle ? (Rectangle)a : a.getBounds();
    }

    public static final boolean intersection(Rectangle src1, Rectangle src2, Rectangle dest) {
        int x1 = Math.max(src1.x, src2.x);
        int y1 = Math.max(src1.y, src2.y);
        int x2 = Math.min(src1.x + src1.width, src2.x + src2.width);
        int y2 = Math.min(src1.y + src1.height, src2.y + src2.height);
        dest.setBounds(x1, y1, x2 - x1, y2 - y1);
        return dest.width > 0 && dest.height > 0;
    }

    public static final Box getBox(CSSBoxView v) {
        try {
            AttributeSet attr = v.getAttributes();
            return (Box)attr.getAttribute("attribute_box_reference");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static final Box getBox(View v) {
        if (v instanceof CSSBoxView) {
            return ElementBoxView.getBox((CSSBoxView)((Object)v));
        }
        AttributeSet attr = v.getAttributes();
        if (attr == null) {
            throw new NullPointerException("AttributeSet of " + v.getClass().getName() + "@" + Integer.toHexString(v.hashCode()) + " is set to NULL.");
        }
        Object obj = attr.getAttribute("attribute_box_reference");
        if (obj != null && obj instanceof Box) {
            return (Box)obj;
        }
        throw new IllegalArgumentException("Box reference in attributes is not an instance of a Box.");
    }
}

