/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.view;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.fit.cssbox.swingbox.SwingBoxDocument;
import org.fit.cssbox.swingbox.SwingBoxEditorKit;
import org.fit.cssbox.swingbox.view.BlockBoxView;

public class ViewportView
extends BlockBoxView
implements ComponentListener {
    private Reference<JViewport> cachedViewPort;
    private JEditorPane editor;
    private Dimension tmpDimension = new Dimension();

    public ViewportView(Element elem) {
        super(elem);
    }

    @Override
    protected boolean validateLayout(Dimension dim) {
        boolean result = this.checkSize(dim);
        if (!result) {
            super.validateLayout(dim);
        }
        return result;
    }

    @Override
    public void paint(Graphics graphics, Shape allocation) {
        if (!(graphics instanceof Graphics2D)) {
            throw new RuntimeException("Unknown graphics enviroment, java.awt.Graphics2D required !");
        }
        Graphics2D g = (Graphics2D)graphics;
        this.box.getVisualContext().updateGraphics(g);
        this.box.drawBackground(g);
        super.paint(graphics, allocation);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    private void hook() {
        Container parentContainer;
        Container container = this.getContainer();
        if (container != null && container instanceof JEditorPane && (parentContainer = container.getParent()) != null && parentContainer instanceof JViewport) {
            this.editor = (JEditorPane)container;
            JViewport viewPort = (JViewport)parentContainer;
            if (this.cachedViewPort != null) {
                JViewport cachedObject = this.cachedViewPort.get();
                if (cachedObject != null) {
                    if (cachedObject != viewPort) {
                        ((JComponent)cachedObject).removeComponentListener(this);
                    }
                } else {
                    this.cachedViewPort = null;
                }
            }
            if (this.cachedViewPort == null) {
                viewPort.addComponentListener(this);
                this.cachedViewPort = new WeakReference<JViewport>(viewPort);
            }
        } else {
            this.unhook();
        }
    }

    private void unhook() {
        if (this.cachedViewPort != null) {
            JViewport cachedObject = this.cachedViewPort.get();
            if (cachedObject != null) {
                ((JComponent)cachedObject).removeComponentListener(this);
            }
            this.cachedViewPort = null;
        }
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent == null) {
            this.unhook();
            this.editor = null;
        } else {
            this.hook();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() instanceof JViewport) {
            this.checkSize(((JViewport)e.getSource()).getSize());
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private boolean checkSize(Dimension extentSize) {
        if (extentSize.width == 0 || extentSize.height == 0) {
            return false;
        }
        int diffx = Math.abs(extentSize.width - this.box.getViewport().getBounds().width);
        int diffy = Math.abs(extentSize.height - this.box.getViewport().getBounds().height);
        if (diffx > 20 || diffy > 20) {
            Document doc = this.getDocument();
            this.tmpDimension.setSize(extentSize);
            if (doc instanceof SwingBoxDocument) {
                return this.doLayout((SwingBoxDocument)doc, this.tmpDimension);
            }
        }
        return false;
    }

    private boolean doLayout(SwingBoxDocument doc, Dimension dim) {
        try {
            EditorKit kit = this.editor.getEditorKit();
            if (kit instanceof SwingBoxEditorKit) {
                ((SwingBoxEditorKit)kit).update(doc, this.box.getViewport(), dim);
            }
            this.preferenceChanged(null, true, true);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

