/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.awt.text;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class RotatedTextUtils {
    private static final double PI_HALF = 1.5707963267948966;
    private static final double PI_HALF3 = 4.71238898038469;
    private static final double PI_HALF4 = Math.PI * 2;
    public static final int ANCHOR_CORNER = 0;
    public static final int ANCHOR_CENTER = 1;
    public static final int PLACEMENT_TOP = 0;
    public static final int PLACEMENT_BOTTOM = 1;
    public static final int PLACEMENT_LEFT = 2;
    public static final int PLACEMENT_RIGHT = 3;

    public static void draw(Point2D origin, Graphics2D g, String strText, double angle, int relativePosition, int anchor) {
        AffineTransform defaultAt = g.getTransform();
        AffineTransform finalAt = g.getTransform();
        finalAt.rotate(angle);
        g.setTransform(finalAt);
        TextLayout text = new TextLayout(strText, g.getFont(), g.getFontRenderContext());
        Point2D position = null;
        if (anchor == 0) {
            switch (relativePosition) {
                case 3: {
                    position = RotatedTextUtils.getPositionRightCorner(origin, text, angle);
                    break;
                }
                case 1: {
                    position = RotatedTextUtils.getPositionBottomCorner(origin, text, angle);
                    break;
                }
                case 2: {
                    position = RotatedTextUtils.getPositionLeftCorner(origin, text, angle);
                    break;
                }
                default: {
                    position = RotatedTextUtils.getPositionTopCorner(origin, text, angle);
                    break;
                }
            }
        } else {
            switch (relativePosition) {
                case 3: {
                    position = RotatedTextUtils.getPositionRightCenter(origin, text, angle);
                    break;
                }
                case 1: {
                    position = RotatedTextUtils.getPositionBottomCenter(origin, text, angle);
                    break;
                }
                case 2: {
                    position = RotatedTextUtils.getPositionLeftCenter(origin, text, angle);
                    break;
                }
                default: {
                    position = RotatedTextUtils.getPositionTopCenter(origin, text, angle);
                }
            }
        }
        text.draw(g, (float)position.getX(), (float)position.getY());
        g.setTransform(defaultAt);
    }

    public static Point2D getPosition(Point2D origin, TextLayout text, double angle, int relativePosition, int anchor) {
        if (anchor == 0) {
            switch (relativePosition) {
                case 3: {
                    return RotatedTextUtils.getPositionRightCorner(origin, text, angle);
                }
                case 1: {
                    return RotatedTextUtils.getPositionBottomCorner(origin, text, angle);
                }
                case 2: {
                    return RotatedTextUtils.getPositionLeftCorner(origin, text, angle);
                }
            }
            return RotatedTextUtils.getPositionTopCorner(origin, text, angle);
        }
        switch (relativePosition) {
            case 3: {
                return RotatedTextUtils.getPositionRightCenter(origin, text, angle);
            }
            case 1: {
                return RotatedTextUtils.getPositionBottomCenter(origin, text, angle);
            }
            case 2: {
                return RotatedTextUtils.getPositionLeftCenter(origin, text, angle);
            }
        }
        return RotatedTextUtils.getPositionTopCenter(origin, text, angle);
    }

    public static Point2D getPositionTopCorner(Point2D origin, TextLayout text, double angle) {
        double yOffset;
        double xOffset;
        double height = text.getBounds().getHeight();
        double descent = text.getBounds().getHeight() + text.getBounds().getY();
        double width = text.getAdvance();
        double correctedOriginX = origin.getX() + RotatedTextUtils.getRotatedDescent2(descent, angle);
        double correctedOriginY = origin.getY() - RotatedTextUtils.getRotatedDescent1(descent, angle);
        if (angle > 0.0 && angle < 1.5707963267948966) {
            xOffset = -RotatedTextUtils.getRotatedWidth1(width, angle) - RotatedTextUtils.getRotatedWidth2(height, angle) / 2.0;
            yOffset = -RotatedTextUtils.getRotatedHeight1(width, angle);
        } else if (angle < 0.1) {
            xOffset = 0.0;
            yOffset = 0.0;
        } else if (angle > 4.71238898038469) {
            xOffset = RotatedTextUtils.getRotatedWidth2(height, angle) / 2.0;
            yOffset = 0.0;
        } else if (angle < Math.PI) {
            xOffset = RotatedTextUtils.getRotatedWidth1(width, angle) - RotatedTextUtils.getRotatedWidth2(height, angle) / 2.0;
            yOffset = -(RotatedTextUtils.getRotatedHeight1(width, angle) + RotatedTextUtils.getRotatedHeight2(height, angle));
        } else {
            xOffset = RotatedTextUtils.getRotatedWidth2(height, angle) / 2.0;
            yOffset = -RotatedTextUtils.getRotatedHeight2(height, angle);
        }
        Point2D.Double result = new Point2D.Double(correctedOriginX + xOffset, correctedOriginY + yOffset);
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    public static Point2D getPositionTopCenter(Point2D origin, TextLayout text, double angle) {
        double yOffset;
        double xOffset;
        double height = text.getBounds().getHeight();
        double descent = text.getBounds().getHeight() + text.getBounds().getY();
        double width = text.getAdvance();
        double correctedOriginX = origin.getX() + RotatedTextUtils.getRotatedDescent2(descent, angle);
        double correctedOriginY = origin.getY() - RotatedTextUtils.getRotatedDescent1(descent, angle);
        if (angle > 0.0 && angle < 1.5707963267948966) {
            xOffset = -(RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle)) / 2.0;
            yOffset = -RotatedTextUtils.getRotatedHeight1(width, angle);
        } else if (angle < 0.1) {
            xOffset = -width / 2.0;
            yOffset = 0.0;
        } else if (angle > 4.71238898038469) {
            xOffset = (RotatedTextUtils.getRotatedWidth2(height, angle) - RotatedTextUtils.getRotatedWidth1(width, angle)) / 2.0;
            yOffset = 0.0;
        } else if (angle < Math.PI) {
            xOffset = (RotatedTextUtils.getRotatedWidth1(width, angle) - RotatedTextUtils.getRotatedWidth2(height, angle)) / 2.0;
            yOffset = -(RotatedTextUtils.getRotatedHeight1(width, angle) + RotatedTextUtils.getRotatedHeight2(height, angle));
        } else {
            xOffset = (RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle)) / 2.0;
            yOffset = -RotatedTextUtils.getRotatedHeight2(height, angle);
        }
        Point2D.Double result = new Point2D.Double(correctedOriginX + xOffset, correctedOriginY + yOffset);
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    public static Point2D getPositionRightCorner(Point2D origin, TextLayout text, double angle) {
        double yOffset;
        double xOffset;
        double height = text.getBounds().getHeight();
        double descent = text.getBounds().getHeight() + text.getBounds().getY();
        double width = text.getAdvance();
        double correctedOriginX = origin.getX() + RotatedTextUtils.getRotatedDescent2(descent, angle);
        double correctedOriginY = origin.getY() - RotatedTextUtils.getRotatedDescent1(descent, angle);
        if (angle > 0.0 && angle < 1.5707963267948966) {
            xOffset = 0.0;
            yOffset = RotatedTextUtils.getRotatedHeight2(height, angle) / 2.0;
        } else if (angle < 0.1) {
            xOffset = 0.0;
            yOffset = height / 2.0;
        } else if (angle > 4.71238898038469) {
            xOffset = RotatedTextUtils.getRotatedWidth2(height, angle);
            yOffset = RotatedTextUtils.getRotatedHeight2(height, angle) / 2.0;
        } else if (angle < Math.PI) {
            xOffset = RotatedTextUtils.getRotatedWidth1(width, angle);
            yOffset = -RotatedTextUtils.getRotatedHeight1(width, angle) - RotatedTextUtils.getRotatedHeight2(height, angle) / 2.0;
        } else {
            xOffset = RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle);
            yOffset = -RotatedTextUtils.getRotatedHeight2(height, angle) / 2.0 + RotatedTextUtils.getRotatedHeight1(width, angle);
        }
        Point2D.Double result = new Point2D.Double(correctedOriginX + xOffset, correctedOriginY + yOffset);
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    public static Point2D getPositionRightCenter(Point2D origin, TextLayout text, double angle) {
        double yOffset;
        double xOffset;
        double height = text.getBounds().getHeight();
        double descent = text.getBounds().getHeight() + text.getBounds().getY();
        double width = text.getAdvance();
        double correctedOriginX = origin.getX() + RotatedTextUtils.getRotatedDescent2(descent, angle);
        double correctedOriginY = origin.getY() - RotatedTextUtils.getRotatedDescent1(descent, angle);
        if (angle > 0.0 && angle < 1.5707963267948966) {
            xOffset = 0.0;
            yOffset = (RotatedTextUtils.getRotatedHeight2(height, angle) - RotatedTextUtils.getRotatedHeight1(width, angle)) / 2.0;
        } else if (angle < 0.1) {
            xOffset = 0.0;
            yOffset = height / 2.0;
        } else if (angle > 4.71238898038469) {
            xOffset = RotatedTextUtils.getRotatedWidth2(height, angle);
            yOffset = (RotatedTextUtils.getRotatedHeight1(width, angle) + RotatedTextUtils.getRotatedHeight2(height, angle)) / 2.0;
        } else if (angle < Math.PI) {
            xOffset = RotatedTextUtils.getRotatedWidth1(width, angle);
            yOffset = -(RotatedTextUtils.getRotatedHeight2(height, angle) + RotatedTextUtils.getRotatedHeight1(width, angle)) / 2.0;
        } else {
            xOffset = RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle);
            yOffset = (RotatedTextUtils.getRotatedHeight1(width, angle) - RotatedTextUtils.getRotatedHeight2(height, angle)) / 2.0;
        }
        Point2D.Double result = new Point2D.Double(correctedOriginX + xOffset, correctedOriginY + yOffset);
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    public static Point2D getPositionBottomCorner(Point2D origin, TextLayout text, double angle) {
        double yOffset;
        double xOffset;
        double height = text.getBounds().getHeight();
        double descent = text.getBounds().getHeight() + text.getBounds().getY();
        double width = text.getAdvance();
        double correctedOriginX = origin.getX() + RotatedTextUtils.getRotatedDescent2(descent, angle);
        double correctedOriginY = origin.getY() - RotatedTextUtils.getRotatedDescent1(descent, angle);
        if (angle > 0.0 && angle <= 1.5707963267948966) {
            xOffset = -RotatedTextUtils.getRotatedWidth2(height, angle) / 2.0;
            yOffset = RotatedTextUtils.getRotatedHeight2(height, angle);
        } else if (angle < 0.1) {
            xOffset = 0.0;
            yOffset = height;
        } else if (angle >= 4.71238898038469) {
            xOffset = RotatedTextUtils.getRotatedWidth2(height, angle) / 2.0 - RotatedTextUtils.getRotatedWidth1(width, angle);
            yOffset = RotatedTextUtils.getRotatedHeight1(width, angle) + RotatedTextUtils.getRotatedHeight2(height, angle);
        } else if (angle < Math.PI) {
            xOffset = -RotatedTextUtils.getRotatedWidth2(height, angle) / 2.0;
            yOffset = 0.0;
        } else {
            xOffset = RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle) / 2.0;
            yOffset = RotatedTextUtils.getRotatedHeight1(width, angle);
        }
        Point2D.Double result = new Point2D.Double(correctedOriginX + xOffset, correctedOriginY + yOffset);
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    public static Point2D getPositionBottomCenter(Point2D origin, TextLayout text, double angle) {
        double yOffset;
        double xOffset;
        double height = text.getBounds().getHeight();
        double descent = text.getBounds().getHeight() + text.getBounds().getY();
        double width = text.getAdvance();
        double correctedOriginX = origin.getX() + RotatedTextUtils.getRotatedDescent2(descent, angle);
        double correctedOriginY = origin.getY() - RotatedTextUtils.getRotatedDescent1(descent, angle);
        if (angle > 0.0 && angle < 1.5707963267948966) {
            xOffset = -(RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle)) / 2.0;
            yOffset = RotatedTextUtils.getRotatedHeight2(height, angle);
        } else if (angle < 0.1) {
            xOffset = -width / 2.0;
            yOffset = height;
        } else if (angle > 4.71238898038469) {
            xOffset = (RotatedTextUtils.getRotatedWidth2(height, angle) - RotatedTextUtils.getRotatedWidth1(width, angle)) / 2.0;
            yOffset = RotatedTextUtils.getRotatedHeight1(width, angle) + RotatedTextUtils.getRotatedHeight2(height, angle);
        } else if (angle < Math.PI) {
            xOffset = (RotatedTextUtils.getRotatedWidth1(width, angle) - RotatedTextUtils.getRotatedWidth2(height, angle)) / 2.0;
            yOffset = 0.0;
        } else {
            xOffset = (RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle)) / 2.0;
            yOffset = RotatedTextUtils.getRotatedHeight1(width, angle);
        }
        Point2D.Double result = new Point2D.Double(correctedOriginX + xOffset, correctedOriginY + yOffset);
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    public static Point2D getPositionLeftCorner(Point2D origin, TextLayout text, double angle) {
        double yOffset;
        double xOffset;
        double height = text.getBounds().getHeight();
        double descent = text.getBounds().getHeight() + text.getBounds().getY();
        double width = text.getAdvance();
        double correctedOriginX = origin.getX() + RotatedTextUtils.getRotatedDescent2(descent, angle);
        double correctedOriginY = origin.getY() - RotatedTextUtils.getRotatedDescent1(descent, angle);
        if (angle > 0.0 && angle < 1.5707963267948966) {
            xOffset = -(RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle));
            yOffset = RotatedTextUtils.getRotatedHeight2(height, angle) / 2.0 - RotatedTextUtils.getRotatedHeight1(width, angle);
        } else if (angle < 0.1) {
            xOffset = -width;
            yOffset = height / 2.0;
        } else if (angle > 4.71238898038469) {
            xOffset = -RotatedTextUtils.getRotatedWidth1(width, angle);
            yOffset = RotatedTextUtils.getRotatedHeight1(width, angle) + RotatedTextUtils.getRotatedHeight2(height, angle) / 2.0;
        } else if (angle < Math.PI) {
            xOffset = -RotatedTextUtils.getRotatedWidth2(height, angle);
            yOffset = -RotatedTextUtils.getRotatedHeight2(height, angle) / 2.0;
        } else {
            xOffset = 0.0;
            yOffset = -RotatedTextUtils.getRotatedHeight2(height, angle) / 2.0;
        }
        Point2D.Double result = new Point2D.Double(correctedOriginX + xOffset, correctedOriginY + yOffset);
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    public static Point2D getPositionLeftCenter(Point2D origin, TextLayout text, double angle) {
        double yOffset;
        double xOffset;
        double height = text.getBounds().getHeight();
        double descent = text.getBounds().getHeight() + text.getBounds().getY();
        double width = text.getAdvance();
        double correctedOriginX = origin.getX() + RotatedTextUtils.getRotatedDescent2(descent, angle);
        double correctedOriginY = origin.getY() - RotatedTextUtils.getRotatedDescent1(descent, angle);
        if (angle > 0.0 && angle < 1.5707963267948966) {
            xOffset = -(RotatedTextUtils.getRotatedWidth1(width, angle) + RotatedTextUtils.getRotatedWidth2(height, angle));
            yOffset = (RotatedTextUtils.getRotatedHeight2(height, angle) - RotatedTextUtils.getRotatedHeight1(width, angle)) / 2.0;
        } else if (angle < 0.1) {
            xOffset = -width;
            yOffset = height / 2.0;
        } else if (angle > 4.71238898038469) {
            xOffset = -RotatedTextUtils.getRotatedWidth1(width, angle);
            yOffset = (RotatedTextUtils.getRotatedHeight1(width, angle) + RotatedTextUtils.getRotatedHeight2(height, angle)) / 2.0;
        } else if (angle < Math.PI) {
            xOffset = -RotatedTextUtils.getRotatedWidth2(height, angle);
            yOffset = -(RotatedTextUtils.getRotatedHeight2(height, angle) + RotatedTextUtils.getRotatedHeight1(width, angle)) / 2.0;
        } else {
            xOffset = 0.0;
            yOffset = (RotatedTextUtils.getRotatedHeight1(width, angle) - RotatedTextUtils.getRotatedHeight2(height, angle)) / 2.0;
        }
        Point2D.Double result = new Point2D.Double(correctedOriginX + xOffset, correctedOriginY + yOffset);
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return result;
    }

    public static void drawRotated(Point2D location, Graphics2D g, String strText, double angle) {
        AffineTransform defaultAt = g.getTransform();
        AffineTransform at = AffineTransform.getRotateInstance(angle);
        g.setTransform(at);
        TextLayout text = new TextLayout(strText, g.getFont(), g.getFontRenderContext());
        Point2D.Double result = new Point2D.Double(location.getX(), location.getY());
        try {
            at.inverseTransform(result, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        text.draw(g, (float)((Point2D)result).getX(), (float)((Point2D)result).getY());
        g.setTransform(defaultAt);
    }

    public static double normalizeAngle(double angle) {
        double module = angle % (Math.PI * 2);
        if (module >= 0.0) {
            return module;
        }
        return angle + Math.PI * 2;
    }

    private static double getRotatedHeight1(double width, double angle) {
        return Math.abs(width * Math.sin(angle));
    }

    private static double getRotatedHeight2(double height, double angle) {
        return Math.abs(height * Math.cos(angle));
    }

    private static double getRotatedWidth1(double width, double angle) {
        return Math.abs(width * Math.cos(angle));
    }

    private static double getRotatedWidth2(double height, double angle) {
        return Math.abs(height * Math.sin(angle));
    }

    private static double getRotatedDescent1(double descent, double angle) {
        return descent * Math.sin(angle + 1.5707963267948966);
    }

    private static double getRotatedDescent2(double descent, double angle) {
        return descent * Math.sin(angle);
    }

    private static double getRotatedOffsetX1(double baseOffsetX, double angle) {
        return Math.abs(baseOffsetX * Math.cos(angle + 1.5707963267948966));
    }

    private static double getRotatedOffsetX2(double baseOffsetX, double angle) {
        return Math.abs(baseOffsetX * Math.sin(angle));
    }
}

