/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.configurableactions;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.collections4.CollectionUtils;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.SupportIsEnable;
import org.gvsig.tools.swing.api.SupportIsVisible;

public class ActionsControllerImpl
implements ConfigurableActionsMamager.ActionsController {
    private final JComponent component;
    private final Object source;
    private Collection<Action> actions;

    public ActionsControllerImpl(Collection<Action> actions, Object source, JComponent component) {
        this.component = component;
        this.source = source;
        this.update(actions);
        this.initComponent();
    }

    private void initComponent() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.component.setToolTipText(i18n.getTranslation("_Click_to_see_more_action_in_this_panel"));
        URL url = this.getClass().getResource("/org/gvsig/configurableactions/images/configurableactions.png");
        if (this.component instanceof AbstractButton) {
            AbstractButton comp = (AbstractButton)this.component;
            if (comp.getText().equals("...")) {
                comp.setText("");
            }
            comp.setIcon(new ImageIcon(url));
        } else if (this.component instanceof JLabel) {
            JLabel comp = (JLabel)this.component;
            if (comp.getText().equals("...")) {
                comp.setText("");
            }
            comp.setIcon(new ImageIcon(url));
        }
        this.component.setBorder(null);
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 1) {
                    ActionsControllerImpl.this.doShowMenu();
                }
            }
        });
    }

    public void update(Collection<Action> actions) {
        this.actions = actions;
        if (actions == null || actions.isEmpty()) {
            this.component.setVisible(false);
        } else {
            this.component.setVisible(true);
        }
    }

    public Collection<Action> getActions() {
        return this.actions;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Object getSource() {
        return this.source;
    }

    public void addAction(Action action) {
        ArrayList<Action> theActions = new ArrayList<Action>();
        if (CollectionUtils.isNotEmpty(this.actions)) {
            theActions.addAll(this.actions);
        }
        theActions.add(action);
        this.actions = theActions;
    }

    private void doShowMenu() {
        JPopupMenu menu = new JPopupMenu();
        SupportIsVisible visible = null;
        if (this.source instanceof SupportIsVisible) {
            visible = (SupportIsVisible)this.source;
        }
        SupportIsEnable enabled = null;
        if (this.source instanceof SupportIsEnable) {
            enabled = (SupportIsEnable)this.source;
        }
        for (Action action : this.actions) {
            if (visible != null && !visible.isVisible((Object)action)) continue;
            JMenuItem item = new JMenuItem(new ActionListenerAdapter(action));
            if (enabled != null && !enabled.isEnabled((Object)action)) {
                item.setEnabled(false);
            }
            menu.add(item);
        }
        menu.show(this.component, 0, this.component.getHeight());
    }

    private class ActionListenerAdapter
    extends AbstractAction {
        private final Action action;

        public ActionListenerAdapter(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e.setSource(ActionsControllerImpl.this.source);
            this.action.actionPerformed(e);
        }

        @Override
        public Object getValue(String key) {
            return this.action.getValue(key);
        }

        @Override
        public void putValue(String key, Object newValue) {
            this.action.putValue(key, newValue);
        }

        @Override
        public boolean isEnabled() {
            return this.action.isEnabled();
        }

        @Override
        public void setEnabled(boolean newValue) {
            this.action.setEnabled(newValue);
        }
    }
}

