/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.filedialogchooser.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.filedialogchooser.impl.JFileChooserBased;
import org.gvsig.filedialogchooser.impl.VFSJFileChooserBased;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;

public class DefaultFileDialogChooserManager
implements FileDialogChooserManager {
    private Map<String, File> lastPaths = new HashMap<String, File>();
    private boolean useNativeFileChooser = true;

    public void setUseNativeFileChooser(boolean b) {
        this.useNativeFileChooser = b;
    }

    public boolean useNativeFileChooser() {
        return this.useNativeFileChooser;
    }

    public FileDialogChooser create(String fileChooserID) {
        if (this.useNativeFileChooser) {
            return new JFileChooserBased(fileChooserID);
        }
        return new VFSJFileChooserBased(fileChooserID);
    }

    public FileDialogChooser create() {
        String fileChooserID = "DEFAULT_ID";
        if (this.useNativeFileChooser) {
            return new JFileChooserBased(fileChooserID);
        }
        return new VFSJFileChooserBased(fileChooserID);
    }

    public File getLastPath(String fileChooserID, File defaultDirectory) {
        return ToolsLocator.getFoldersManager().getLastPath(fileChooserID, defaultDirectory);
    }

    public void setLastPath(String fileChooserID, File path) {
        ToolsLocator.getFoldersManager().setLastPath(fileChooserID, path);
    }

    public static CharsetPickerController setCharsetAccesoryPanel(FileDialogChooser fc) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel lblLabel = new JLabel(i18n.getTranslation("_Charset"));
        lblLabel.setAlignmentX(0.0f);
        panel.add((Component)lblLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 19, 2, new Insets(1, 2, 1, 2), 0, 0));
        JComboBox cboCharset = new JComboBox();
        panel.add(cboCharset, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 19, 2, new Insets(1, 2, 1, 2), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 19, 1, new Insets(0, 0, 0, 0), 0, 0));
        CharsetPickerController charsetPicker = ToolsSwingLocator.getToolsSwingManager().createCharsetPickerController(lblLabel, cboCharset);
        fc.setAccessory((JComponent)panel);
        return charsetPicker;
    }
}

