/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.gvsig.json.Json;
import org.gvsig.json.JsonArrayBuilderImpl;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonManagerImpl;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.JsonObjectImpl;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.util.GetItemByKeyWithGetKeys;
import org.gvsig.tools.util.GetItemWithSize;

public class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    private final javax.json.JsonObjectBuilder builder;
    private final JsonManager manager;

    public JsonObjectBuilderImpl() {
        this(Json.getManager());
    }

    public JsonObjectBuilderImpl(JsonManager manager) {
        this.manager = manager;
        this.builder = javax.json.Json.createObjectBuilder();
    }

    public JsonObjectBuilder add(String name, SupportToJson value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        this.builder.add(name, (javax.json.JsonObjectBuilder)value.toJsonBuilder());
        return this;
    }

    public JsonObjectBuilder add(String name, Object value) {
        if (value == null) {
            this.builder.addNull(name);
        } else if (value instanceof SupportToJson) {
            this.add(name, (javax.json.JsonObjectBuilder)((SupportToJson)value).toJsonBuilder());
        } else if (value instanceof String) {
            this.builder.add(name, (String)value);
        } else if (value instanceof Integer) {
            this.builder.add(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.builder.add(name, ((Long)value).longValue());
        } else if (value instanceof BigInteger) {
            this.builder.add(name, (BigInteger)value);
        } else if (value instanceof BigDecimal) {
            this.builder.add(name, (BigDecimal)value);
        } else if (value instanceof Double) {
            this.builder.add(name, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            this.builder.add(name, ((Boolean)value).booleanValue());
        } else if (value.getClass().isArray()) {
            this.add(name, (Object[])value);
        } else if (value instanceof Class) {
            this.add(name, (Class)value);
        } else {
            JsonManager.JsonSerializer serializer = this.manager.getSerializer(value);
            if (serializer != null) {
                this.add(name, (javax.json.JsonObjectBuilder)serializer.toJsonBuilder(value));
            } else if (value instanceof DynObject) {
                this.add(name, (DynObject)value);
            } else if (value instanceof GetItemByKeyWithGetKeys) {
                this.add(name, (GetItemByKeyWithGetKeys)value);
            } else if (value instanceof List) {
                this.add(name, (List)value);
            } else if (value instanceof Set) {
                this.add(name, (Set)value);
            } else if (value instanceof Map) {
                this.add(name, (Map)value);
            } else if (value instanceof Iterable) {
                this.add(name, (Iterable)value);
            } else if (value instanceof Iterator) {
                this.add(name, (Iterator)value);
            } else {
                throw new IllegalArgumentException("Can't serialize to Json an object of class '" + value.getClass().getName() + "'.");
            }
        }
        return this;
    }

    public JsonObjectBuilder add(String name, Object[] value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
        arrayBuilder.addAll(value);
        this.builder.add(name, (JsonArrayBuilder)arrayBuilder);
        return this;
    }

    public JsonObjectBuilder add(String name, Iterable value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add(name, (javax.json.JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.builder.add(name, (JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonObjectBuilder add(String name, Map value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        JsonObjectBuilderImpl objBuilder = new JsonObjectBuilderImpl();
        objBuilder.addAll(value);
        this.builder.add(name, (javax.json.JsonObjectBuilder)objBuilder);
        return this;
    }

    public JsonObjectBuilder add(String name, GetItemByKeyWithGetKeys value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add(name, (javax.json.JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonObjectBuilderImpl objBuilder = new JsonObjectBuilderImpl();
            objBuilder.addAll(value);
            this.builder.add(name, (javax.json.JsonObjectBuilder)objBuilder);
        }
        return this;
    }

    public JsonObjectBuilder add(String name, GetItemWithSize value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add(name, (javax.json.JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.builder.add(name, (JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonObjectBuilder add(String name, List value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add(name, (javax.json.JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.builder.add(name, (JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonObjectBuilder add(String name, Iterator value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add(name, (javax.json.JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.builder.add(name, (JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonObjectBuilder add(String name, Set value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add(name, (javax.json.JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.builder.add(name, (JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonObjectBuilder add(String name, JsonValue value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, String value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, BigInteger value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, BigDecimal value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, int value) {
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, long value) {
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, double value) {
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, boolean value) {
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, javax.json.JsonObjectBuilder value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, Class value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        this.builder.add(name, value.getName());
        return this;
    }

    public javax.json.JsonObjectBuilder add(String name, JsonArrayBuilder value) {
        if (value == null) {
            this.builder.addNull(name);
            return this;
        }
        this.builder.add(name, value);
        return this;
    }

    public JsonObjectBuilder add_class(Class value) {
        if (value == null) {
            this.builder.addNull("__classname__");
            return this;
        }
        this.builder.add("__classname__", JsonManagerImpl.createSerializerKey(value));
        return this;
    }

    public JsonObjectBuilder add_class(Object value) {
        if (value == null) {
            this.add_class(null);
            return this;
        }
        this.add_class(value.getClass());
        return this;
    }

    public JsonObjectBuilder addAll(GetItemByKeyWithGetKeys values) {
        if (values == null) {
            return this;
        }
        for (Object key : values.getKeys()) {
            if (key == null) continue;
            this.add((String)key, values.get(key));
        }
        return this;
    }

    public JsonObjectBuilder addAll(Map values) {
        if (values == null) {
            return this;
        }
        Set entries = values.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getKey() == null) continue;
            this.add((String)entry.getKey(), entry.getValue());
        }
        return this;
    }

    public JsonObjectBuilder addAll(JsonObjectBuilder values) {
        return this.addAll(values.build());
    }

    public JsonObjectBuilder addAll(JsonObject values) {
        if (values == null) {
            return this;
        }
        for (String name : values.keySet()) {
            if (name == null || name.equals("__classname__")) continue;
            this.add(name, (JsonValue)values.get((Object)name));
        }
        return this;
    }

    public JsonObjectBuilder addAll(DynObject value) {
        DynClass dynClass = value.getDynClass();
        for (DynField dynField : dynClass.getDynFields()) {
            String name = dynField.getName();
            this.add(name, value.getDynValue(name));
        }
        return this;
    }

    public JsonObjectBuilder addNull(String name) {
        this.builder.addNull(name);
        return this;
    }

    public JsonObject build() {
        return new JsonObjectImpl(this.builder.build());
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        JsonWriterFactory writerFactory = javax.json.Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        try (JsonWriter jsonWriter = writerFactory.createWriter((Writer)sw);){
            jsonWriter.writeObject(this.builder.build());
        }
        String s = sw.toString();
        return s;
    }
}

