/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.util.InformationBuilder;

public class BaseInformationBuilder
implements InformationBuilder {
    private String backgroundColor = "\"#FFFFFF\"";
    private String backgroundColorTitle = "\"#FBFFE1\"";
    private String backgroundColorPropertyLabel = "\"#D6D6D6\"";
    private String backgroundColorPropertyValue1 = "\"#FEEDD6\"";
    private String backgroundColorPropertyValue2 = "\"#EAEAEA\"";
    protected int propertyCount = 0;
    protected final List<InformationBuilder.Element> elements = new ArrayList<InformationBuilder.Element>();

    public InformationBuilder backgroundColor(String color) {
        this.backgroundColor = color;
        return this;
    }

    public InformationBuilder backgroundColorTitle(String color) {
        this.backgroundColorTitle = color;
        return this;
    }

    public InformationBuilder backgroundColorPropertyLabel(String color) {
        this.backgroundColorPropertyLabel = color;
        return this;
    }

    public InformationBuilder backgroundColorPropertyValue1(String color) {
        this.backgroundColorPropertyValue1 = color;
        return this;
    }

    public InformationBuilder backgroundColorPropertyValue2(String color) {
        this.backgroundColorPropertyValue2 = color;
        return this;
    }

    public InformationBuilder.TitleElement title() {
        BaseTitleElement element = new BaseTitleElement();
        this.elements.add((InformationBuilder.Element)element);
        return element;
    }

    public InformationBuilder.PropertyElement property() {
        BasePropertyElement element = new BasePropertyElement();
        this.elements.add((InformationBuilder.Element)element);
        return element;
    }

    public InformationBuilder.TextElement text() {
        BaseTextElement element = new BaseTextElement();
        this.elements.add((InformationBuilder.Element)element);
        return element;
    }

    public InformationBuilder.RawElement raw() {
        BaseRawElement element = new BaseRawElement();
        this.elements.add((InformationBuilder.Element)element);
        return element;
    }

    public String build() {
        StringBuilder html = new StringBuilder();
        html.append("<html>\n");
        html.append("<body bgcolor=").append(this.backgroundColor).append(" topmargin=\"0\" marginheight=\"0\">\n");
        html.append("<table cellpadding=\"0\" cellspacing=\"0\" align=\"center\" width=\"100%\">");
        boolean first = true;
        for (InformationBuilder.Element element : this.elements) {
            if (element instanceof InformationBuilder.TitleElement) {
                if (first) {
                    first = false;
                } else {
                    html.append("<tr>\n<td><br></td>\n<td></td></tr>\n");
                }
            }
            html.append(element.build());
        }
        html.append("</table>");
        html.append("</body>");
        html.append("</html>");
        return html.toString();
    }

    public String toString() {
        return this.build();
    }

    protected class BasePropertyElement
    implements InformationBuilder.PropertyElement {
        protected String label;
        protected boolean monospace = false;
        protected String value;

        protected BasePropertyElement() {
        }

        public InformationBuilder.PropertyElement value(String format, Object ... args) {
            this.value = args == null ? StringEscapeUtils.escapeHtml3((String)format) : StringEscapeUtils.escapeHtml3((String)String.format(format, args));
            return this;
        }

        public InformationBuilder.PropertyElement label(String label) {
            this.label = StringEscapeUtils.escapeHtml3((String)label);
            return this;
        }

        public InformationBuilder.PropertyElement labelkey(String labelkey) {
            return this.label(ToolsLocator.getI18nManager().getTranslation(labelkey));
        }

        public InformationBuilder.PropertyElement monospace() {
            this.monospace = true;
            return this;
        }

        public String build() {
            String color = BaseInformationBuilder.this.propertyCount++ % 2 == 0 ? BaseInformationBuilder.this.backgroundColorPropertyValue1 : BaseInformationBuilder.this.backgroundColorPropertyValue2;
            String content = "<tr valign=\"top\">\n";
            if (!StringUtils.isEmpty((CharSequence)this.label)) {
                content = content + "<td nowrap bgcolor=" + BaseInformationBuilder.this.backgroundColorPropertyLabel + "align=\"right\" width=\"140\"><font face=\"Arial\" size=\"3\">" + this.label + ":&nbsp;</font></td>\n";
            }
            content = this.monospace ? content + "<td bgcolor=" + color + "align=\"left\"><font face=\"Monospaced\" size=\"3\">" + this.value.replace("\\n", "<br>\n") + "</font></td>" : content + "<td bgcolor=" + color + "align=\"left\"><font face=\"Arial\" size=\"3\">" + this.value.replace("\\n", "<br>\n") + "</font></td>";
            content = content + "</tr>\n";
            return content;
        }
    }

    protected class BaseTextElement
    implements InformationBuilder.TextElement {
        protected String value;

        protected BaseTextElement() {
        }

        public InformationBuilder.TextElement value(String format, Object ... args) {
            this.value = args == null ? StringEscapeUtils.escapeHtml3((String)format) : StringEscapeUtils.escapeHtml3((String)String.format(format, args));
            return this;
        }

        public String build() {
            String color = BaseInformationBuilder.this.propertyCount++ % 2 == 0 ? BaseInformationBuilder.this.backgroundColorPropertyValue1 : BaseInformationBuilder.this.backgroundColorPropertyValue2;
            String content = "<tr valign=\"top\">\n";
            content = content + "<td bgcolor=" + color + "align=\"left\" colspan=\"2\"><font face=\"Arial\" size=\"3\">" + this.value.replace("\n", "<br>\n") + "</font></td>\n";
            content = content + "</tr>\n";
            return content;
        }
    }

    protected class BaseRawElement
    implements InformationBuilder.RawElement {
        protected String value;

        protected BaseRawElement() {
        }

        public InformationBuilder.RawElement value(String format, Object ... args) {
            this.value = args == null ? format : String.format(format, args);
            return this;
        }

        public String build() {
            String color = BaseInformationBuilder.this.propertyCount++ % 2 == 0 ? BaseInformationBuilder.this.backgroundColorPropertyValue1 : BaseInformationBuilder.this.backgroundColorPropertyValue2;
            String content = "<tr valign=\"top\">\n";
            content = content + "<td bgcolor=" + color + "align=\"left\" colspan=\"2\"><font face=\"Arial\" size=\"3\"><div>" + this.value.replace("\\n", "<br>\n") + "</div></font></td>\n";
            content = content + "</tr>\n";
            return content;
        }
    }

    protected class BaseTitleElement
    implements InformationBuilder.TitleElement {
        protected String label;

        protected BaseTitleElement() {
        }

        public InformationBuilder.TitleElement value(String format, Object ... args) {
            this.label = args == null ? format : String.format(format, args);
            return this;
        }

        public InformationBuilder.TitleElement label(String label) {
            this.label = StringEscapeUtils.escapeHtml3((String)label);
            return this;
        }

        public InformationBuilder.TitleElement labelkey(String labelkey) {
            return this.label(ToolsLocator.getI18nManager().getTranslation(labelkey));
        }

        public String build() {
            BaseInformationBuilder.this.propertyCount = 0;
            return "<tr valign=\"middle\" ><td bgcolor=" + BaseInformationBuilder.this.backgroundColorTitle + " align=\"center\" colspan=\"2\"><font face=\"Arial\" size=\"3\"><b> " + this.label + "</b></font></td>" + "</tr>";
        }
    }
}

