/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.expressionevaluator.swing.impl.AbstractAutomaticExpressionChecker;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.impl.DefaultJExpressionBuilderView2;
import org.gvsig.expressionevaluator.swing.impl.FilteredListModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.ActionEventWithCurrentValue;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.script.ScriptSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJExpressionBuilder
implements JExpressionBuilder {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultJExpressionBuilder.class);
    private final ExpressionEvaluatorSwingManager manager;
    private Element currentElement;
    private PickerController<List<Script>> scriptPicker;
    private ScriptSwingManager.ScriptEditor scriptEditor;
    private final ExpressionBuilderConfig builderConfig;
    private ElementsTreeModel treeModel;
    private ImageIcon defaultIconGroup;
    private ImageIcon defaultIconElement;
    private InfoPanel infoPanel;
    private AbstractAutomaticExpressionChecker automaticExpressionChecker;
    private HistoryController<Expression> historyController;
    private BookmarksController<Expression> bookmarksController;
    final DefaultJExpressionBuilderView2 view;
    private boolean automaticExpressionCheckerEnabled = true;

    public DefaultJExpressionBuilder(ExpressionEvaluatorSwingManager manager, ExpressionBuilderConfig config, DefaultJExpressionBuilderView2 view) {
        this.manager = manager;
        this.builderConfig = config == null ? new DefaultExpressionBuilderConfig(manager) : config;
        this.view = view;
        this.initComponents();
    }

    private void initComponents() {
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        JComponent c = cfgActionsManager.getConfigurableActionsComponent("JExpressionBuilder", (Object)this);
        this.view.pnlCfgActions.setLayout(new BorderLayout(0, 0));
        this.view.pnlCfgActions.add((java.awt.Component)c, "After");
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingUtils.addWindowClosedListener((JComponent)this.view, e -> this.dispose());
        this.infoPanel = new InfoPanel(this.view.pnlDescription, this.load_description_from_resource());
        this.view.btnTip.setVisible(false);
        this.view.btnTip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(DefaultJExpressionBuilder.this.view.btnTip.getToolTipText(), "Tip", 1);
            }
        });
        this.defaultIconGroup = theme.get("expressionbuilder-element-group");
        this.defaultIconElement = theme.get("expressionbuilder-element");
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.view.txtGroupElement);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.view.txtSimpleElementFilter);
        toolsSwingManager.addClearButton((JTextComponent)this.view.txtSimpleElementFilter, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.view.txtSimpleElementFilter.setText("");
                DefaultJExpressionBuilder.this.doFilter();
            }
        });
        JMenuItem msgMenuTextEditor = new JMenuItem(i18n.getTranslation("text_editor"));
        msgMenuTextEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultJExpressionBuilder.this.automaticExpressionChecker != null) {
                    DefaultJExpressionBuilder.this.automaticExpressionChecker.showMessageDialog();
                }
            }
        });
        JMenuItem msgMenuCopy = new JMenuItem(i18n.getTranslation("copy"));
        msgMenuTextEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultJExpressionBuilder.this.automaticExpressionChecker != null) {
                    StringSelection selection = new StringSelection(DefaultJExpressionBuilder.this.automaticExpressionChecker.getMessage());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                }
            }
        });
        JPopupMenu msgMenu = new JPopupMenu();
        msgMenu.add(msgMenuTextEditor);
        msgMenu.addSeparator();
        msgMenu.add(msgMenuCopy);
        this.view.lblMsg.setComponentPopupMenu(msgMenu);
        this.view.pnlDescription.setLayout(new BorderLayout());
        this.view.getExpressionComponent().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                DefaultJExpressionBuilder.this.view.lblColumn.setText(Integer.toString(e.getDot()));
            }
        });
        this.view.treeElements.setRowHeight(0);
        this.view.treeElements.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public java.awt.Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel component;
                JLabel text = component = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                JLabel icon = component;
                if (value instanceof Element) {
                    Element element = (Element)value;
                    if (element.getIconName() == null) {
                        if (element instanceof Element.GroupElement) {
                            icon.setIcon(DefaultJExpressionBuilder.this.defaultIconGroup);
                        } else {
                            icon.setIcon(DefaultJExpressionBuilder.this.defaultIconElement);
                        }
                    } else {
                        icon.setIcon(element.getIcon());
                    }
                    text.setText(element.getLabel());
                    text.setEnabled(element.isEnabled());
                } else {
                    icon.setIcon(null);
                    text.setText(Objects.toString(value, ""));
                }
                icon.setDisabledIcon(icon.getIcon());
                return component;
            }
        });
        this.view.treeElements.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                Element element = (Element)path.getLastPathComponent();
                DefaultJExpressionBuilder.this.doSelectElement(element);
                DefaultJExpressionBuilder.this.updateSimpleElementsList(element);
            }
        });
        this.view.treeElements.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Element element;
                TreePath path;
                if (e.getButton() == 1 && e.getClickCount() == 2 && (path = DefaultJExpressionBuilder.this.view.treeElements.getSelectionPath()) != null && (element = (Element)path.getLastPathComponent()) instanceof Element.SimpleElement) {
                    DefaultJExpressionBuilder.this.doInsert((Element)((Element.SimpleElement)element));
                }
            }
        });
        this.view.btnGroupElementInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultJExpressionBuilder.this.currentElement != null) {
                    DefaultJExpressionBuilder.this.doInsert(DefaultJExpressionBuilder.this.currentElement.getRenderedValue());
                } else {
                    DefaultJExpressionBuilder.this.doInsert(DefaultJExpressionBuilder.this.view.txtGroupElement.getText());
                }
            }
        });
        this.view.btnSimpleElementInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Element element = (Element)DefaultJExpressionBuilder.this.view.lstSimpleElement.getSelectedValue();
                if (element != null) {
                    DefaultJExpressionBuilder.this.doInsert(element);
                }
            }
        });
        this.view.btnSimpleElementFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doFilter();
            }
        });
        this.view.lstSimpleElement.setModel(new FilteredListModel());
        this.view.lstSimpleElement.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public java.awt.Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Element) {
                    Element element = (Element)value;
                    if (element.getIconName() == null) {
                        if (element instanceof Element.GroupElement) {
                            label.setIcon(DefaultJExpressionBuilder.this.defaultIconGroup);
                        } else {
                            label.setIcon(DefaultJExpressionBuilder.this.defaultIconElement);
                        }
                    } else {
                        label.setIcon(element.getIcon());
                    }
                    label.setText(element.getLabel());
                    label.setEnabled(element.isEnabled());
                } else {
                    label.setIcon(null);
                    label.setText(Objects.toString(value, ""));
                }
                return label;
            }
        });
        this.view.lstSimpleElement.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Element element = (Element)DefaultJExpressionBuilder.this.view.lstSimpleElement.getSelectedValue();
                if (element != null) {
                    DefaultJExpressionBuilder.this.doSelectElement(element);
                }
            }
        });
        this.view.lstSimpleElement.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Element element;
                if (e.getButton() == 1 && e.getClickCount() == 2 && (element = (Element)DefaultJExpressionBuilder.this.view.lstSimpleElement.getSelectedValue()) != null) {
                    DefaultJExpressionBuilder.this.doSelectElement(element);
                    DefaultJExpressionBuilder.this.doInsert(element);
                }
            }
        });
        this.view.lstSimpleElement.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Element element;
                if (e.getKeyCode() == 10 && (element = (Element)DefaultJExpressionBuilder.this.view.lstSimpleElement.getSelectedValue()) != null) {
                    DefaultJExpressionBuilder.this.doSelectElement(element);
                    DefaultJExpressionBuilder.this.doInsert(element);
                }
            }
        });
        this.view.btnSimpleElementTimeLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doSetTimeLimit();
            }
        });
        this.view.btnSimpleElementSortDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredListModel model = (FilteredListModel)DefaultJExpressionBuilder.this.view.lstSimpleElement.getModel();
                model.sort(false);
            }
        });
        this.view.btnSimpleElementSortUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredListModel model = (FilteredListModel)DefaultJExpressionBuilder.this.view.lstSimpleElement.getModel();
                model.sort(true);
            }
        });
        this.view.txtSimpleElementFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DefaultJExpressionBuilder.this.doFilter();
                }
            }
        });
        this.view.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doInsert(" + ");
            }
        });
        this.view.btnDiv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doInsert(" / ");
            }
        });
        this.view.btnEq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doInsert(" = ");
            }
        });
        this.view.btnMult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doInsert(" * ");
            }
        });
        this.view.btnNeq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doInsert(" <> ");
            }
        });
        this.view.btnParentClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doInsert(" ) ");
            }
        });
        this.view.btnParentOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doInsert(" ( ");
            }
        });
        this.view.btnSubst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJExpressionBuilder.this.doInsert(" - ");
            }
        });
        ActionListener historyAndBookmarkListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEventWithCurrentValue ee = (ActionEventWithCurrentValue)e;
                switch (ee.getID()) {
                    case 1001: {
                        DefaultJExpressionBuilder.this.setExpression((Expression)ee.getCurrentValue());
                        break;
                    }
                    case 1002: {
                        ee.setCurrentValue((Object)DefaultJExpressionBuilder.this.getExpressionWithOutHistory());
                    }
                }
            }
        };
        this.historyController = toolsSwingManager.createHistoryController(this.builderConfig.getHistory(), this.view.btnHistory);
        this.historyController.addActionListener(historyAndBookmarkListener);
        this.bookmarksController = toolsSwingManager.createBookmarksController(this.builderConfig.getBookmarks(), this.view.btnBookmarks);
        this.bookmarksController.addActionListener(historyAndBookmarkListener);
        this.configUpdated();
        this.infoPanel.repaint();
        this.view.setPreferredSize(new Dimension(750, 450));
        Dimension dim = this.view.getPreferredSize();
        this.view.spnlExpression.setDividerLocation(dim.height / 5);
        this.view.spnlBottom.setDividerLocation(dim.width / 3);
        this.view.spnlItem.setDividerLocation(dim.width / 3);
    }

    private void message(String text) {
        String[] ss;
        if (StringUtils.isBlank((CharSequence)text)) {
            this.view.lblMsg.setText("");
            return;
        }
        String msg = text;
        String tail = "";
        if (StringUtils.contains((CharSequence)msg, (CharSequence)"\n") && (ss = StringUtils.split((String)msg, (String)"\n")).length > 1) {
            tail = String.format("(%d lines more)", ss.length);
            msg = ss[0];
        }
        this.view.lblMsg.setText(this.toHTML(StringUtils.abbreviate((String)msg, (int)70) + tail));
    }

    private String toHTML(String s) {
        s = StringUtils.replace((String)s, (String)"\n", (String)"\n<br>");
        s = StringUtils.replace((String)s, (String)"<html>", (String)"");
        s = StringUtils.replace((String)s, (String)"</html>", (String)"");
        s = "<html>" + s + "</html>";
        return s;
    }

    private String removeCursorMark(String s) {
        if (s == null) {
            return null;
        }
        s = s.replace("{{", "");
        s = s.replace("}}", "");
        return s;
    }

    public void insertText(String text) {
        this.doInsert(text);
    }

    public String getText() {
        return this.view.getExpressionComponent().getText();
    }

    public void setText(String text) {
        this.view.getExpressionComponent().setText(text);
    }

    private void doInsert(String s) {
        int start = s.indexOf("{{");
        int end = s.indexOf("}}");
        if (start > 0 && end > 0) {
            s = s.replace("{{", "");
            s = s.replace("}}", "");
        }
        JTextComponent jtext = this.view.getExpressionComponent();
        int selstart = this.view.getExpressionComponent().getSelectionStart();
        jtext.replaceSelection(s);
        if (start > 0 && end > 0) {
            jtext.setSelectionStart(selstart + start);
            jtext.setSelectionEnd(selstart + end - 2);
        }
        jtext.requestFocusInWindow();
    }

    private void doInsert(Element element) {
        this.doInsert(element.getRenderedValue());
        element.used();
    }

    private void doFilter() {
        FilteredListModel model = (FilteredListModel)this.view.lstSimpleElement.getModel();
        model.setFilter(this.view.txtSimpleElementFilter.getText());
    }

    private void doSelectElement(Element element) {
        this.infoPanel.setDescription(this.removeCursorMark(element.getDescription()));
        this.infoPanel.setAdditionalPanel(element.getAditionalPanel((JExpressionBuilder)this));
        this.infoPanel.repaint();
    }

    private void updateSimpleElementsList(Element element) {
        FilteredListModel model = new FilteredListModel();
        this.currentElement = element;
        this.view.txtSimpleElementFilter.setText("");
        if (element instanceof Element.SimpleElement) {
            this.view.btnGroupElementInsert.setEnabled(true);
        } else {
            this.view.btnGroupElementInsert.setEnabled(false);
        }
        this.view.lstSimpleElement.setEnabled(false);
        this.view.lstSimpleElement.setModel(model);
        if (element == null) {
            return;
        }
        model.addElement("Loading...");
        this.view.txtGroupElement.setText(element.getName());
        Thread th = new Thread(() -> this.simpleElementsUpdater(), "ExpressionBuilderSimpleElementsUpdater");
        th.start();
    }

    private void simpleElementsUpdater() {
        Element element = this.currentElement;
        FilteredListModel model = new FilteredListModel();
        for (Element value : element.getValues()) {
            if (element != this.currentElement) {
                return;
            }
            if (!(value instanceof Element.SimpleElement)) continue;
            model.addElement((LabeledValue)value);
        }
        model.sort(true);
        SwingUtilities.invokeLater(() -> {
            if (element != this.currentElement) {
                return;
            }
            if (element.hasMoreValues()) {
                this.view.lblSimpleElementsMsg.setText("More elements...");
            } else {
                this.view.lblSimpleElementsMsg.setText("");
            }
            this.view.lstSimpleElement.setEnabled(true);
            this.view.lstSimpleElement.setModel(model);
        });
    }

    public Expression getExpression() {
        Expression expression = this.getExpressionWithOutHistory();
        ExpressionEvaluatorManager theManager = ExpressionEvaluatorLocator.getManager();
        theManager.getHistory().add((Object)expression);
        return expression;
    }

    public Expression getExpressionWithOutHistory() {
        String phrase = this.view.getExpressionComponent().getText();
        if (StringUtils.isEmpty((CharSequence)phrase)) {
            return null;
        }
        Expression expression = ExpressionEvaluatorLocator.getManager().createExpression();
        expression.setPhrase(phrase);
        return expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            this.view.getExpressionComponent().setText("");
        } else {
            this.view.getExpressionComponent().setText(expression.getPhrase());
        }
    }

    public void setAutomaticExpressionCheckerEnabled(boolean enabled) {
        if (this.automaticExpressionChecker == null) {
            this.automaticExpressionCheckerEnabled = enabled;
        }
    }

    public boolean isAutomaticExpressionCheckerEnabled() {
        return this.automaticExpressionCheckerEnabled;
    }

    public JComponent asJComponent() {
        this.bookmarksController.setBookmarks(this.builderConfig.getBookmarks());
        this.historyController.setHistory(this.builderConfig.getHistory());
        if (this.automaticExpressionChecker == null && this.automaticExpressionCheckerEnabled) {
            this.automaticExpressionChecker = new AbstractAutomaticExpressionChecker(this.builderConfig, this.view.getExpressionComponent()){

                @Override
                protected Expression getExpression() {
                    return DefaultJExpressionBuilder.this.getExpressionWithOutHistory();
                }

                @Override
                protected void setMessage(int mode, String text) {
                    super.setMessage(mode, text);
                    DefaultJExpressionBuilder.this.message(text);
                }

                @Override
                protected void setPreview(Object value) {
                    super.setPreview(value);
                    DefaultJExpressionBuilder.this.message(this.getPreview());
                }

                @Override
                protected void setTip(String theTip) {
                    super.setTip(theTip);
                    DefaultJExpressionBuilder.this.view.btnTip.setToolTipText(this.toHTML(this.getTip()));
                    DefaultJExpressionBuilder.this.view.btnTip.setVisible(this.isTipEnabled());
                }

                @Override
                protected String getSuggestion() {
                    return DefaultJExpressionBuilder.this.builderConfig.getSuggestion(this.getExpression());
                }
            };
        }
        this.initializeTree();
        SwingUtilities.invokeLater(() -> this.view.getExpressionComponent().requestFocusInWindow());
        return this.view;
    }

    private void initializeTree() {
        if (this.treeModel == null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.treeModel = new ElementsTreeModel(this.manager.createGroupElement(i18n.getTranslation("_Elements"), this.getConfig().getElements()));
            this.view.treeElements.setModel(this.treeModel);
            for (int i = 0; i < this.view.treeElements.getRowCount(); ++i) {
                TreePath pathRow = this.view.treeElements.getPathForRow(i);
                Element element = (Element)pathRow.getLastPathComponent();
                if (!i18n.getTranslation("_Functions").equals(element.getName())) continue;
                this.view.treeElements.setSelectionPath(pathRow);
                this.doSelectElement(element);
                this.updateSimpleElementsList(element);
                break;
            }
        }
    }

    private void doSetTimeLimit() {
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        String s = dialogs.inputDialog("Indicate the time limit in seconds for calculating the elements", "Time limit", 3, String.valueOf(this.builderConfig.getPreferences().getSimpleElementsLimit()));
        if (StringUtils.isBlank((CharSequence)s)) {
            return;
        }
        try {
            int n = Integer.parseInt(s);
            this.builderConfig.getPreferences().setSimpleElementsLimit(n);
            this.treeModel.reload();
            this.updateSimpleElementsList(this.currentElement);
        }
        catch (Exception ex) {
            dialogs.messageDialog("Invalid time limit '" + s + "'.", "Time limit", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String load_description_from_resource() {
        String lang = Locale.getDefault().getLanguage();
        URL url = this.getClass().getResource("/org/gvsig/expressionevaluator/swing/jexpressionbuilder/" + lang + "/description.html");
        if (url == null && (url = this.getClass().getResource("/org/gvsig/expressionevaluator/swing/jexpressionbuilder/en/description.html")) == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = url.openStream();
            List lines = IOUtils.readLines((InputStream)is);
            String string = StringUtils.join((Iterable)lines, (String)"\n");
            return string;
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public void expandElement(Element element) {
        this.initializeTree();
        for (int i = 0; i < this.view.treeElements.getRowCount(); ++i) {
            TreePath path = this.view.treeElements.getPathForRow(i);
            if (path.getLastPathComponent() != element) continue;
            this.view.treeElements.expandPath(path);
            return;
        }
    }

    public void expandElement(Predicate<Element> condition) {
        if (condition == null) {
            return;
        }
        this.initializeTree();
        for (int i = 0; i < this.view.treeElements.getRowCount(); ++i) {
            TreePath path = this.view.treeElements.getPathForRow(i);
            if (!condition.test((Element)path.getLastPathComponent())) continue;
            this.view.treeElements.expandPath(path);
            return;
        }
    }

    private void dispose() {
        DisposeUtils.disposeQuietly((Disposable)this.treeModel);
        this.treeModel = null;
    }

    public ExpressionBuilderConfig getConfig() {
        return this.builderConfig;
    }

    public void configUpdated() {
        ExpressionBuilderConfig config = this.getConfig();
        Collection symbolTables = config.getSymbolTables();
        this.view.btnEq.setVisible(false);
        this.view.btnAdd.setVisible(false);
        this.view.btnDiv.setVisible(false);
        this.view.btnMult.setVisible(false);
        this.view.btnNeq.setVisible(false);
        this.view.btnSubst.setVisible(false);
        for (SymbolTable symbolTable : symbolTables) {
            if (symbolTable.function("=") != null) {
                this.view.btnEq.setVisible(true);
            }
            if (symbolTable.function("+") != null) {
                this.view.btnAdd.setVisible(true);
            }
            if (symbolTable.function("/") != null) {
                this.view.btnDiv.setVisible(true);
            }
            if (symbolTable.function("*") != null) {
                this.view.btnMult.setVisible(true);
            }
            if (symbolTable.function("<>") != null) {
                this.view.btnNeq.setVisible(true);
            }
            if (symbolTable.function("-") == null) continue;
            this.view.btnSubst.setVisible(true);
        }
    }

    private class ElementsTreeModel
    implements TreeModel,
    Disposable {
        private final Element.GroupElement root;
        private final HashSet<TreeModelListener> listeners;

        public ElementsTreeModel(Element.GroupElement root) {
            this.root = root;
            this.listeners = new HashSet();
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        public void reload() {
            this.root.reload();
            this.fireTreeChanged();
        }

        private List<Element> getChilds(Element.GroupElement node) {
            ArrayList<Element> x = new ArrayList<Element>();
            for (Element element : node.getElements()) {
                x.add(element);
            }
            return x;
        }

        @Override
        public Object getChild(Object parent, int index) {
            List<Element> childs = this.getChilds((Element.GroupElement)parent);
            Element child = childs.get(index);
            return child;
        }

        @Override
        public int getChildCount(Object parent) {
            List<Element> childs = this.getChilds((Element.GroupElement)parent);
            return childs.size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return !(node instanceof Element.GroupElement);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            List<Element> childs = this.getChilds((Element.GroupElement)parent);
            int n = childs.indexOf(child);
            return n;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        protected void fireTreeChanged() {
            for (TreeModelListener listener : this.listeners) {
                TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.root});
                listener.treeNodesChanged(e);
            }
        }

        public void dispose() {
            DisposeUtils.disposeQuietly((Disposable)this.root);
        }
    }

    private static class InfoPanel
    implements Component {
        private final JEditorPane txtDescription;
        private final JScrollPane scrDescription;
        private final JTabbedPane tab;
        private final String labelDescription;
        private final String labelAdditionalPanel;
        private final JPanel pnlContainer;
        private final String defautltDescription;
        private String description;
        private Component additionalPanel;

        public InfoPanel(JPanel pnlContainer, String defautltDescription) {
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.defautltDescription = defautltDescription;
            this.pnlContainer = pnlContainer;
            this.labelDescription = i18n.getTranslation("_Description");
            this.labelAdditionalPanel = i18n.getTranslation("_Assistant");
            this.txtDescription = new JEditorPane();
            this.scrDescription = new JScrollPane(this.txtDescription);
            this.tab = new JTabbedPane();
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtDescription);
            this.txtDescription.setPreferredSize(new Dimension(200, 200));
        }

        public void clean() {
            this.description = null;
            this.additionalPanel = null;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setAdditionalPanel(Component panel) {
            this.additionalPanel = panel;
        }

        public JComponent asJComponent() {
            this.txtDescription.setContentType("text/html");
            this.txtDescription.setText(this.description);
            this.txtDescription.setCaretPosition(0);
            if (StringUtils.isBlank((CharSequence)this.description)) {
                if (this.additionalPanel == null) {
                    this.txtDescription.setText(this.defautltDescription);
                    this.txtDescription.setCaretPosition(0);
                    return this.scrDescription;
                }
                return this.additionalPanel.asJComponent();
            }
            if (this.additionalPanel == null) {
                return this.scrDescription;
            }
            this.tab.removeAll();
            this.tab.add(this.labelDescription, this.scrDescription);
            this.tab.add(this.labelAdditionalPanel, this.additionalPanel.asJComponent());
            this.tab.setSelectedIndex(1);
            return this.tab;
        }

        public void repaint() {
            this.pnlContainer.removeAll();
            this.pnlContainer.add((java.awt.Component)this.asJComponent(), "Center");
            this.pnlContainer.revalidate();
            this.pnlContainer.repaint();
        }
    }
}

