/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl.elements;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.FunctionAdditionalPanelFactory;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;

public class DefaultFunctionElement
extends AbstractElement
implements Element.FunctionElement {
    private final Function function;

    public DefaultFunctionElement(Function function) {
        super(function.name(), (Object)function.name(), function.isSQLCompatible() ? "expressionbuilder-element-function-sql" : "expressionbuilder-element-function");
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public boolean isEnabled() {
        try {
            if (this.getConfig().getPreferences().isSQLCompatible()) {
                return this.function.isSQLCompatible();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Component getAditionalPanel(JExpressionBuilder expressionBuilder) {
        ExpressionEvaluatorSwingManager manager = ExpressionEvaluatorSwingLocator.getManager();
        FunctionAdditionalPanelFactory factory = manager.getFunctionAdditionalPanelFactory(this.function.name());
        if (factory == null) {
            return null;
        }
        return factory.createAdditionalPanel(expressionBuilder, new Object[0]);
    }

    public String getName() {
        return this.function.name();
    }

    public Object getValue() {
        return this.function.name();
    }

    private String escapeHTML(String text) {
        text = StringUtils.replace((String)text, (String)"\"", (String)"&quot");
        text = StringUtils.replace((String)text, (String)"&", (String)"&amp");
        text = StringUtils.replace((String)text, (String)"<", (String)"&lt");
        text = StringUtils.replace((String)text, (String)">", (String)"&gt");
        return text;
    }

    public String getLabel() {
        return "<html><b>" + this.escapeHTML(this.function.name()) + "</b> return " + this.function.returnType() + "</html>";
    }

    public String getRenderedValue() {
        return this.function.template() == null ? this.function.name() + "({{}})" : this.function.template();
    }

    public String getDescription() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        StringBuilder html = new StringBuilder();
        html.append("<html>\n");
        Function theFunction = this.getFunction();
        String functionDescription = theFunction.description();
        html.append("<b>").append(i18n.getTranslation("_Function")).append("</b> ").append(this.escapeHTML(this.getName())).append("<br>\n<br>\n");
        List aliases = theFunction.aliases();
        if (aliases != null && !aliases.isEmpty()) {
            html.append("<b>").append(i18n.getTranslation("_Aliases")).append(":</b> ").append("<ul>\n");
            for (String alias : aliases) {
                html.append("<li>").append(alias).append("</li>\n");
            }
            html.append("</ul>\n");
        }
        html.append("<b>").append(i18n.getTranslation("_Return")).append("</b> ");
        html.append(StringUtils.isEmpty((CharSequence)theFunction.returnType()) ? "Object" : theFunction.returnType());
        html.append("<br>\n");
        html.append("<b>").append(i18n.getTranslation("_Template")).append("</b> ");
        html.append(StringUtils.isEmpty((CharSequence)theFunction.template()) ? this.getName() + "()" : this.escapeHTML(theFunction.template()));
        html.append("<br>\n");
        String[] args = theFunction.descriptionArgs();
        if (args != null) {
            html.append("<b>").append(i18n.getTranslation("_Arguments")).append(":</b> ").append("<ul>\n");
            for (String arg : args) {
                html.append("<li>").append(arg).append("</li>\n");
            }
            html.append("</ul>\n");
            html.append("<br>\n");
        }
        if (!StringUtils.isBlank((CharSequence)functionDescription)) {
            html.append("<b>").append(i18n.getTranslation("_Description")).append("</b><br>\n");
            if (!StringUtils.containsAny((CharSequence)functionDescription, (CharSequence[])new CharSequence[]{"<br>", "<p>", "<br/>"})) {
                html.append(functionDescription.replace("\n", "<br>")).append("<br>\n");
            } else {
                html.append(functionDescription).append("<br>\n");
            }
        }
        html.append("</html>\n");
        return html.toString();
    }
}

