/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynObjectEditor
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 23898787077741411L;
    private static final Logger LOG = LoggerFactory.getLogger(DynObjectEditor.class);
    private String title;
    private JButton botAcept;
    private JButton botCancel;
    private JButton botRestoreDefaults;
    private JPanel panButtons;
    private I18nManager i18nManager = ToolsLocator.getI18nManager();
    private JDynForm form = null;
    private DynObject data = null;

    public DynObjectEditor(DynObject parameters, boolean showDefaultsButton) throws ServiceException {
        this.data = parameters;
        this.form = DynFormLocator.getDynFormManager().createJDynForm(this.data);
        this.form.setLayoutMode(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.form.asJComponent(), "Center");
        this.add((Component)this.getButtonsPanel(showDefaultsButton), "South");
        this.setPreferredSize(new Dimension(500, 250));
        String s = this.data.getDynClass().getDescription();
        if (s == null || s.length() == 0) {
            s = this.data.getDynClass().getName();
        }
        this.setTitle(s);
    }

    public DynObjectEditor(DynObject parameters) throws ServiceException {
        this(parameters, false);
    }

    private JPanel getButtonsPanel(boolean add_defaults_button) {
        if (this.panButtons == null) {
            this.panButtons = new JPanel();
            this.panButtons.setLayout(new GridBagLayout());
            GridBagConstraints constr = new GridBagConstraints();
            constr.anchor = 26;
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.weighty = 0.0;
            this.panButtons.add((Component)new JLabel(), constr);
            constr = this.getDefaultParametersConstraints();
            constr.fill = 0;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            this.panButtons.add((Component)this.getAcceptButton(), constr);
            this.panButtons.add((Component)this.getCancelButton(), constr);
            if (add_defaults_button) {
                this.panButtons.add((Component)this.getRestoreDefaults(), constr);
            }
        }
        return this.panButtons;
    }

    private GridBagConstraints getDefaultParametersConstraints() {
        GridBagConstraints constr = new GridBagConstraints();
        constr.insets = new Insets(2, 2, 2, 2);
        constr.ipadx = 2;
        constr.ipady = 2;
        constr.anchor = 19;
        return constr;
    }

    private JButton getRestoreDefaults() {
        if (this.botRestoreDefaults == null) {
            this.botRestoreDefaults = ToolsSwingLocator.getUsabilitySwingManager().createJButton(this.i18nManager.getTranslation("restoreDefaults"));
            this.botRestoreDefaults.addActionListener(this);
        }
        return this.botRestoreDefaults;
    }

    private JButton getCancelButton() {
        if (this.botCancel == null) {
            this.botCancel = ToolsSwingLocator.getUsabilitySwingManager().createJButton(this.i18nManager.getTranslation("cancel"));
            this.botCancel.addActionListener(this);
        }
        return this.botCancel;
    }

    private JButton getAcceptButton() {
        if (this.botAcept == null) {
            this.botAcept = ToolsSwingLocator.getUsabilitySwingManager().createJButton(this.i18nManager.getTranslation("accept"));
            this.botAcept.addActionListener(this);
        }
        return this.botAcept;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component source = (Component)e.getSource();
        if (source == this.botAcept) {
            this.form.getValues(this.data);
            this.closeWindow();
        } else if (source == this.botCancel) {
            this.closeWindow();
        } else if (source == this.botRestoreDefaults) {
            this.form.setValues(this.data);
        }
    }

    protected void closeWindow() {
        LOG.debug("Closing window, values edited: ", (Object)this.data);
        this.setVisible(false);
    }

    public void editObject(boolean modal) {
        WindowManager wmanager = ToolsSwingLocator.getWindowManager();
        wmanager.showWindow((JComponent)this, this.title, WindowManager.MODE.DIALOG);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DynObject getParameters() {
        this.form.getValues(this.data);
        return this.data;
    }
}

