/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;
import org.gvsig.tools.dataTypes.CoercionContextDecimal;
import org.gvsig.tools.dataTypes.CoercionContextLocaleImpl;

public class CoercionContextDecimalImpl
extends CoercionContextLocaleImpl
implements CoercionContextDecimal {
    final MathContext mathContext;
    final int scale;
    final int roundMode;

    public CoercionContextDecimalImpl(Locale locale, int precision, int scale, int roundMode) {
        super(locale == null ? Locale.ENGLISH : locale);
        this.mathContext = precision < 1 ? MathContext.UNLIMITED : new MathContext(precision, RoundingMode.valueOf(roundMode));
        this.scale = scale;
        this.roundMode = roundMode;
    }

    public CoercionContextDecimalImpl(Locale locale, int precision, int scale) {
        this(locale, precision, scale, 4);
    }

    public CoercionContextDecimalImpl(int precision, int scale) {
        this(null, precision, scale, 4);
    }

    public CoercionContextDecimalImpl(Locale locale) {
        this(locale, -1, -1, 4);
    }

    @Override
    public MathContext getMathContext() {
        return this.mathContext;
    }

    @Override
    public int precision() {
        return this.mathContext.getPrecision();
    }

    @Override
    public boolean hasPrecision() {
        return this.mathContext.getPrecision() > 0;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public boolean hasScale() {
        return this.scale >= 0;
    }

    @Override
    public int roundMode() {
        return this.roundMode;
    }

    @Override
    public String toString() {
        return "Decimal(" + this.precision() + "," + this.scale() + "," + this.locale.toString() + ")";
    }
}

