/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.extensionpoint.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.extensionpoint.ExtensionSingleton;
import org.gvsig.tools.extensionpoint.impl.DefaultExtensionPointManager;

public class DefaultExtensionPoint
implements ExtensionPoint {
    private String name;
    private String description;
    private Map alias;
    private LinkedHashMap extensions;
    private DefaultExtensionPointManager manager;

    DefaultExtensionPoint(ExtensionPointManager manager, String name) {
        this(manager, name, "");
    }

    DefaultExtensionPoint(ExtensionPointManager manager, String name, String description) {
        this.manager = (DefaultExtensionPointManager)manager;
        this.name = name;
        this.description = description;
        this.alias = new HashMap();
        this.extensions = new LinkedHashMap();
    }

    private ExtensionPoint.Extension append(Extension extension) {
        this.extensions.put(extension.getName(), extension);
        return extension;
    }

    @Override
    public ExtensionPoint.Extension append(String name, String description, ExtensionBuilder builder) {
        return this.append(new Extension(name, description, builder));
    }

    @Override
    public ExtensionPoint.Extension append(String name, String description, Class extension) {
        return this.append(new Extension(name, description, extension));
    }

    @Override
    public ExtensionPoint.Extension append(String name, String description, ExtensionSingleton extension) {
        return this.append(new Extension(name, description, extension));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private Extension insert(Extension extension) {
        LinkedHashMap<String, Extension> x = new LinkedHashMap<String, Extension>();
        x.put(extension.getName(), extension);
        x.putAll(this.extensions);
        this.extensions = x;
        return extension;
    }

    @Override
    public ExtensionPoint.Extension insert(String name, String description, Class extension) {
        return this.insert(new Extension(name, description, extension));
    }

    @Override
    public ExtensionPoint.Extension insert(String name, String description, ExtensionSingleton extension) {
        return this.insert(new Extension(name, description, extension));
    }

    @Override
    public ExtensionPoint.Extension insert(String name, String description, ExtensionBuilder builder) {
        return this.insert(new Extension(name, description, builder));
    }

    private ExtensionPoint.Extension insert(String beforeName, Extension extension) {
        if (this.extensions.containsKey(beforeName)) {
            LinkedHashMap<String, Extension> x = new LinkedHashMap<String, Extension>();
            for (Map.Entry e : this.extensions.entrySet()) {
                if (e.getKey().equals(beforeName)) {
                    x.put(extension.getName(), extension);
                }
                x.put((String)e.getKey(), (Extension)e.getValue());
            }
            this.extensions = x;
        } else {
            this.extensions.put(extension.getName(), extension);
        }
        return extension;
    }

    @Override
    public synchronized ExtensionPoint.Extension insert(String beforeName, String name, String description, Class extension) {
        return this.insert(beforeName, new Extension(name, description, extension));
    }

    @Override
    public synchronized ExtensionPoint.Extension insert(String beforeName, String name, String description, ExtensionSingleton extension) {
        return this.insert(beforeName, new Extension(name, description, extension));
    }

    @Override
    public synchronized ExtensionPoint.Extension insert(String beforeName, String name, String description, ExtensionBuilder builder) {
        return this.insert(beforeName, new Extension(name, description, builder));
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean addAlias(String name, String alias) {
        Extension extension = (Extension)this.extensions.get(name);
        if (extension == null) {
            return false;
        }
        this.alias.put(alias, extension);
        extension.alias.add(alias);
        return true;
    }

    @Override
    public Object create(String name) throws InstantiationException, IllegalAccessException {
        Extension extension = (Extension)this.alias.get(name);
        if (extension == null && (extension = (Extension)this.extensions.get(name)) == null) {
            return null;
        }
        return extension.create();
    }

    @Override
    public Object create(String name, Object[] args) throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Extension extension = (Extension)this.alias.get(name);
        if (extension == null && (extension = (Extension)this.extensions.get(name)) == null) {
            return null;
        }
        return extension.create(args);
    }

    @Override
    public Object create(String name, Map args) throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Extension extension = (Extension)this.alias.get(name);
        if (extension == null && (extension = (Extension)this.extensions.get(name)) == null) {
            return null;
        }
        return extension.create(args);
    }

    @Override
    public ExtensionPoint.Extension get(String name) {
        Extension extension = (Extension)this.alias.get(name);
        if (extension == null && (extension = (Extension)this.extensions.get(name)) == null) {
            return null;
        }
        return extension;
    }

    @Override
    public int getCount() {
        return this.extensions.size();
    }

    @Override
    public Iterator iterator() {
        return this.extensions.values().iterator();
    }

    @Override
    public List getNames() {
        Object[] names = this.extensions.keySet().toArray(new String[this.extensions.size()]);
        Arrays.sort(names);
        return Collections.unmodifiableList(Arrays.asList(names));
    }

    @Override
    public boolean has(String name) {
        return this.extensions.containsKey(name);
    }

    class Extension
    implements ExtensionPoint.Extension {
        private Class extension;
        private ExtensionBuilder builder;
        private ExtensionSingleton singleton;
        private String name;
        private String description;
        List alias = new ArrayList();

        Extension(String name, String description, Class extension) {
            this.name = name;
            this.description = description;
            this.builder = null;
            this.extension = extension;
            this.singleton = null;
        }

        Extension(String name, String description, ExtensionBuilder builder) {
            this.name = name;
            this.description = description;
            this.builder = builder;
            this.extension = null;
            this.singleton = null;
        }

        Extension(String name, String description, ExtensionSingleton singleton) {
            this.name = name;
            this.description = description;
            this.builder = null;
            this.extension = null;
            this.singleton = singleton;
        }

        @Override
        public List getAlias() {
            return Collections.unmodifiableList(this.alias);
        }

        @Override
        public ExtensionBuilder getBuilder() {
            return this.builder;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Class getExtension() {
            return this.extension;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isBuilder() {
            return this.builder != null;
        }

        @Override
        public boolean isSingleton() {
            return this.singleton != null;
        }

        @Override
        public Object create() throws InstantiationException, IllegalAccessException {
            if (this.isSingleton()) {
                return this.singleton;
            }
            if (this.isBuilder()) {
                return this.getBuilder().create();
            }
            return DefaultExtensionPoint.this.manager.create(this.getExtension());
        }

        @Override
        public Object create(Object[] args) throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            if (this.isSingleton()) {
                return this.singleton;
            }
            if (this.isBuilder()) {
                return this.getBuilder().create(args);
            }
            return DefaultExtensionPoint.this.manager.create(this.getExtension(), args);
        }

        @Override
        public Object create(Map args) throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            if (this.isSingleton()) {
                return this.singleton;
            }
            if (this.isBuilder()) {
                return this.getBuilder().create(args);
            }
            return DefaultExtensionPoint.this.manager.create(this.getExtension(), args);
        }
    }
}

