/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.paging;

import org.gvsig.tools.paging.PagingCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPagingCalculator
implements PagingCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPagingCalculator.class);
    private int maxPageSize;
    private long currentPage;
    private final PagingCalculator.Sizeable sizeable;

    public DefaultPagingCalculator(PagingCalculator.Sizeable sizeable) {
        this(sizeable, 100);
    }

    public DefaultPagingCalculator(PagingCalculator.Sizeable sizeable, int maxPageSize) {
        this(sizeable, maxPageSize, 0L);
    }

    public DefaultPagingCalculator(PagingCalculator.Sizeable sizeable, int maxPageSize, long currentPage) {
        this.sizeable = sizeable;
        this.maxPageSize = maxPageSize;
        this.currentPage = currentPage;
    }

    @Override
    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    @Override
    public void setMaxPageSize(int maxPageSize) {
        if (maxPageSize < 0) {
            throw new IndexOutOfBoundsException("Error, unable to set the max page size to a negative value: " + maxPageSize);
        }
        this.maxPageSize = maxPageSize;
    }

    @Override
    public long getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setCurrentPage(long currentPage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting current page to: {}", (Object)Long.toString(currentPage));
        }
        if (currentPage < 0L) {
            throw new IndexOutOfBoundsException("Error, unable to set current page to a negative value: " + currentPage);
        }
        if (currentPage >= this.getNumPages()) {
            throw new IndexOutOfBoundsException("Error, unable to set current page to the page num. " + currentPage + ", as we have only " + this.getNumPages() + " pages of data");
        }
        this.currentPage = currentPage;
    }

    @Override
    public long getInitialIndex() {
        return this.getCurrentPage() * (long)this.getMaxPageSize();
    }

    protected long getLastIndex() {
        return this.getInitialIndex() + (long)this.getCurrentPageSize() - 1L;
    }

    @Override
    public long getNumPages() {
        return (long)Math.floor(this.getTotalSize() / (long)this.getMaxPageSize()) + 1L;
    }

    @Override
    public int getCurrentPageSize() {
        long currentPage = this.getCurrentPage();
        if (currentPage < this.getNumPages() - 1L) {
            return this.getMaxPageSize();
        }
        return (int)(this.getTotalSize() - currentPage * (long)this.getMaxPageSize());
    }

    @Override
    public long getTotalSize() {
        return this.sizeable.getSize();
    }
}

