/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.mdiFrame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class DropDownButton
extends JToggleButton {
    private final List<Action> actions = new ArrayList<Action>();
    private Action currentAction = null;
    private final JToggleButton mainButton = new JToggleButton();
    private final JButton dropDownButton;
    private JPopupMenu dropDownMenu;
    private boolean showText = false;

    public DropDownButton() {
        this.mainButton.setOpaque(true);
        this.dropDownMenu = null;
        this.dropDownButton = new BasicArrowButton(5);
        this.dropDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DropDownButton.this.doToggleDropDownMenu();
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder());
        this.dropDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.mainButton.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainButton, "Center");
        this.add((Component)this.dropDownButton, "East");
        this.mainButton.setMargin(new Insets(0, 2, 0, 2));
        this.mainButton.setBackground(UIManager.getColor("Panel.background"));
        this.dropDownButton.setBackground(UIManager.getColor("Panel.background"));
        this.setBackground(UIManager.getColor("Panel.background"));
        this.mainButton.setFocusable(false);
        this.setFocusable(false);
        this.mainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (DropDownButton.this.currentAction != null) {
                    DropDownButton.this.currentAction.actionPerformed(ae);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    public void add(Action action) {
        this.actions.add(action);
        if (this.actions.size() == 1) {
            this.setMainButton(action);
        }
    }

    private void setMainButton(Action action) {
        this.mainButton.setIcon((Icon)action.getValue("SmallIcon"));
        if (this.showText) {
            this.mainButton.setText((String)action.getValue("ShortDescription"));
        } else {
            this.mainButton.setText("");
        }
        this.mainButton.setToolTipText((String)action.getValue("ShortDescription"));
        this.currentAction = action;
    }

    public void updateMainButton() {
        if (this.currentAction != null && this.currentAction.isEnabled()) {
            return;
        }
        for (Action action : this.actions) {
            if (!action.isEnabled()) continue;
            this.setMainButton(action);
            return;
        }
    }

    public boolean isAllHiden() {
        for (Action action : this.actions) {
            Boolean isVisible = (Boolean)action.getValue("VISIBLE");
            if (!BooleanUtils.isTrue((Boolean)isVisible)) continue;
            return false;
        }
        return true;
    }

    public boolean isAllDisabled() {
        this.mainButton.setEnabled(this.currentAction.isEnabled());
        for (Action action : this.actions) {
            if (!action.isEnabled()) continue;
            return false;
        }
        return true;
    }

    private void createDropDownMenu() {
        this.dropDownMenu = null;
        for (Action action : this.actions) {
            Boolean isVisible = (Boolean)action.getValue("VISIBLE");
            if (!BooleanUtils.isTrue((Boolean)isVisible)) continue;
            JMenuItem mi = new JMenuItem((String)action.getValue("ShortDescription"), (Icon)action.getValue("SmallIcon"));
            mi.setToolTipText((String)action.getValue("ShortDescription"));
            mi.addActionListener(new MyItemActionListener(action));
            mi.setEnabled(action.isEnabled());
            if (this.dropDownMenu == null) {
                this.dropDownMenu = new JPopupMenu();
                this.dropDownMenu.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent fe) {
                    }

                    @Override
                    public void focusLost(FocusEvent fe) {
                        if (DropDownButton.this.dropDownMenu != null) {
                            DropDownButton.this.dropDownMenu.setVisible(false);
                        }
                    }
                });
            }
            this.dropDownMenu.add(mi);
        }
    }

    void setSelected(String actionCommand, boolean b) {
        for (Action action : this.actions) {
            String s = (String)action.getValue("ActionCommandKey");
            if (!StringUtils.equals((CharSequence)s, (CharSequence)actionCommand)) continue;
            this.setMainButton(action);
            if (action.isEnabled()) {
                this.mainButton.setSelected(b);
                this.setSelected(b);
            }
            return;
        }
        this.mainButton.setSelected(false);
    }

    private void doToggleDropDownMenu() {
        if (this.dropDownMenu == null || !this.dropDownMenu.isVisible()) {
            this.createDropDownMenu();
            if (this.dropDownMenu != null) {
                this.dropDownMenu.show(this, 0, this.getHeight());
            }
        } else {
            this.dropDownMenu.setVisible(false);
        }
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
    }

    public boolean isShowText() {
        return this.showText;
    }

    private class MyItemActionListener
    implements ActionListener {
        private Action action = null;

        MyItemActionListener(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DropDownButton.this.mainButton.setIcon((Icon)this.action.getValue("SmallIcon"));
            if (DropDownButton.this.showText) {
                DropDownButton.this.mainButton.setText((String)this.action.getValue("ShortDescription"));
            } else {
                DropDownButton.this.mainButton.setText("");
            }
            DropDownButton.this.mainButton.setToolTipText((String)this.action.getValue("ShortDescription"));
            DropDownButton.this.currentAction = this.action;
            DropDownButton.this.dropDownMenu.setVisible(false);
            DropDownButton.this.mainButton.setEnabled(true);
            DropDownButton.this.setActionCommand((String)DropDownButton.this.currentAction.getValue("ActionCommandKey"));
            this.action.actionPerformed(ae);
        }
    }
}

