/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.execution;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.impl.DefaultInstallerManager;
import org.gvsig.installer.lib.impl.execution.InstallerProviderInstallers;
import org.gvsig.installer.lib.impl.execution.PackagesCache;
import org.gvsig.installer.lib.impl.utils.Download;
import org.gvsig.installer.lib.spi.InstallPackageProviderServices;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.installer.lib.spi.execution.InstallPackageProvider;
import org.gvsig.tools.service.Manager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInstallPackageService
extends Thread
implements InstallPackageService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInstallPackageService.class);
    private static final String PACKAGE_FILE_NAME = "packages.gvspki";
    private PackagesCache packagesCache = null;
    private InstallerManager manager;
    private InstallPackageProviderServices installerProviderServices = null;

    public DefaultInstallPackageService(DefaultInstallerManager manager) {
        this.manager = manager;
        this.reset();
    }

    public void reset() {
        this.installerProviderServices = InstallerProviderLocator.getProviderManager().createInstallerProviderServices();
        this.packagesCache = new PackagesCache(this.installerProviderServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPackage(File applicationDirectory, PackageInfo packageInfo) throws InstallPackageServiceException {
        if (!applicationDirectory.exists()) {
            LOG.warn("Can install package '" + packageInfo.getCode() + "', application folder '" + applicationDirectory.toString() + "' does not exits.");
            throw new InstallerApplicationDirectoryNotFoundException(applicationDirectory);
        }
        if (!this.packagesCache.contains(packageInfo)) {
            LOG.warn("Can install package '" + packageInfo.getCode() + "', package not found.");
            throw new InstallerPackageNotFoundException();
        }
        InstallPackageProvider installerExecutionProvider = this.createProvider(packageInfo);
        File file = this.packagesCache.getFile(packageInfo);
        try {
            InputStream packageStream = this.packagesCache.getInputStream(packageInfo);
            try {
                installerExecutionProvider.install(applicationDirectory, packageStream, packageInfo);
            }
            catch (InstallPackageServiceException e) {
                IOUtils.closeQuietly((InputStream)packageStream);
                packageStream = this.packagesCache.getInputStream(packageInfo);
                installerExecutionProvider.installLater(applicationDirectory, packageStream, packageInfo);
            }
            finally {
                IOUtils.closeQuietly((InputStream)packageStream);
            }
        }
        catch (FileNotFoundException e) {
            throw new InstallerFileNotFoundException(file);
        }
        catch (IOException e) {
            throw new InstallerIOException(file, e);
        }
    }

    public void installPackage(File applicationDirectory, String packageCode) throws InstallPackageServiceException {
        PackageInfo packageInfo = this.getPackageInfo(packageCode);
        if (packageInfo == null) {
            throw new InstallerNoPackageException();
        }
        this.installPackage(applicationDirectory, packageInfo);
    }

    private InstallPackageProvider createProvider(PackageInfo packageInfo) throws InstallPackageServiceException {
        InstallerProviderManager installerProviderManager = (InstallerProviderManager)((DefaultInstallerManager)this.manager).getProviderManager();
        try {
            return installerProviderManager.createExecutionProvider(packageInfo.getType());
        }
        catch (ServiceException e) {
            throw new InstallerProviderCreationException(e);
        }
    }

    public PackageInfo getPackageInfo(int index) {
        if (index >= this.packagesCache.size()) {
            return null;
        }
        return this.packagesCache.get(index);
    }

    public PackageInfo getPackageInfo(String packageCode) {
        for (PackageInfo packageInfo : this.packagesCache) {
            if (!packageInfo.getCode().equals(packageCode)) continue;
            return packageInfo;
        }
        return null;
    }

    public void addBundle(File bundle, SimpleTaskStatus taskStatus) throws InstallPackageServiceException {
        HashMap zipEntriesNames = new HashMap();
        ArrayList packages = new ArrayList();
        if (!bundle.exists()) {
            throw new InstallPackageServiceException();
        }
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(bundle);
            bis = new BufferedInputStream(fis);
            this.installerProviderServices.readPackageInfo((InputStream)bis, packages, zipEntriesNames, bundle.getName(), taskStatus);
        }
        catch (FileNotFoundException e) {
            try {
                throw new InstallerBundleNotFoundException(bundle, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly((InputStream)fis);
                bis = null;
                fis = null;
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)fis);
        bis = null;
        fis = null;
        if (packages.size() == 1) {
            PackageInfo pkg = (PackageInfo)packages.get(0);
            String entryName = (String)zipEntriesNames.get(pkg);
            if (entryName.endsWith("." + this.manager.getDefaultPackageFileExtension())) {
                this.packagesCache.addPackage(pkg, bundle);
                return;
            }
            if (entryName.endsWith("." + this.manager.getDefaultIndexSetFileExtension())) {
                this.packagesCache.addPackageIndex(pkg);
            } else {
                throw new IllegalArgumentException("Can't recognize the file '" + bundle.getAbsolutePath() + "'.");
            }
        }
        packages.clear();
        zipEntriesNames.clear();
        try {
            fis = new FileInputStream(bundle);
            bis = new BufferedInputStream(fis);
            this.installerProviderServices.readPackageSetInfo((InputStream)bis, packages, zipEntriesNames, taskStatus);
        }
        catch (FileNotFoundException e) {
            throw new InstallerBundleNotFoundException(bundle, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((InputStream)fis);
            bis = null;
            fis = null;
        }
        for (PackageInfo pkg : packages) {
            String entryName = (String)zipEntriesNames.get(pkg);
            if (entryName.endsWith("." + this.manager.getDefaultPackageFileExtension())) {
                this.packagesCache.addBundledPackage(pkg, bundle, entryName);
                continue;
            }
            if (entryName.endsWith("." + this.manager.getDefaultIndexSetFileExtension())) {
                this.packagesCache.addBundledPackageIndex(pkg, bundle, entryName);
                continue;
            }
            throw new IllegalArgumentException("Can't recognize the file '" + bundle.getAbsolutePath() + "'.");
        }
    }

    public void addBundle(URL bundleURL, SimpleTaskStatus taskStatus) throws InstallPackageServiceException {
        String urlString = bundleURL.toString();
        if (urlString.endsWith(".gvspkg") || urlString.endsWith(".gvspki")) {
            this.manager.setDownloadBaseURL(bundleURL);
            File bundle = this.downloadFile(bundleURL, PACKAGE_FILE_NAME);
            this.addBundle(bundle, taskStatus);
        } else {
            URL completeURL;
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            Version version = this.manager.getVersionEx();
            urlString = urlString + "dists/" + version.getMayor() + "." + version.getMinor() + "." + version.getRevision() + "/" + PACKAGE_FILE_NAME;
            try {
                completeURL = new URL(urlString);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
            this.manager.setDownloadBaseURL(completeURL);
            File bundle = this.downloadFile(completeURL, PACKAGE_FILE_NAME);
            this.addBundle(bundle, taskStatus);
        }
    }

    private File downloadFile(URL bundleURL, String defaultFileName) throws InstallPackageServiceException {
        try {
            Download download = new Download();
            return download.downloadFile(bundleURL, defaultFileName);
        }
        catch (IOException e) {
            throw new InstallerFileDownloadException(bundleURL, e);
        }
    }

    public void addBundlesFromDirectory(File directory, SimpleTaskStatus taskStatus) throws InstallPackageServiceException {
        if (!directory.isDirectory()) {
            throw new InstallerNoDirectoryException(directory);
        }
        Collection files = FileUtils.listFiles((File)directory, (String[])new String[]{this.manager.getDefaultPackageFileExtension(), this.manager.getDefaultPackageSetFileExtension(), this.manager.getDefaultIndexSetFileExtension()}, (boolean)true);
        for (File file : files) {
            this.addBundle(file, taskStatus);
        }
    }

    public int getPackageCount() {
        if (this.packagesCache == null) {
            return 0;
        }
        return this.packagesCache.size();
    }

    public Manager getManager() {
        return this.manager;
    }

    public void downloadPackage(PackageInfo packageInfo) throws InstallPackageServiceException {
        this.downloadPackage(packageInfo, null);
    }

    public void downloadPackage(PackageInfo packageInfo, SimpleTaskStatus taskStatus) throws InstallPackageServiceException {
        this.packagesCache.download(packageInfo, taskStatus);
    }

    public List<String> getDefaultSelectedPackagesIDs() {
        return this.installerProviderServices.getDefaultSelectedPackagesIDs();
    }

    public Properties getProperties() {
        return this.installerProviderServices.getProperties();
    }

    public List<String> getCategories() {
        HashSet categories = new HashSet();
        for (PackageInfo pkginfo : this.packagesCache) {
            List pkgcategories = pkginfo.getCategories();
            categories.addAll(pkgcategories);
        }
        try {
            PackageInfo[] pkgs;
            for (PackageInfo pkginfo : pkgs = this.manager.getInstalledPackages()) {
                List pkgcategories = pkginfo.getCategories();
                categories.addAll(pkgcategories);
            }
        }
        catch (MakePluginPackageServiceException pkgs) {
            // empty catch block
        }
        ArrayList<String> l = new ArrayList<String>(categories);
        Collections.sort(l);
        return l;
    }

    public List<String> getTypes() {
        HashSet<String> types = new HashSet<String>();
        for (PackageInfo pkginfo : this.packagesCache) {
            types.add(pkginfo.getType());
        }
        try {
            PackageInfo[] pkgs;
            for (PackageInfo pkginfo : pkgs = this.manager.getInstalledPackages()) {
                types.add(pkginfo.getType());
            }
        }
        catch (MakePluginPackageServiceException pkgs) {
            // empty catch block
        }
        ArrayList<String> l = new ArrayList<String>(types);
        Collections.sort(l);
        return l;
    }

    public boolean needInstallPackageProviders() {
        boolean need = false;
        String ss = this.getProperties().getProperty("installers");
        if (ss != null) {
            String[] installerNames;
            for (String installerName : installerNames = StringUtils.split((String)ss)) {
                InstallerProviderInstallers installer = new InstallerProviderInstallers(this, installerName);
                if (installer.isAlreadyRegistered()) continue;
                need = true;
                break;
            }
        }
        return need;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPackageProviders(SimpleTaskStatus taskStatus) {
        Properties props = this.getProperties();
        String ss = props.getProperty("installers");
        if (ss == null) {
            return;
        }
        try {
            String[] installerNames = StringUtils.split((String)ss);
            taskStatus.setRangeOfValues(0L, (long)installerNames.length);
            int count = 0;
            for (String installerName : installerNames) {
                taskStatus.message(installerName);
                taskStatus.setCurValue((long)count++);
                InstallerProviderInstallers installer = new InstallerProviderInstallers(this, installerName);
                installer.install();
            }
            taskStatus.setCurValue((long)count++);
        }
        finally {
            taskStatus.terminate();
        }
    }

    public class InstallerProviderCreationException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = -7985786807492393584L;
        private static final String message = "Error creating the provider";
        private static final String KEY = "_Error_creating_the_provider";

        public InstallerProviderCreationException(ServiceException e) {
            super(message, (Throwable)e, KEY, -7985786807492393584L);
        }
    }

    public class InstallerNoPackageException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = -2292735515704746966L;
        private static final String message = "Package does not exist";
        private static final String KEY = "_package__does_not_exist";

        public InstallerNoPackageException() {
            super(message, KEY, -2292735515704746966L);
        }
    }

    public class InstallerPackageNotFoundException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 1726608498886963868L;
        private static final String message = "Package not found";
        private static final String KEY = "_package_not_found";

        public InstallerPackageNotFoundException() {
            super(message, KEY, 1726608498886963868L);
        }
    }

    public class InstallerFileDownloadException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 8640183295766490512L;
        private static final String message = "File '%(url)' download error";
        private static final String KEY = "_File_XurlX_download_error";

        public InstallerFileDownloadException(URL url, IOException e) {
            super(message, (Throwable)e, KEY, 8640183295766490512L);
            this.setValue("url", url.toString());
        }
    }

    public class InstallerIOException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 3153613550157712363L;
        private static final String message = "IO error installing the file '%(file)s'";
        private static final String KEY = "_IO_error installing_file_XfileX_";

        public InstallerIOException(File file, IOException e) {
            super(message, (Throwable)e, KEY, 3153613550157712363L);
            this.setValue("file", file.toString());
        }
    }

    public class InstallerBundleNotFoundException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 5065410511582625301L;
        private static final String message = "File '%(file)s' not found";
        private static final String KEY = "_file_XfileX_not_found";

        public InstallerBundleNotFoundException(File file, FileNotFoundException e) {
            super(message, (Throwable)e, KEY, 5065410511582625301L);
            this.setValue("file", file.toString());
        }
    }

    public class InstallerFileNotFoundException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 556517830330132149L;
        private static final String message = "File '%(file)s' not found";
        private static final String KEY = "_file_XfileX_not_found";

        public InstallerFileNotFoundException(File file) {
            super(message, KEY, 556517830330132149L);
            this.setValue("file", file.toString());
        }
    }

    public class InstallerNoDirectoryException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = -8685263049644983769L;
        private static final String message = "'%(directory)s' is not a directory";
        private static final String KEY = "_XdirectoryX_is_not_a_directory";

        public InstallerNoDirectoryException(File file) {
            super(message, KEY, -8685263049644983769L);
            this.setValue("directory", file.toString());
        }
    }

    public class InstallerApplicationDirectoryNotFoundException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = -1130408094135962456L;
        private static final String message = "Aplication directory '%(directory)s' not found";
        private static final String KEY = "_aplication_directory_XdirectoryX_not_found";

        public InstallerApplicationDirectoryNotFoundException(File file) {
            super(message, KEY, -1130408094135962456L);
            this.setValue("directory", file.toString());
        }
    }
}

