/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.execution;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.service.spi.NotRegisteredException;
import org.gvsig.tools.service.spi.ParametersException;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallerProviderInstallers {
    private static final Logger LOG = LoggerFactory.getLogger(InstallerProviderInstallers.class);
    private final InstallPackageService bundle;
    private final String installerName;
    private String packageCode;
    private String factoryName;
    private String initializerClassName;
    private String libs;
    private PackageInfo packageInfo = null;

    public InstallerProviderInstallers(InstallPackageService bundle, String installerName) {
        this.bundle = bundle;
        this.installerName = installerName;
        this.init();
    }

    private void init() {
        Properties props = this.bundle.getProperties();
        String s = "installer." + this.installerName;
        this.setInitializerClassName(props.getProperty(s + ".initializer"));
        this.setPackageCode(props.getProperty(s + ".package.code"));
        this.setFactoryName(props.getProperty(s + ".factory.name"));
        this.setLibs(props.getProperty(s + ".libs", "lib"));
    }

    public InstallPackageService getBundle() {
        return this.bundle;
    }

    public String getPackageCode() {
        return this.packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    public String getInitializerClassName() {
        return this.initializerClassName;
    }

    public void setInitializerClassName(String initializerClassName) {
        this.initializerClassName = initializerClassName;
    }

    public String getLibs() {
        return this.libs;
    }

    public void setLibs(String libs) {
        this.libs = libs;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    private ClassLoader createClassLoader(File installFolder) {
        File folder = FileUtils.getFile((File)installFolder, (String[])new String[]{this.packageCode, this.libs});
        File[] jars = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        URL[] urls = new URL[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            File f = jars[i];
            try {
                urls[i] = f.toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                LOG.warn("Can't add jar '" + f.getAbsolutePath() + "' to class loader.", (Throwable)ex);
            }
        }
        URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
        return loader;
    }

    private Object newInstance(ClassLoader loader, String className) {
        try {
            Class<?> theClass = loader.loadClass(className);
            Object instance = theClass.newInstance();
            return instance;
        }
        catch (Exception ex) {
            LOG.warn("Can't create class '" + className + "'.", (Throwable)ex);
            return null;
        }
    }

    private PackageInfo getPackageInfo() {
        if (this.packageInfo == null) {
            this.packageInfo = this.bundle.getPackageInfo(this.packageCode);
        }
        return this.packageInfo;
    }

    public boolean isAlreadyRegistered() {
        try {
            InstallerProviderManager providerManager = InstallerProviderLocator.getProviderManager();
            providerManager.getProviderFactory(this.factoryName);
            return true;
        }
        catch (NotRegisteredException ex) {
            return false;
        }
        catch (ParametersException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void install() {
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        PackageInfo pkg = this.getPackageInfo();
        if (pkg == null) {
            LOG.warn("Can't install package '" + this.packageCode + "', can't get package from bundle.");
            return;
        }
        File installFolder = installerManager.getDefaultLocalAddonRepository(pkg.getType(), 1);
        try {
            File f = FileUtils.getFile((File)installFolder, (String[])new String[]{this.packageCode});
            if (!f.exists()) {
                this.bundle.installPackage(installFolder, this.packageCode);
            }
            if (!this.isAlreadyRegistered()) {
                ClassLoader loader = this.createClassLoader(installFolder);
                new DefaultLibrariesInitializer(loader).fullInitialize(true);
                Invocable initializer = (Invocable)this.newInstance(loader, this.initializerClassName);
                if (initializer == null) {
                    return;
                }
                initializer.call(new Object[]{this.packageCode});
            }
        }
        catch (Exception ex) {
            LOG.warn("Can't install package '" + this.packageCode + "' in the folder '" + installFolder == null ? "unknown" : installFolder.getAbsolutePath() + "'.", (Throwable)ex);
        }
    }

    class MyClassLoader
    extends URLClassLoader {
        public MyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            LOG.info("findClass('" + name + "').");
            return super.findClass(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            LOG.info("loadClass('" + name + "').");
            return super.loadClass(name);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            LOG.info("loadClass('" + name + "'," + resolve + ").");
            return super.loadClass(name, resolve);
        }
    }
}

