/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;

public class Compress {
    public void compressPluginAsPackageSet(File file, String fileName, OutputStream os) throws MakePluginPackageServiceException {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> fileNames = new ArrayList<String>();
        files.add(file);
        fileNames.add(fileName);
        this.compressPluginsAsPackageSet(files, fileNames, os);
    }

    public void compressPluginsAsPackageSet(File directory, OutputStream os) throws MakePluginPackageServiceException {
        File[] files = directory.listFiles();
        ArrayList<File> filesArray = new ArrayList<File>();
        ArrayList<String> fileNamesArray = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            filesArray.add(files[i]);
            fileNamesArray.add(files[i].getName());
        }
        this.compressPluginsAsPackageSet(filesArray, fileNamesArray, os);
    }

    public void compressPluginsAsPackageSet(List<File> files, List<String> fileNames, OutputStream os) throws MakePluginPackageServiceException {
        try {
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(os));
            for (int i = 0; i < files.size(); ++i) {
                ZipEntry zipEntry = new ZipEntry(fileNames.get(i));
                zos.putNextEntry(zipEntry);
                this.compressPluginFiles(files.get(i), zos);
                zos.closeEntry();
            }
            zos.close();
        }
        catch (Exception e) {
            throw new MakePluginPackageServiceException("Error compressing as package set the plugin files: " + files, (Throwable)e);
        }
    }

    public void compressPluginAsPackage(File folder, OutputStream os) throws MakePluginPackageServiceException {
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            int parentFileLenght = folder.getParentFile().toString().length();
            this.compressPluginFile(folder, parentFileLenght, zos);
            zos.flush();
            zos.close();
        }
        catch (IOException e) {
            throw new MakePluginPackageServiceException("Error compressing as package the plugin folder: " + folder, (Throwable)e);
        }
    }

    public void compressPluginAsPackageIndex(File folder, OutputStream os) throws MakePluginPackageServiceException {
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            int len;
            int parentFileLength = folder.getParentFile().toString().length();
            String folderName = folder.toString().substring(parentFileLength + 1, folder.toString().length());
            File infoFile = new File(folder, this.getPackageInfoFileName() + ".index");
            if (!infoFile.exists()) {
                infoFile = new File(folder, this.getPackageInfoFileName());
            }
            byte[] buf = new byte[1024];
            ZipEntry zipEntry = new ZipEntry(folderName + "/" + this.getPackageInfoFileName());
            zos.putNextEntry(zipEntry);
            FileInputStream fin = new FileInputStream(infoFile);
            BufferedInputStream in = new BufferedInputStream(fin);
            while ((len = in.read(buf)) >= 0) {
                zos.write(buf, 0, len);
            }
            in.close();
            zos.closeEntry();
            zos.flush();
            zos.close();
        }
        catch (IOException e) {
            throw new MakePluginPackageServiceException("Error compressing as package index the plugin folder: " + folder, (Throwable)e);
        }
    }

    private void compressPluginFiles(File fileOrFolder, ZipOutputStream zos) throws IOException {
        int parentFileLenght = fileOrFolder.getParentFile().toString().length();
        ZipOutputStream zosPlugin = new ZipOutputStream(zos);
        this.compressPluginFile(fileOrFolder, parentFileLenght, zosPlugin);
        zosPlugin.finish();
    }

    private void compressPluginFile(File file, int parenFileLength, ZipOutputStream zosPlugin) throws IOException {
        String fileName = file.toString().substring(parenFileLength, file.toString().length());
        if (File.separatorChar != '/') {
            fileName = fileName.replace(File.separatorChar, '/');
        }
        if (file.isDirectory()) {
            String[] fileNames;
            if (!file.getName().toUpperCase().equals(".SVN") && (fileNames = file.list()) != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    this.compressPluginFile(new File(file, fileNames[i]), parenFileLength, zosPlugin);
                }
            }
        } else {
            int len;
            byte[] buf = new byte[1024];
            ZipEntry zipEntry = new ZipEntry(fileName);
            zosPlugin.putNextEntry(zipEntry);
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(fin);
            while ((len = in.read(buf)) >= 0) {
                zosPlugin.write(buf, 0, len);
            }
            in.close();
            zosPlugin.closeEntry();
        }
    }

    private String getPackageInfoFileName() {
        return InstallerProviderLocator.getProviderManager().getPackageInfoFileName();
    }
}

