/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionSyntaxException;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.CalculatorController;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.impl.Utils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCalculatorController<T>
implements CalculatorController<T>,
ChangeListenerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCalculatorController.class);
    private static final Color COLOR_ERROR = new Color(255, 225, 232);
    private final JTextComponent text;
    private final int dataType;
    private final MutableSymbolTable defaultSymbolTable;
    private final Color color_ok;
    private final DefaultExpressionEvaluatorSwingManager swingManager;
    private DefaultExpressionBuilderConfig config;
    private Expression expression;
    private boolean warning;
    private final ChangeListenerHelper changeListenerHelper;
    private final Timer fireChangeTimer;
    private String lastText;
    private final ExpressionEvaluatorManager manager;

    public DefaultCalculatorController(DefaultExpressionEvaluatorSwingManager manager, JTextComponent text, int dataType) {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.swingManager = manager;
        this.manager = ExpressionEvaluatorLocator.getManager();
        this.config = null;
        this.expression = null;
        this.warning = false;
        this.changeListenerHelper = toolsSwingManager.createChangeListenerHelper();
        this.text = text;
        this.dataType = dataType;
        this.color_ok = this.text.getBackground();
        this.defaultSymbolTable = ExpressionEvaluatorLocator.getManager().createSymbolTable();
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 82 && e.isControlDown()) {
                    DefaultCalculatorController.this.doCalculate(true);
                }
            }
        });
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DefaultCalculatorController.this.fireChangeEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DefaultCalculatorController.this.fireChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DefaultCalculatorController.this.fireChangeEvent();
            }
        });
        this.text.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                DefaultCalculatorController.this.doCalculate(true);
            }

            @Override
            public void focusGained(FocusEvent e) {
                DefaultCalculatorController.this.doCalculate(true);
            }
        });
        toolsSwingManager.addClearButton(this.text, e -> this.set(null));
        toolsSwingManager.setDefaultPopupMenu(this.text);
        JPopupMenu popupMenu = this.text.getComponentPopupMenu();
        AbstractAction showExpressionBuilderAction = new AbstractAction(i18n.getTranslation("_Show_expression_builder")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCalculatorController.this.doShowExpressionBuilder();
            }
        };
        popupMenu.addSeparator();
        popupMenu.add(showExpressionBuilderAction);
        this.fireChangeTimer = new Timer(100, e -> this.fireEvent());
    }

    private void fireChangeEvent() {
        this.fireChangeTimer.setRepeats(false);
        this.fireChangeTimer.restart();
    }

    private void doShowExpressionBuilder() {
        if (this.config == null) {
            this.config = new DefaultExpressionBuilderConfig(this.swingManager);
            this.config.addSymbolTable((SymbolTable)this.defaultSymbolTable);
        }
        if (this.expression == null) {
            this.expression = ExpressionEvaluatorLocator.getManager().createExpression();
        }
        this.expression.setPhrase(this.text.getText());
        JExpressionBuilder panel = this.swingManager.createJExpressionBuilder(this.config);
        panel.setExpression(this.expression);
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = windowManager.createDialog(panel.asJComponent(), "Expression builder", null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() == 1) {
            this.text.setText(panel.getExpression().getPhrase());
        }
    }

    public void addSymbolTable(SymbolTable symbolTable) {
        this.defaultSymbolTable.addSymbolTable(symbolTable);
    }

    public MutableSymbolTable getSymbolTable() {
        return this.defaultSymbolTable;
    }

    private Object doCalculate(boolean updateText) {
        if (!this.text.isEditable() || !this.text.isEnabled() && StringUtils.isBlank((CharSequence)this.text.getText())) {
            return null;
        }
        String source = this.text.getText();
        try {
            if (!StringUtils.isBlank((CharSequence)source)) {
                String s;
                Object value = this.manager.evaluate((SymbolTable)this.defaultSymbolTable, source);
                if (updateText && !StringUtils.equals((CharSequence)(s = Utils.repr(value)), (CharSequence)this.lastText)) {
                    this.setWarning(false);
                    this.lastText = s;
                    this.text.setText(this.lastText);
                }
                return value;
            }
            this.setWarning(false);
        }
        catch (ExpressionSyntaxException ex) {
            this.setWarning(true, ex.getDescription());
        }
        catch (Exception ex) {
            this.setWarning(true);
        }
        return null;
    }

    public void setWarning(boolean warning) {
        this.setWarning(warning, null);
    }

    public void setWarning(boolean warning, String description) {
        this.warning = warning;
        if (warning) {
            this.text.setBackground(COLOR_ERROR);
            this.text.setToolTipText(description == null ? "" : description);
        } else {
            this.text.setBackground(this.color_ok);
            this.text.setToolTipText("");
        }
    }

    public boolean getWarning() {
        return this.warning;
    }

    public T get(T defaultValue) {
        T v = this.get();
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public String getText() {
        return this.text.getText();
    }

    public T get() {
        Object value = !this.text.isEditable() || !this.text.isEnabled() ? this.text.getText() : this.doCalculate(false);
        try {
            DataTypesManager dataManager = ToolsLocator.getDataTypesManager();
            value = dataManager.coerce(this.dataType, value);
            return (T)value;
        }
        catch (CoercionException ex) {
            return null;
        }
    }

    public void set(T value) {
        this.text.setText(Objects.toString(value, ""));
        this.text.setBackground(this.color_ok);
    }

    public void coerceAndSet(Object value) {
        if (this.dataType != 64) {
            DataTypesManager dataManager = ToolsLocator.getDataTypesManager();
            try {
                value = dataManager.coerce(this.dataType, value);
            }
            catch (CoercionException coercionException) {
                // empty catch block
            }
        }
        this.text.setText(Objects.toString(value, ""));
        this.text.setBackground(this.color_ok);
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.text.isEnabled();
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListenerHelper.addChangeListener(cl);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    public void fireEvent() {
        this.changeListenerHelper.fireEvent();
    }

    public void fireEvent(ChangeEvent ce) {
        this.changeListenerHelper.fireEvent(ce);
    }

    public void setEnabledEvents(boolean enabled) {
        this.changeListenerHelper.setEnabledEvents(enabled);
    }

    public boolean isEnabledEvents() {
        return this.changeListenerHelper.isEnabledEvents();
    }
}

