/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.expressionevaluator.swing.JExpressionPicker;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.impl.DefaultExpressionPickerController;

public class DefaultJExpressionPicker
extends JPanel
implements JExpressionPicker {
    private DefaultExpressionPickerController controller;
    private final DefaultExpressionEvaluatorSwingManager manager;
    private JButton button;
    private JTextField text;

    public DefaultJExpressionPicker(DefaultExpressionEvaluatorSwingManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    private void initComponents() {
        this.button = new JButton();
        this.text = new JTextField();
        this.controller = new DefaultExpressionPickerController(this.manager, this.text, this.button, null, null);
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this.text, "Center");
        this.add((Component)this.button, "After");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DefaultJExpressionPicker.this.text.requestFocusInWindow();
            }
        });
    }

    public ExpressionPickerController getController() {
        return this.controller;
    }

    public Expression getExpression() {
        return this.controller.get();
    }

    public Expression getExpressionWithOutHistory() {
        return this.controller.getWithOutHistory();
    }

    public void setExpression(Expression expression) {
        this.controller.set(expression);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void removeBorder() {
        Border empty = BorderFactory.createEmptyBorder();
        this.text.setBorder(empty);
        this.button.setBorder(empty);
    }

    public ExpressionBuilderConfig getConfig() {
        return this.controller.getConfig();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.button != null) {
            this.button.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.button != null) {
            this.button.setBackground(color);
        }
    }
}

