/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.util.URLUtils;

public class DefaultSimpleImage
implements SimpleImage {
    private BufferedImage image = null;
    private Object source = null;
    private Dimension dimensions = null;
    private String formatName = null;

    public static BufferedImage toBufferedImage(Image img) {
        if (img == null) {
            throw new IllegalArgumentException("null image.");
        }
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public DefaultSimpleImage() {
    }

    private DefaultSimpleImage(BufferedImage image, DefaultSimpleImage other) {
        this();
        this.image = image;
        this.source = other.source;
        this.formatName = other.formatName;
    }

    public DefaultSimpleImage(BufferedImage image) {
        this();
        this.image = image;
        this.source = image;
    }

    public DefaultSimpleImage(Object source) {
        this();
        this.source = source;
    }

    public void clean() {
        this.image = null;
        this.dimensions = null;
        this.source = null;
        this.formatName = null;
    }

    public BufferedImage getBufferedImage() {
        if (this.image == null && this.source != null) {
            Dimension dim = new Dimension();
            MutableObject theFormatName = new MutableObject(null);
            this.image = this.load(this.source, dim, (MutableObject<String>)theFormatName);
            this.dimensions = dim;
            this.formatName = (String)theFormatName.getValue();
        }
        return this.image;
    }

    public BufferedImage getBufferedImage(int page) {
        if (page == 0) {
            return this.getBufferedImage();
        }
        throw new NotImplementedException("Can't support multipage images");
    }

    public int getCountPages() {
        return 1;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public boolean isEmpty() {
        return this.image == null && this.source == null;
    }

    public void set(BufferedImage image) {
        this.image = image;
        this.source = image;
    }

    public void set(Object source) {
        this.image = null;
        this.source = source;
    }

    private BufferedImage load(Object source, Dimension dimensions, MutableObject<String> formatName) {
        BufferedImage theImage;
        block23: {
            theImage = null;
            if (formatName != null) {
                formatName.setValue(null);
            }
            try {
                InputStream is;
                if (source instanceof BufferedImage) {
                    theImage = (BufferedImage)source;
                    break block23;
                }
                if (source instanceof ImageIcon) {
                    ImageIcon icon = (ImageIcon)source;
                    int loadStatus = icon.getImageLoadStatus();
                    if (loadStatus != 8) {
                        icon.getDescription();
                    }
                    theImage = DefaultSimpleImage.toBufferedImage(icon.getImage());
                    break block23;
                }
                if (source instanceof Image) {
                    theImage = DefaultSimpleImage.toBufferedImage((Image)source);
                    break block23;
                }
                if (source instanceof byte[]) {
                    ByteArrayInputStream is2 = new ByteArrayInputStream((byte[])source);
                    theImage = ImageIO.read(is2);
                    if (formatName != null) {
                        formatName.setValue((Object)this.getFormatName(source));
                    }
                    break block23;
                }
                if (source instanceof File) {
                    theImage = ImageIO.read((File)source);
                    if (formatName != null) {
                        formatName.setValue((Object)this.getFormatName(source));
                    }
                    break block23;
                }
                if (source instanceof URL) {
                    theImage = URLUtils.isFileURL((URL)((URL)source)) ? ImageIO.read(URLUtils.toFile((URL)((URL)source))) : ImageIO.read((URL)source);
                    if (formatName != null) {
                        formatName.setValue((Object)this.getFormatName(source));
                    }
                    break block23;
                }
                if (!(source instanceof String)) break block23;
                String s = (String)source;
                File f = new File(s);
                byte[] data = null;
                if (f.exists()) {
                    is = new FileInputStream(f);
                } else {
                    try {
                        URL url = new URL(s);
                        is = url.openStream();
                        is.available();
                    }
                    catch (Exception ex) {
                        try {
                            data = Hex.decodeHex((char[])s.toCharArray());
                            is = new ByteArrayInputStream(data);
                        }
                        catch (DecoderException ex2) {
                            try {
                                data = Base64.decodeBase64((String)s);
                                is = new ByteArrayInputStream(data);
                            }
                            catch (Exception ex3) {
                                return null;
                            }
                        }
                    }
                }
                theImage = ImageIO.read(is);
                IOUtils.closeQuietly((InputStream)is);
                if (formatName != null && data != null) {
                    formatName.setValue((Object)this.getFormatName(data));
                }
            }
            catch (IOException ex) {
                return null;
            }
        }
        if (theImage != null && dimensions != null) {
            dimensions.width = theImage.getWidth();
            dimensions.height = theImage.getHeight();
        }
        return theImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFormatName(Object source) {
        ImageInputStream in = ImageIO.createImageInputStream(source);
        if (in == null) {
            return null;
        }
        Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
        if (readers == null || !readers.hasNext()) return null;
        ImageReader reader = readers.next();
        try {
            reader.setInput(in);
            String string = reader.getFormatName();
            reader.dispose();
            return string;
        }
        catch (Throwable throwable) {
            try {
                reader.dispose();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't determine format name of the image.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dimension loadDimensions(Object source) {
        try {
            ImageReader reader = null;
            Dimension dim = new Dimension();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])source);
                ImageInputStream in = ImageIO.createImageInputStream(bais);
                Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                if (readers != null && readers.hasNext()) {
                    reader = readers.next();
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    return dimension;
                }
            }
            catch (Throwable t) {
                dim = new Dimension();
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
            this.image = this.load(source, dim, null);
            return dim;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't load dimensions of the image.", ex);
        }
    }

    public int getWidth() {
        if (this.dimensions == null) {
            this.dimensions = this.loadDimensions(this.source);
        }
        return this.dimensions.width;
    }

    public int getHeight() {
        if (this.dimensions == null) {
            this.dimensions = this.loadDimensions(this.source);
        }
        return this.dimensions.height;
    }

    public DefaultSimpleImage resize(double factor) {
        BufferedImage theImage = this.getBufferedImage();
        int w = theImage.getWidth();
        int h = theImage.getHeight();
        int width = (int)((double)w * factor);
        int height = (int)((double)h * factor);
        BufferedImage newImage = new BufferedImage(width, height, theImage.getType());
        Graphics2D g = newImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(theImage, 0, 0, width, height, 0, 0, w, h, null);
        g.dispose();
        return new DefaultSimpleImage(newImage, this);
    }

    public DefaultSimpleImage resize(int width, int height) {
        BufferedImage theImage = this.getBufferedImage();
        int w = theImage.getWidth();
        int h = theImage.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, theImage.getType());
        Graphics2D g = newImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(theImage, 0, 0, width, height, 0, 0, w, h, null);
        g.dispose();
        return new DefaultSimpleImage(newImage, this);
    }

    public DefaultSimpleImage fitinto(int width, int height) {
        return this.resize(width, height);
    }

    public DefaultSimpleImage rotate(int angle) {
        BufferedImage theImage = this.getBufferedImage();
        int w = theImage.getWidth();
        int h = theImage.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, theImage.getType());
        Graphics2D g = newImage.createGraphics();
        g.rotate(Math.toRadians(angle), w / 2, h / 2);
        g.drawImage(theImage, null, 0, 0);
        g.dispose();
        return new DefaultSimpleImage(newImage, this);
    }

    public DefaultSimpleImage horizontalflip() {
        BufferedImage img = this.getBufferedImage();
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, img.getType());
        Graphics2D g = newImage.createGraphics();
        g.drawImage(img, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return new DefaultSimpleImage(newImage, this);
    }

    public DefaultSimpleImage verticalflip() {
        BufferedImage img = this.getBufferedImage();
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, img.getColorModel().getTransparency());
        Graphics2D g = newImage.createGraphics();
        g.drawImage(img, 0, 0, w, h, 0, h, w, 0, null);
        g.dispose();
        return new DefaultSimpleImage(newImage, this);
    }

    public DefaultSimpleImage transform(AffineTransform transform, int width, int height) {
        BufferedImage img = this.getBufferedImage();
        BufferedImage newImage = new BufferedImage(width, height, img.getColorModel().getTransparency());
        Graphics2D g = newImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setTransform(transform);
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return new DefaultSimpleImage(newImage, this);
    }

    public DefaultSimpleImage transform(AffineTransform transform) {
        BufferedImage img = this.getBufferedImage();
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, img.getColorModel().getTransparency());
        Graphics2D g = newImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setTransform(transform);
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return new DefaultSimpleImage(newImage, this);
    }

    private String bytearray_hex(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte abyte : data) {
            int v = abyte & 0xFF;
            builder.append(String.format("%02x", v));
        }
        return builder.toString();
    }

    public byte[] toBytearray() {
        return this.toBytearray(null);
    }

    public byte[] toBytearray(String format) {
        try {
            if (this.getBufferedImage() == null) {
                return null;
            }
            if (StringUtils.isBlank((CharSequence)format)) {
                format = this.formatName == null ? "png" : this.formatName;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.getBufferedImage(), format, baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            return imageInByte;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String toString() {
        byte[] data = this.toBytearray();
        return this.bytearray_hex(data);
    }

    public String toString(String format) {
        byte[] data = this.toBytearray(format);
        return this.bytearray_hex(data);
    }

    public String toStringBase64(String format) {
        byte[] data = this.toBytearray(format);
        return Base64.encodeBase64String((byte[])data);
    }

    public String toStringBase64() {
        byte[] data = this.toBytearray();
        return Base64.encodeBase64String((byte[])data);
    }

    public String toURL() {
        return "data:image/" + this.getFormatName() + ";base64," + this.toStringBase64();
    }

    public void save(File output, String formatName) throws IOException {
        if (StringUtils.isBlank((CharSequence)formatName)) {
            formatName = this.formatName == null ? "png" : this.formatName;
        }
        ImageIO.write((RenderedImage)this.getBufferedImage(), formatName, output);
    }

    public void save(OutputStream output, String formatName) throws IOException {
        if (StringUtils.isBlank((CharSequence)formatName)) {
            formatName = this.formatName == null ? "png" : this.formatName;
        }
        ImageIO.write((RenderedImage)this.getBufferedImage(), formatName, output);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleImage)) {
            return false;
        }
        SimpleImage other = (SimpleImage)obj;
        return this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        byte[] bytes = this.toBytearray();
        int hash = ArrayUtils.hashCode((Object)bytes);
        return hash;
    }
}

