/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.gvsig.tools.swing.impl.TreeComboCellRenderer;

public class TreeComboUtils {
    public static void setTreeModel(JComboBox comboBox, TreeModel aTreeModel) {
        ComboBoxModel model = TreeComboUtils.createComboBoxModel(aTreeModel);
        comboBox.setModel(model);
        comboBox.setRenderer(new TreeComboCellRenderer(model));
    }

    public static ComboBoxModel createComboBoxModel(TreeModel aTreeModel) {
        return new TreeModelToComboBoxModelAdapter(aTreeModel);
    }

    public static class TreeModelToComboBoxModelAdapter
    extends AbstractListModel
    implements ComboBoxModel,
    TreeModelListener {
        private static final long serialVersionUID = 922222366298284635L;
        TreeModel source;
        boolean invalid = true;
        DefaultMutableTreeNode currentValue;
        List<DefaultMutableTreeNode> cache = new ArrayList<DefaultMutableTreeNode>();

        public TreeModelToComboBoxModelAdapter(TreeModel aTreeModel) {
            this.source = aTreeModel;
            aTreeModel.addTreeModelListener(this);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this.currentValue != null && !this.currentValue.equals(anObject) || this.currentValue == null && anObject != null) {
                this.currentValue = this.getNode(anObject);
            }
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            if (this.currentValue == null) {
                return null;
            }
            return this.currentValue.getUserObject();
        }

        @Override
        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.cache.get(index).getUserObject();
        }

        public DefaultMutableTreeNode getNode(int index) {
            return this.cache.get(index);
        }

        public DefaultMutableTreeNode getNode(Object anObject) {
            for (DefaultMutableTreeNode node : this.cache) {
                if (!node.getUserObject().equals(anObject)) continue;
                return node;
            }
            return null;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        void validate() {
            if (this.invalid) {
                this.cache = new ArrayList<DefaultMutableTreeNode>();
                this.cacheTree(this.source.getRoot(), 0);
                if (this.cache.size() > 0) {
                    this.currentValue = this.cache.get(0);
                }
                this.invalid = false;
                this.fireContentsChanged(this, 0, 0);
            }
        }

        void cacheTree(Object anObject, int level) {
            if (this.source.isLeaf(anObject)) {
                this.addNode(anObject, level, false);
            } else {
                int c = this.source.getChildCount(anObject);
                this.addNode(anObject, level, true);
                ++level;
                for (int i = 0; i < c; ++i) {
                    Object child = this.source.getChild(anObject, i);
                    this.cacheTree(child, level);
                }
                --level;
            }
        }

        void addNode(Object anObject, int level, boolean isNode) {
            this.cache.add(new ListEntry(anObject, level, isNode));
        }

        private static class ListEntry
        extends DefaultMutableTreeNode {
            private static final long serialVersionUID = 304579876188493086L;
            int level;

            public ListEntry(Object anObject, int aLevel, boolean isNode) {
                super(anObject, isNode);
                this.setUserObject(anObject);
                this.level = aLevel;
            }

            @Override
            public int getLevel() {
                return this.level;
            }
        }
    }
}

