/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.hexeditor.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.gvsig.tools.swing.impl.hexeditor.event.SelectionChangedEvent;
import org.gvsig.tools.swing.impl.hexeditor.event.SelectionChangedListener;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexEditorComponent;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexTableModel;

class HexTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private final HexEditorComponent hexEditor;
    private HexTableModel model;
    int leadSelectionIndex;
    int anchorSelectionIndex;
    private static final Color ANTERNATING_CELL_COLOR = new Color(240, 240, 240);
    private CellEditor cellEditor = new CellEditor();

    public HexTable(HexEditorComponent hexEditor, HexTableModel model) {
        super(model);
        this.hexEditor = hexEditor;
        this.model = model;
        this.enableEvents(8L);
        this.setAutoResizeMode(0);
        this.setFont(new Font("Monospaced", 0, 14));
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(1);
        this.setDefaultEditor(Object.class, this.cellEditor);
        this.setDefaultRenderer(Object.class, new CellRenderer());
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Font headerFont = UIManager.getFont("TableHeader.font");
        FontMetrics headerFM = hexEditor.getFontMetrics(headerFont);
        int w = fm.stringWidth("www");
        w = Math.max(w, headerFM.stringWidth("+99"));
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            if (i < 16) {
                column.setPreferredWidth(w);
                continue;
            }
            column.setPreferredWidth(140);
        }
        this.setPreferredScrollableViewportSize(new Dimension(w * 16 + 140, 25 * this.getRowHeight()));
        this.leadSelectionIndex = 0;
        this.anchorSelectionIndex = 0;
    }

    public void addSelectionChangedListener(SelectionChangedListener l) {
        this.listenerList.add(SelectionChangedListener.class, l);
    }

    private int adjustColumn(int row, int col) {
        if (col < 0) {
            return 0;
        }
        if (row == this.getRowCount() - 1) {
            int lastRowCount = this.model.getByteCount() % 16;
            if (lastRowCount == 0) {
                lastRowCount = 16;
            }
            if (lastRowCount < 16) {
                return Math.min(col, this.model.getByteCount() % 16 - 1);
            }
        }
        return Math.min(col, this.getColumnCount() - 1 - 1);
    }

    public int cellToOffset(int row, int col) {
        if (row < 0 || row >= this.getRowCount() || col < 0 || col > 15) {
            return -1;
        }
        int offs = row * 16 + col;
        return offs >= 0 && offs < this.model.getByteCount() ? offs : -1;
    }

    @Override
    public void changeSelection(int row, int col, boolean toggle, boolean extend) {
        int prevSmallest = this.getSmallestSelectionIndex();
        int prevLargest = this.getLargestSelectionIndex();
        col = this.adjustColumn(row, col);
        if (row < 0) {
            row = 0;
        }
        this.repaintSelection();
        if (extend) {
            this.leadSelectionIndex = this.cellToOffset(row, col);
        } else {
            this.anchorSelectionIndex = this.leadSelectionIndex = this.cellToOffset(row, col);
        }
        if (this.getAutoscrolls()) {
            this.ensureCellIsVisible(row, col);
        }
        this.repaintSelection();
        this.fireSelectionChangedEvent(prevSmallest, prevLargest);
    }

    public void changeSelectionByOffset(int offset, boolean extend) {
        offset = Math.max(0, offset);
        offset = Math.min(offset, this.model.getByteCount() - 1);
        int row = offset / 16;
        int col = offset % 16;
        this.changeSelection(row, col, false, extend);
    }

    @Override
    public void clearSelection() {
        if (this.anchorSelectionIndex > -1) {
            this.leadSelectionIndex = this.anchorSelectionIndex;
        } else {
            this.leadSelectionIndex = 0;
            this.anchorSelectionIndex = 0;
        }
        this.repaintSelection();
    }

    private void ensureCellIsVisible(int row, int col) {
        Rectangle cellRect = this.getCellRect(row, col, false);
        if (cellRect != null) {
            this.scrollRectToVisible(cellRect);
        }
    }

    private void fireSelectionChangedEvent(int prevSmallest, int prevLargest) {
        SelectionChangedEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionChangedListener.class) continue;
            if (e == null) {
                e = new SelectionChangedEvent(this, prevSmallest, prevLargest, this.getSmallestSelectionIndex(), this.getLargestSelectionIndex());
            }
            ((SelectionChangedListener)listeners[i + 1]).selectionChanged(e);
        }
    }

    public byte getByte(int offset) {
        return this.model.getByte(offset);
    }

    public byte[] getBytes() {
        return this.model.getBytes();
    }

    public int getByteCount() {
        return this.model.getByteCount();
    }

    private Map getDesktopAntiAliasHints() {
        return (Map)this.getToolkit().getDesktopProperty("awt.font.desktophints");
    }

    public int getLargestSelectionIndex() {
        int index = Math.max(this.leadSelectionIndex, this.anchorSelectionIndex);
        return Math.max(index, 0);
    }

    public int getSmallestSelectionIndex() {
        int index = Math.min(this.leadSelectionIndex, this.anchorSelectionIndex);
        return Math.max(index, 0);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.cellToOffset(row, col) > -1;
    }

    @Override
    public boolean isCellSelected(int row, int col) {
        int offset = this.cellToOffset(row, col);
        if (offset == -1) {
            return false;
        }
        int start = this.getSmallestSelectionIndex();
        int end = this.getLargestSelectionIndex();
        return offset >= start && offset <= end;
    }

    public Point offsetToCell(int offset) {
        if (offset < 0 || offset >= this.model.getByteCount()) {
            return new Point(-1, -1);
        }
        int row = offset / 16;
        int col = offset % 16;
        return new Point(row, col);
    }

    public void open(String fileName) throws IOException {
        this.model.setBytes(fileName);
    }

    public void open(InputStream in) throws IOException {
        this.model.setBytes(in);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Object value = this.getValueAt(row, column);
        boolean isSelected = this.isCellSelected(row, column);
        boolean hasFocus = this.cellToOffset(row, column) == this.leadSelectionIndex;
        return renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            switch (e.getKeyCode()) {
                case 37: {
                    boolean extend = e.isShiftDown();
                    int offs = Math.max(this.leadSelectionIndex - 1, 0);
                    this.changeSelectionByOffset(offs, extend);
                    e.consume();
                    break;
                }
                case 39: {
                    boolean extend = e.isShiftDown();
                    int offs = Math.min(this.leadSelectionIndex + 1, this.model.getByteCount() - 1);
                    this.changeSelectionByOffset(offs, extend);
                    e.consume();
                    break;
                }
                case 38: {
                    boolean extend = e.isShiftDown();
                    int offs = Math.max(this.leadSelectionIndex - 16, 0);
                    this.changeSelectionByOffset(offs, extend);
                    e.consume();
                    break;
                }
                case 40: {
                    boolean extend = e.isShiftDown();
                    int offs = Math.min(this.leadSelectionIndex + 16, this.model.getByteCount() - 1);
                    this.changeSelectionByOffset(offs, extend);
                    e.consume();
                    break;
                }
                case 34: {
                    boolean extend = e.isShiftDown();
                    int visibleRowCount = this.getVisibleRect().height / this.getRowHeight();
                    int offs = Math.min(this.leadSelectionIndex + visibleRowCount * 16, this.model.getByteCount() - 1);
                    this.changeSelectionByOffset(offs, extend);
                    e.consume();
                    break;
                }
                case 33: {
                    boolean extend = e.isShiftDown();
                    int visibleRowCount = this.getVisibleRect().height / this.getRowHeight();
                    int offs = Math.max(this.leadSelectionIndex - visibleRowCount * 16, 0);
                    this.changeSelectionByOffset(offs, extend);
                    e.consume();
                    break;
                }
                case 36: {
                    boolean extend = e.isShiftDown();
                    int offs = this.leadSelectionIndex / 16 * 16;
                    this.changeSelectionByOffset(offs, extend);
                    e.consume();
                    break;
                }
                case 35: {
                    boolean extend = e.isShiftDown();
                    int offs = this.leadSelectionIndex / 16 * 16 + 15;
                    offs = Math.min(offs, this.model.getByteCount() - 1);
                    this.changeSelectionByOffset(offs, extend);
                    e.consume();
                }
            }
        }
        super.processKeyEvent(e);
    }

    public boolean redo() {
        return this.model.redo();
    }

    void removeBytes(int offs, int len) {
        this.model.removeBytes(offs, len);
    }

    private void repaintSelection() {
        this.repaint();
    }

    public void removeSelectionChangedListener(SelectionChangedListener l) {
        this.listenerList.remove(SelectionChangedListener.class, l);
    }

    public void replaceBytes(int offset, int len, byte[] bytes) {
        this.model.replaceBytes(offset, len, bytes);
    }

    public void setCellEditable(boolean cellEditable) {
        this.cellEditor.setEditable(cellEditable);
    }

    public void setSelectedRows(int min, int max) {
        if (min < 0 || min >= this.getRowCount() || max < 0 || max >= this.getRowCount()) {
            throw new IllegalArgumentException();
        }
        int startOffs = min * 16;
        int endOffs = max * 16 + 15;
        this.changeSelectionByOffset(startOffs, false);
        this.changeSelectionByOffset(endOffs, true);
    }

    public void setSelectionByOffsets(int startOffs, int endOffs) {
        startOffs = Math.max(0, startOffs);
        startOffs = Math.min(startOffs, this.model.getByteCount() - 1);
        this.repaintSelection();
        this.anchorSelectionIndex = startOffs;
        this.leadSelectionIndex = endOffs;
        if (this.getAutoscrolls()) {
            int endRow = endOffs / 16;
            int endCol = endOffs % 16;
            endCol = this.adjustColumn(endRow, endCol);
            if (endRow < 0) {
                endRow = 0;
            }
            this.ensureCellIsVisible(endRow, endCol);
        }
        this.repaintSelection();
    }

    public boolean undo() {
        return this.model.undo();
    }

    private static class EditorDocumentFilter
    extends DocumentFilter {
        private EditorDocumentFilter() {
        }

        private boolean ensureByteRepresented(String str) {
            try {
                int i = Integer.parseInt(str, 16);
                if (i < 0 || i > 255) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return false;
            }
            return true;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offs, String string, AttributeSet attr) throws BadLocationException {
            Document doc = fb.getDocument();
            String temp = doc.getText(0, offs) + string + doc.getText(offs, doc.getLength() - offs);
            if (this.ensureByteRepresented(temp)) {
                fb.insertString(offs, temp, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offs, int len, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            String temp = doc.getText(0, offs) + text + doc.getText(offs + len, doc.getLength() - (offs + len));
            if (this.ensureByteRepresented(temp)) {
                fb.replace(offs, len, text, attrs);
            }
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Point highlight = new Point();
        private Map desktopAAHints;

        public CellRenderer() {
            this.desktopAAHints = HexTable.this.getDesktopAntiAliasHints();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focus, row, column);
            this.highlight.setLocation(-1, -1);
            if (column == table.getColumnCount() - 1 && HexTable.this.hexEditor.getHighlightSelectionInAsciiDump()) {
                int selStart = HexTable.this.getSmallestSelectionIndex();
                int selEnd = HexTable.this.getLargestSelectionIndex();
                int b1 = row * 16;
                int b2 = b1 + 15;
                if (selStart <= b2 && selEnd >= b1) {
                    int start = Math.max(selStart, b1) - b1;
                    int end = Math.min(selEnd, b2) - b1;
                    this.highlight.setLocation(start, end);
                }
                boolean colorBG = HexTable.this.hexEditor.getAlternateRowBG() && (row & 1) > 0;
                this.setBackground(colorBG ? ANTERNATING_CELL_COLOR : table.getBackground());
            } else if (!selected) {
                if ((HexTable.this.hexEditor.getAlternateRowBG() && (row & 1) > 0) ^ (HexTable.this.hexEditor.getAlternateColumnBG() && (column & 1) > 0)) {
                    this.setBackground(ANTERNATING_CELL_COLOR);
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.highlight.x > -1) {
                int w = this.getFontMetrics(HexTable.this.getFont()).charWidth('w');
                g.setColor(HexTable.this.hexEditor.getHighlightSelectionInAsciiDumpColor());
                int x = this.getInsets().left + this.highlight.x * w;
                g.fillRect(x, 0, (this.highlight.y - this.highlight.x + 1) * w, HexTable.this.getRowHeight());
            }
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints oldHints = null;
            if (this.desktopAAHints != null) {
                oldHints = g2d.getRenderingHints();
                g2d.addRenderingHints(this.desktopAAHints);
            }
            g.setColor(this.getForeground());
            int x = 2;
            String text = this.getText();
            if (text.length() == 1) {
                x += g.getFontMetrics().charWidth('w');
            }
            g.drawString(text, x, 11);
            if (this.desktopAAHints != null) {
                g2d.addRenderingHints(oldHints);
            }
        }
    }

    private static class CellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 1L;
        private boolean editable;

        public CellEditor() {
            super(new JTextField());
            AbstractDocument doc = (AbstractDocument)((JTextComponent)this.editorComponent).getDocument();
            doc.setDocumentFilter(new EditorDocumentFilter());
            this.getComponent().addFocusListener(this);
            this.editable = true;
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTextField textField = (JTextField)this.getComponent();
            textField.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
            if (this.editable) {
                return super.getTableCellEditorComponent(table, value, selected, row, column);
            }
            return null;
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }

        @Override
        public boolean stopCellEditing() {
            String value = (String)this.getCellEditorValue();
            if (value.length() == 0) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return false;
            }
            return super.stopCellEditing();
        }
    }
}

